/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Random;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.recommender.MatrixRecommender;
import net.librec.util.Lists;
import net.librec.util.ZeroSetter;

public class RBMRecommender
extends MatrixRecommender {
    int featureNumber;
    int softmax;
    int maxIter;
    int tSteps;
    double epsilonw;
    double epsilonvb;
    double epsilonhb;
    double momentum;
    double lamtaw;
    double lamtab;
    double[][][] weights;
    double[][] visbiases;
    double[] hidbiases;
    double[][][] cDpos;
    double[][][] cDneg;
    double[][][] cDinc;
    double[] poshidact;
    double[] neghidact;
    char[] poshidstates;
    char[] neghidstates;
    double[] hidbiasinc;
    char[] curposhidstates;
    double[][] posvisact;
    double[][] negvisact;
    double[][] visbiasinc;
    double[][] negvisprobs;
    int[] negvissoftmax;
    int[] moviecount;
    String predictionType;
    BiMap<Double, Integer> ratingToIndex = HashBiMap.create();
    BiMap<Integer, Double> indexToRating = HashBiMap.create();

    @Override
    protected void setup() throws LibrecException {
        int i;
        super.setup();
        this.softmax = ratingScale.size();
        for (int i2 = 0; i2 < this.softmax; ++i2) {
            this.ratingToIndex.put((Double)ratingScale.get(i2), i2);
        }
        this.indexToRating = this.ratingToIndex.inverse();
        this.maxIter = this.conf.getInt("rec.iterator.maximum", 10);
        this.featureNumber = this.conf.getInt("rec.factor.number", 500);
        this.epsilonw = this.conf.getDouble("rec.epsilonw", 0.001);
        this.epsilonvb = this.conf.getDouble("rec.epsilonvb", 0.001);
        this.epsilonhb = this.conf.getDouble("rec.epsilonhb", 0.001);
        this.tSteps = this.conf.getInt("rec.tstep", 1);
        this.momentum = this.conf.getDouble("rec.momentum", 0.0);
        this.lamtaw = this.conf.getDouble("rec.lamtaw", 0.001);
        this.lamtab = this.conf.getDouble("rec.lamtab", 0.0);
        this.predictionType = this.conf.get("rec.predictiontype", "mean");
        this.weights = new double[this.numItems][this.softmax][this.featureNumber];
        this.visbiases = new double[this.numItems][this.softmax];
        this.hidbiases = new double[this.featureNumber];
        this.cDpos = new double[this.numItems][this.softmax][this.featureNumber];
        this.cDneg = new double[this.numItems][this.softmax][this.featureNumber];
        this.cDinc = new double[this.numItems][this.softmax][this.featureNumber];
        this.poshidact = new double[this.featureNumber];
        this.neghidact = new double[this.featureNumber];
        this.poshidstates = new char[this.featureNumber];
        this.neghidstates = new char[this.featureNumber];
        this.hidbiasinc = new double[this.featureNumber];
        this.curposhidstates = new char[this.featureNumber];
        this.posvisact = new double[this.numItems][this.softmax];
        this.negvisact = new double[this.numItems][this.softmax];
        this.visbiasinc = new double[this.numItems][this.softmax];
        this.negvisprobs = new double[this.numItems][this.softmax];
        this.negvissoftmax = new int[this.numItems];
        this.moviecount = new int[this.numItems];
        int[][] moviecount = new int[this.numItems][this.softmax];
        for (int u = 0; u < this.numUsers; ++u) {
            SequentialSparseVector userVec = this.trainMatrix.row(u);
            for (Vector.VectorEntry ve : userVec) {
                int m = ve.index();
                int r = (Integer)this.ratingToIndex.get(ve.get());
                int[] nArray = moviecount[m];
                int n = r;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (i = 0; i < this.numItems; ++i) {
            for (int j = 0; j < this.featureNumber; ++j) {
                for (int k = 0; k < this.softmax; ++k) {
                    this.weights[i][k][j] = Randoms.gaussian(0.0, 0.01);
                }
            }
        }
        ZeroSetter.zero(this.hidbiases, this.featureNumber);
        for (i = 0; i < this.numItems; ++i) {
            int k;
            int mtot = 0;
            for (k = 0; k < this.softmax; ++k) {
                mtot += moviecount[i][k];
            }
            for (k = 0; k < this.softmax; ++k) {
                this.visbiases[i][k] = mtot == 0 ? new Random().nextDouble() * 0.001 : Math.log((double)moviecount[i][k] / (double)mtot);
            }
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        int loopcount = 0;
        while (loopcount < this.maxIter) {
            ++loopcount;
            this.Zero();
            int[] visitingSeq = new int[this.numUsers];
            for (int i = 0; i < visitingSeq.length; ++i) {
                visitingSeq[i] = i;
            }
            Lists.shaffle(visitingSeq);
            for (int p = 0; p < visitingSeq.length; ++p) {
                int h;
                int u = visitingSeq[p];
                SequentialSparseVector userVec = this.trainMatrix.row(u);
                int num = this.trainMatrix.row(u).getNumEntries();
                double[] sumW = new double[this.featureNumber];
                this.negvisprobs = new double[this.numItems][this.softmax];
                for (Vector.VectorEntry ve : userVec) {
                    int m = ve.index();
                    int r = (Integer)this.ratingToIndex.get(ve.get());
                    int n = m;
                    this.moviecount[n] = this.moviecount[n] + 1;
                    double[] dArray = this.posvisact[m];
                    int n2 = r;
                    dArray[n2] = dArray[n2] + 1.0;
                    for (int h2 = 0; h2 < this.featureNumber; ++h2) {
                        int n3 = h2;
                        sumW[n3] = sumW[n3] + this.weights[m][r][h2];
                    }
                }
                for (h = 0; h < this.featureNumber; ++h) {
                    double probs = 1.0 / (1.0 + Math.exp(-sumW[h] - this.hidbiases[h]));
                    if (probs > Randoms.random()) {
                        this.poshidstates[h] = '\u0001';
                        int n = h;
                        this.poshidact[n] = this.poshidact[n] + 1.0;
                        continue;
                    }
                    this.poshidstates[h] = '\u0000';
                }
                for (h = 0; h < this.featureNumber; ++h) {
                    this.curposhidstates[h] = this.poshidstates[h];
                }
                int stepT = 0;
                do {
                    int h3;
                    int m;
                    boolean finalTStep = stepT + 1 >= this.tSteps;
                    for (Vector.VectorEntry ve : userVec) {
                        int r;
                        m = ve.index();
                        for (int h4 = 0; h4 < this.featureNumber; ++h4) {
                            if (this.curposhidstates[h4] != '\u0001') continue;
                            for (int r2 = 0; r2 < this.softmax; ++r2) {
                                double[] dArray = this.negvisprobs[m];
                                int n = r2;
                                dArray[n] = dArray[n] + this.weights[m][r2][h4];
                            }
                        }
                        for (int r3 = 0; r3 < this.softmax; ++r3) {
                            this.negvisprobs[m][r3] = 1.0 / (1.0 + Math.exp(-this.negvisprobs[m][r3] - this.visbiases[m][r3]));
                        }
                        double tsum = 0.0;
                        for (r = 0; r < this.softmax; ++r) {
                            tsum += this.negvisprobs[m][r];
                        }
                        if (tsum != 0.0) {
                            r = 0;
                            while (r < this.softmax) {
                                double[] dArray = this.negvisprobs[m];
                                int n = r++;
                                dArray[n] = dArray[n] / tsum;
                            }
                        }
                        double randval = Randoms.random();
                        for (int ratingIndex = 0; ratingIndex < this.softmax; ++ratingIndex) {
                            double d;
                            randval -= this.negvisprobs[m][ratingIndex];
                            if (!(d <= 0.0)) continue;
                            this.negvissoftmax[m] = ratingIndex;
                            break;
                        }
                        if (!finalTStep) continue;
                        double[] dArray = this.negvisact[m];
                        int n = this.negvissoftmax[m];
                        dArray[n] = dArray[n] + 1.0;
                    }
                    ZeroSetter.zero(sumW, this.featureNumber);
                    for (Vector.VectorEntry ve : userVec) {
                        m = ve.index();
                        for (int h5 = 0; h5 < this.featureNumber; ++h5) {
                            int n = h5;
                            sumW[n] = sumW[n] + this.weights[m][this.negvissoftmax[m]][h5];
                        }
                    }
                    for (h3 = 0; h3 < this.featureNumber; ++h3) {
                        double probs = 1.0 / (1.0 + Math.exp(-sumW[h3] - this.hidbiases[h3]));
                        if (probs > Randoms.random()) {
                            this.neghidstates[h3] = '\u0001';
                            if (!finalTStep) continue;
                            int n = h3;
                            this.neghidact[n] = this.neghidact[n] + 1.0;
                            continue;
                        }
                        this.neghidstates[h3] = '\u0000';
                    }
                    if (finalTStep) continue;
                    for (h3 = 0; h3 < this.featureNumber; ++h3) {
                        this.curposhidstates[h3] = this.neghidstates[h3];
                    }
                    ZeroSetter.zero(this.negvisprobs, this.numItems, this.softmax);
                } while (++stepT < this.tSteps);
                for (Vector.VectorEntry ve : userVec) {
                    int m = ve.index();
                    int r = (Integer)this.ratingToIndex.get(ve.get());
                    for (int h6 = 0; h6 < this.featureNumber; ++h6) {
                        if (this.poshidstates[h6] == '\u0001') {
                            double[] dArray = this.cDpos[m][r];
                            int n = h6;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        double[] dArray = this.cDneg[m][this.negvissoftmax[m]];
                        int n = h6;
                        dArray[n] = dArray[n] + (double)this.neghidstates[h6];
                    }
                }
                this.update(u, num);
            }
        }
    }

    private void update(int user, int num) {
        int bSize = 100;
        if ((user + 1) % bSize == 0 || user + 1 == this.numUsers) {
            int numcases = user % bSize;
            ++numcases;
            for (int m = 0; m < this.numItems; ++m) {
                if (this.moviecount[m] == 0) continue;
                for (int h = 0; h < this.featureNumber; ++h) {
                    for (int r = 0; r < this.softmax; ++r) {
                        double CDp = this.cDpos[m][r][h];
                        double CDn = this.cDneg[m][r][h];
                        if (CDp == 0.0 && CDn == 0.0) continue;
                        this.cDinc[m][r][h] = this.momentum * this.cDinc[m][r][h] + this.epsilonw * ((CDp /= (double)this.moviecount[m]) - (CDn /= (double)this.moviecount[m]) - this.lamtaw * this.weights[m][r][h]);
                        double[] dArray = this.weights[m][r];
                        int n = h;
                        dArray[n] = dArray[n] + this.cDinc[m][r][h];
                    }
                }
                for (int r = 0; r < this.softmax; ++r) {
                    if (this.posvisact[m][r] == 0.0 && this.negvisact[m][r] == 0.0) continue;
                    double[] dArray = this.posvisact[m];
                    int n = r;
                    dArray[n] = dArray[n] / (double)this.moviecount[m];
                    double[] dArray2 = this.negvisact[m];
                    int n2 = r;
                    dArray2[n2] = dArray2[n2] / (double)this.moviecount[m];
                    this.visbiasinc[m][r] = this.momentum * this.visbiasinc[m][r] + this.epsilonvb * (this.posvisact[m][r] - this.negvisact[m][r] - this.lamtab * this.visbiases[m][r]);
                    double[] dArray3 = this.visbiases[m];
                    int n3 = r;
                    dArray3[n3] = dArray3[n3] + this.visbiasinc[m][r];
                }
            }
            for (int h = 0; h < this.featureNumber; ++h) {
                if (this.poshidact[h] == 0.0 && this.neghidact[h] == 0.0) continue;
                int n = h;
                this.poshidact[n] = this.poshidact[n] / (double)numcases;
                int n4 = h;
                this.neghidact[n4] = this.neghidact[n4] / (double)numcases;
                this.hidbiasinc[h] = this.momentum * this.hidbiasinc[h] + this.epsilonhb * (this.poshidact[h] - this.neghidact[h] - this.lamtab * this.hidbiases[h]);
                int n5 = h;
                this.hidbiases[n5] = this.hidbiases[n5] + this.hidbiasinc[h];
            }
            this.Zero();
        }
    }

    private void Zero() {
        this.cDpos = new double[this.numItems][this.softmax][this.featureNumber];
        this.cDneg = new double[this.numItems][this.softmax][this.featureNumber];
        this.poshidact = new double[this.featureNumber];
        this.neghidact = new double[this.featureNumber];
        this.posvisact = new double[this.numItems][this.softmax];
        this.negvisact = new double[this.numItems][this.softmax];
        this.moviecount = new int[this.numItems];
    }

    @Override
    protected double predict(int u, int m) throws LibrecException {
        int r;
        int h;
        double[] scoreProbs = new double[this.softmax];
        double[] factorProbs = new double[this.featureNumber];
        SequentialSparseVector userVec = this.trainMatrix.row(u);
        double[] sumW = new double[this.featureNumber];
        for (Vector.VectorEntry ve : userVec) {
            int item = ve.index();
            int rateIdx = (Integer)this.ratingToIndex.get(ve.get());
            for (int h2 = 0; h2 < this.featureNumber; ++h2) {
                int n = h2;
                sumW[n] = sumW[n] + this.weights[item][rateIdx][h2];
            }
        }
        for (h = 0; h < this.featureNumber; ++h) {
            factorProbs[h] = 1.0 / (1.0 + Math.exp(0.0 - sumW[h] - this.hidbiases[h]));
        }
        for (h = 0; h < this.featureNumber; ++h) {
            for (int r2 = 0; r2 < this.softmax; ++r2) {
                int n = r2;
                scoreProbs[n] = scoreProbs[n] + factorProbs[h] * this.weights[m][r2][h];
            }
        }
        double probSum = 0.0;
        for (r = 0; r < this.softmax; ++r) {
            scoreProbs[r] = 1.0 / (1.0 + Math.exp(0.0 - scoreProbs[r] - this.visbiases[m][r]));
            probSum += scoreProbs[r];
        }
        r = 0;
        while (r < this.softmax) {
            int n = r++;
            scoreProbs[n] = scoreProbs[n] / probSum;
        }
        double predict2 = 0.0;
        if (this.predictionType.equals("max")) {
            int max_index = 0;
            double max_value = scoreProbs[0];
            for (int r3 = 0; r3 < this.softmax; ++r3) {
                if (!(scoreProbs[r3] > max_value)) continue;
                max_index = r3;
            }
            predict2 = (Double)this.indexToRating.get(max_index);
        } else if (this.predictionType.equals("mean")) {
            double mean = 0.0;
            for (int r4 = 0; r4 < this.softmax; ++r4) {
                mean += scoreProbs[r4] * (Double)this.indexToRating.get(r4);
            }
            predict2 = mean;
        }
        return predict2;
    }
}

