/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedDenseVector;
import net.librec.recommender.cf.rating.BiasedMFRecommender;

@ModelData(value={"isRating", "svdplusplus", "userFactors", "itemFactors", "userBiases", "itemBiases", "impItemFactors", "trainMatrix"})
public class SVDPlusPlusRecommender
extends BiasedMFRecommender {
    protected DenseMatrix impItemFactors;
    private double regImpItem;
    private DenseVector factorVector;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.regImpItem = this.conf.getDouble("rec.impItem.regularization", 0.015);
        this.impItemFactors = new DenseMatrix(this.numItems, this.numFactors);
        this.impItemFactors.init(this.initMean, this.initStd);
        this.factorVector = new VectorBasedDenseVector(this.numFactors);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iterationStep = 1; iterationStep <= this.numIterations; ++iterationStep) {
            this.loss = 0.0;
            for (int userIndex = 0; userIndex < this.numUsers; ++userIndex) {
                SequentialSparseVector userVector = this.trainMatrix.row(userIndex);
                if (userVector.size() == 0) continue;
                double[] steps = new double[this.numFactors];
                this.factorVector.assign((index, value) -> 0.0);
                for (Vector.VectorEntry vectorEntry : userVector) {
                    this.factorVector.assign((index, value) -> this.impItemFactors.row(vectorEntry.index()).get(index) + value);
                }
                double scale = Math.pow(userVector.getNumEntries(), -0.5);
                this.factorVector.assign((index, value) -> value * scale);
                for (Vector.VectorEntry vectorEntry : userVector) {
                    int itemIndex = vectorEntry.index();
                    double error = vectorEntry.get() - this.predict(userIndex, itemIndex, this.factorVector);
                    this.loss += error * error;
                    double userBias = this.userBiases.get(userIndex);
                    this.userBiases.plus(userIndex, (double)this.learnRate * (error - this.regBias * userBias));
                    this.loss += this.regBias * userBias * userBias;
                    double itemBias = this.itemBiases.get(itemIndex);
                    this.itemBiases.plus(itemIndex, (double)this.learnRate * (error - this.regBias * itemBias));
                    this.loss += this.regBias * itemBias * itemBias;
                    int factorIndex = 0;
                    while (factorIndex < this.numFactors) {
                        double userFactor = this.userFactors.get(userIndex, factorIndex);
                        double itemFactor = this.itemFactors.get(itemIndex, factorIndex);
                        this.userFactors.plus(userIndex, factorIndex, (double)this.learnRate * (error * itemFactor - (double)this.regUser * userFactor));
                        this.itemFactors.plus(itemIndex, factorIndex, (double)this.learnRate * (error * (userFactor + this.factorVector.get(factorIndex)) - (double)this.regItem * itemFactor));
                        this.loss += (double)this.regUser * userFactor * userFactor + (double)this.regItem * itemFactor * itemFactor;
                        int n = factorIndex++;
                        steps[n] = steps[n] + error * itemFactor * scale;
                    }
                }
                int size = userVector.getNumEntries();
                for (Vector.VectorEntry vectorEntry : userVector) {
                    int index2 = vectorEntry.index();
                    for (int factorIndex = 0; factorIndex < this.numFactors; ++factorIndex) {
                        double factor = this.impItemFactors.get(index2, factorIndex);
                        this.impItemFactors.plus(index2, factorIndex, (double)this.learnRate * (steps[factorIndex] - this.regImpItem * factor * (double)size));
                        this.loss += this.regImpItem * factor * factor * (double)size;
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iterationStep) && this.earlyStop) break;
            this.updateLRate(iterationStep);
        }
    }

    private double predict(int userIndex, int itemIndex, DenseVector factorVector) {
        double value = this.userBiases.get(userIndex) + this.itemBiases.get(itemIndex) + this.globalMean;
        DenseVector userFactorVector = this.userFactors.row(userIndex);
        DenseVector itemFactorVector = this.itemFactors.row(itemIndex);
        for (int index = 0; index < this.numFactors; ++index) {
            value += (factorVector.get(index) + userFactorVector.get(index)) * itemFactorVector.get(index);
        }
        return value;
    }

    @Override
    protected double predict(int userIndex, int itemIndex) {
        SequentialSparseVector userVector = this.trainMatrix.row(userIndex);
        this.factorVector.assign((index, value) -> 0.0);
        for (Vector.VectorEntry vectorEntry : userVector) {
            this.factorVector.assign((index, value) -> this.impItemFactors.row(vectorEntry.index()).get(index) + value);
        }
        double scale = Math.sqrt(userVector.getNumEntries());
        if (scale > 0.0) {
            this.factorVector.assign((index, value) -> value / scale);
        }
        return this.predict(userIndex, itemIndex, this.factorVector);
    }
}

