/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.content;

import java.util.List;
import java.util.Random;
import lombok.NonNull;
import org.datavec.api.util.RandomUtils;
import org.nd4j.linalg.primitives.Pair;

public class ConvMFDocumentProvider {
    private final List<String> documents;
    private final List<double[]> labels;
    private final Random rng;
    private final int[] order;
    private int cursor;
    private int labelSize;
    private int numDoc;

    public ConvMFDocumentProvider(@NonNull List<String> documents, @NonNull List<double[]> labelsForSentences) {
        this(documents, labelsForSentences, new Random());
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForSentences");
        }
        if (documents == null) {
            throw new NullPointerException("document");
        }
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForDocuments");
        }
    }

    public ConvMFDocumentProvider(@NonNull List<String> documents, @NonNull List<double[]> labelsForDocuments, Random rng) {
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        if (labelsForDocuments == null) {
            throw new NullPointerException("labelsForDocuments");
        }
        this.cursor = 0;
        if (documents == null) {
            throw new NullPointerException("documents");
        }
        if (labelsForDocuments == null) {
            throw new NullPointerException("labelsForDocuments");
        }
        if (documents.size() != labelsForDocuments.size()) {
            throw new IllegalArgumentException("Documents and labels must be same cardinality (documents cardinality: " + documents.size() + ", labels cardinality: " + labelsForDocuments.size() + ")");
        }
        this.documents = documents;
        this.labels = labelsForDocuments;
        this.labelSize = labelsForDocuments.get(0).length;
        this.rng = rng;
        this.numDoc = this.documents.size();
        if (rng == null) {
            this.order = null;
        } else {
            this.order = new int[documents.size()];
            int i = 0;
            while (i < documents.size()) {
                this.order[i] = i++;
            }
            RandomUtils.shuffleInPlace((int[])this.order, (Random)rng);
        }
    }

    public boolean hasNext() {
        return this.cursor < this.documents.size();
    }

    public Pair<String, double[]> nextSentence() {
        int idx = this.rng == null ? this.cursor++ : this.order[this.cursor++];
        return new Pair((Object)this.documents.get(idx), (Object)this.labels.get(idx));
    }

    public void reset() {
        this.cursor = 0;
        if (this.rng != null) {
            RandomUtils.shuffleInPlace((int[])this.order, (Random)this.rng);
        }
    }

    public int totalNumSentences() {
        return this.documents.size();
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public int getNumDoc() {
        return this.numDoc;
    }
}

