/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.content;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.RandomAccessSparseVector;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.recommender.TensorRecommender;
import org.apache.commons.lang.StringUtils;

public class EFMRecommender
extends TensorRecommender {
    protected int numberOfFeatures;
    protected int explicitFeatureNum;
    protected int hiddenFeatureNum;
    protected double scoreScale;
    protected DenseMatrix featureMatrix;
    protected DenseMatrix userFeatureMatrix;
    protected DenseMatrix userHiddenMatrix;
    protected DenseMatrix itemFeatureMatrix;
    protected DenseMatrix itemHiddenMatrix;
    protected SequentialAccessSparseMatrix userFeatureAttention;
    protected SequentialAccessSparseMatrix itemFeatureQuality;
    protected double lambdaX;
    protected double lambdaY;
    protected double lambdaU;
    protected double lambdaH;
    protected double lambdaV;
    protected BiMap<String, Integer> featureDict;
    protected SequentialAccessSparseMatrix trainMatrix;
    public BiMap<Integer, String> featureSentimemtPairsMappingData;
    boolean doExplain;

    @Override
    protected void setup() throws LibrecException {
        Object te2;
        super.setup();
        this.scoreScale = this.maxRate - this.minRate;
        this.explicitFeatureNum = this.conf.getInt("rec.factor.explicit", 5);
        this.hiddenFeatureNum = this.numFactors - this.explicitFeatureNum;
        this.lambdaX = this.conf.getDouble("rec.regularization.lambdax", 0.001);
        this.lambdaY = this.conf.getDouble("rec.regularization.lambday", 0.001);
        this.lambdaU = this.conf.getDouble("rec.regularization.lambdau", 0.001);
        this.lambdaH = this.conf.getDouble("rec.regularization.lambdah", 0.001);
        this.lambdaV = this.conf.getDouble("rec.regularization.lambdav", 0.001);
        this.featureSentimemtPairsMappingData = DataFrame.getInnerMapping("sentiment").inverse();
        this.trainMatrix = this.trainTensor.rateMatrix();
        this.featureDict = HashBiMap.create();
        HashMap<Integer, String> userFeatureDict = new HashMap<Integer, String>();
        HashMap<Integer, String> itemFeatureDict = new HashMap<Integer, String>();
        this.numberOfFeatures = 0;
        for (Object te2 : this.trainTensor) {
            String[] fSPList;
            int[] entryKeys = te2.keys();
            int userIndex = entryKeys[0];
            int itemIndex = entryKeys[1];
            int featureSentimentPairsIndex = entryKeys[2];
            String featureSentimentPairsString = (String)this.featureSentimemtPairsMappingData.get(featureSentimentPairsIndex);
            for (String p : fSPList = featureSentimentPairsString.split(" ")) {
                String k = p.split(":")[0];
                if (!this.featureDict.containsKey(k) && !StringUtils.isEmpty(k)) {
                    this.featureDict.put(k, this.numberOfFeatures);
                    ++this.numberOfFeatures;
                }
                if (userFeatureDict.containsKey(userIndex)) {
                    userFeatureDict.put(userIndex, (String)userFeatureDict.get(userIndex) + " " + p);
                } else {
                    userFeatureDict.put(userIndex, p);
                }
                if (itemFeatureDict.containsKey(itemIndex)) {
                    itemFeatureDict.put(itemIndex, (String)itemFeatureDict.get(itemIndex) + " " + p);
                    continue;
                }
                itemFeatureDict.put(itemIndex, p);
            }
        }
        this.featureMatrix = new DenseMatrix(this.numberOfFeatures, this.explicitFeatureNum);
        this.featureMatrix.init(0.01);
        this.userFeatureMatrix = new DenseMatrix(this.numUsers, this.explicitFeatureNum);
        this.userFeatureMatrix.init(1.0);
        this.userHiddenMatrix = new DenseMatrix(this.numUsers, this.numFactors - this.explicitFeatureNum);
        this.userHiddenMatrix.init(1.0);
        this.itemFeatureMatrix = new DenseMatrix(this.numItems, this.explicitFeatureNum);
        this.itemFeatureMatrix.init(1.0);
        this.itemHiddenMatrix = new DenseMatrix(this.numItems, this.numFactors - this.explicitFeatureNum);
        this.itemHiddenMatrix.init(1.0);
        HashBasedTable<Integer, Integer, Double> userFeatureAttentionTable = HashBasedTable.create();
        te2 = userFeatureDict.keySet().iterator();
        while (te2.hasNext()) {
            String[] fList;
            int u = (Integer)te2.next();
            double[] featureValues = new double[this.numberOfFeatures];
            for (String a : fList = ((String)userFeatureDict.get(u)).split(" ")) {
                int fin;
                if (StringUtils.isEmpty(a)) continue;
                int n = fin = ((Integer)this.featureDict.get(a.split(":")[0])).intValue();
                featureValues[n] = featureValues[n] + 1.0;
            }
            for (int i = 0; i < this.numberOfFeatures; ++i) {
                if (featureValues[i] == 0.0) continue;
                double v = 1.0 + (this.scoreScale - 1.0) * (2.0 / (1.0 + Math.exp(-featureValues[i])) - 1.0);
                userFeatureAttentionTable.put(u, i, v);
            }
        }
        this.userFeatureAttention = new SequentialAccessSparseMatrix(this.numUsers, this.numberOfFeatures, userFeatureAttentionTable);
        HashBasedTable<Integer, Integer, Double> itemFeatureQualityTable = HashBasedTable.create();
        Iterator iterator = itemFeatureDict.keySet().iterator();
        while (iterator.hasNext()) {
            String[] fList;
            int p = (Integer)iterator.next();
            double[] featureValues = new double[this.numberOfFeatures];
            for (String a : fList = ((String)itemFeatureDict.get(p)).split(" ")) {
                int fin;
                if (StringUtils.isEmpty(a)) continue;
                int n = fin = ((Integer)this.featureDict.get(a.split(":")[0])).intValue();
                featureValues[n] = featureValues[n] + Double.parseDouble(a.split(":")[1]);
            }
            for (int i = 0; i < this.numberOfFeatures; ++i) {
                if (featureValues[i] == 0.0) continue;
                double v = 1.0 + (this.scoreScale - 1.0) / (1.0 + Math.exp(-featureValues[i]));
                itemFeatureQualityTable.put(p, i, v);
            }
        }
        this.itemFeatureQuality = new SequentialAccessSparseMatrix(this.numItems, this.numberOfFeatures, itemFeatureQualityTable);
        this.doExplain = this.conf.getBoolean("rec.explain.flag");
        this.LOG.info("numUsers:" + this.numUsers);
        this.LOG.info("numItems:" + this.numItems);
        this.LOG.info("numFeatures:" + this.numberOfFeatures);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.conf.getInt("rec.iterator.maximum"); ++iter) {
            SequentialSparseVector userRatingsVector;
            int itemIdx;
            SequentialSparseVector itemRatingsVector;
            int userIdx;
            double denominator;
            RandomAccessSparseVector qualityPredVec;
            this.loss = 0.0;
            this.updateProgress(0);
            for (int featureIdx = 0; featureIdx < this.numberOfFeatures; ++featureIdx) {
                SequentialSparseVector attentionVec = this.userFeatureAttention.column(featureIdx);
                SequentialSparseVector qualityVec = this.itemFeatureQuality.column(featureIdx);
                if (attentionVec.getNumEntries() <= 0 || qualityVec.getNumEntries() <= 0) continue;
                RandomAccessSparseVector attentionPredVec = new RandomAccessSparseVector(this.numUsers);
                qualityPredVec = new RandomAccessSparseVector(this.numItems);
                for (int userIdx2 : attentionVec.getIndices()) {
                    attentionPredVec.set(userIdx2, this.predUserAttention(userIdx2, featureIdx));
                }
                for (int itemIdx2 : qualityVec.getIndices()) {
                    qualityPredVec.set(itemIdx2, this.predItemQuality(itemIdx2, featureIdx));
                }
                for (int factorIdx = 0; factorIdx < this.explicitFeatureNum; ++factorIdx) {
                    DenseVector factorUsersVector = this.userFeatureMatrix.column(factorIdx);
                    DenseVector factorItemsVector = this.itemFeatureMatrix.column(factorIdx);
                    double numerator = this.lambdaX * factorUsersVector.dot(attentionVec) + this.lambdaY * factorItemsVector.dot(qualityVec);
                    denominator = this.lambdaX * factorUsersVector.dot(attentionPredVec) + this.lambdaY * factorItemsVector.dot(qualityPredVec) + this.lambdaV * this.featureMatrix.get(featureIdx, factorIdx) + 1.0E-9;
                    this.featureMatrix.set(featureIdx, factorIdx, this.featureMatrix.get(featureIdx, factorIdx) * Math.sqrt(numerator / denominator));
                }
            }
            this.updateProgress(20);
            for (userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                itemRatingsVector = this.trainMatrix.row(userIdx);
                SequentialSparseVector attentionVec = this.userFeatureAttention.row(userIdx);
                if (itemRatingsVector.getNumEntries() <= 0 || attentionVec.getNumEntries() <= 0) continue;
                RandomAccessSparseVector itemPredictsVector = new RandomAccessSparseVector(this.numItems);
                RandomAccessSparseVector attentionPredVec = new RandomAccessSparseVector(this.numberOfFeatures);
                for (int itemIdx3 : itemRatingsVector.getIndices()) {
                    itemPredictsVector.set(itemIdx3, this.predictWithoutBound(userIdx, itemIdx3));
                }
                for (int featureIdx : attentionVec.getIndices()) {
                    attentionPredVec.set(featureIdx, this.predUserAttention(userIdx, featureIdx));
                }
                for (int factorIdx = 0; factorIdx < this.explicitFeatureNum; ++factorIdx) {
                    DenseVector factorItemsVector = this.itemFeatureMatrix.column(factorIdx);
                    DenseVector featureVector = this.featureMatrix.column(factorIdx);
                    double numerator = factorItemsVector.dot(itemRatingsVector) + this.lambdaX * featureVector.dot(attentionVec);
                    denominator = factorItemsVector.dot(itemPredictsVector) + this.lambdaX * featureVector.dot(attentionPredVec) + this.lambdaU * this.userFeatureMatrix.get(userIdx, factorIdx) + 1.0E-9;
                    this.userFeatureMatrix.set(userIdx, factorIdx, this.userFeatureMatrix.get(userIdx, factorIdx) * Math.sqrt(numerator / denominator));
                }
            }
            this.updateProgress(40);
            for (itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                userRatingsVector = this.trainMatrix.column(itemIdx);
                SequentialSparseVector qualityVector = this.itemFeatureQuality.row(itemIdx);
                if (userRatingsVector.getNumEntries() <= 0 || qualityVector.getNumEntries() <= 0) continue;
                RandomAccessSparseVector userPredictsVector = new RandomAccessSparseVector(this.numUsers);
                qualityPredVec = new RandomAccessSparseVector(this.numberOfFeatures);
                for (int userIdx3 : userRatingsVector.getIndices()) {
                    userPredictsVector.set(userIdx3, this.predictWithoutBound(userIdx3, itemIdx));
                }
                for (int featureIdx : qualityVector.getIndices()) {
                    qualityPredVec.set(featureIdx, this.predItemQuality(itemIdx, featureIdx));
                }
                for (int factorIdx = 0; factorIdx < this.explicitFeatureNum; ++factorIdx) {
                    DenseVector factorUsersVector = this.userFeatureMatrix.column(factorIdx);
                    DenseVector featureVector = this.featureMatrix.column(factorIdx);
                    double numerator = factorUsersVector.dot(userRatingsVector) + this.lambdaY * featureVector.dot(qualityVector);
                    denominator = factorUsersVector.dot(userPredictsVector) + this.lambdaY * featureVector.dot(qualityPredVec) + this.lambdaU * this.itemFeatureMatrix.get(itemIdx, factorIdx) + 1.0E-9;
                    this.itemFeatureMatrix.set(itemIdx, factorIdx, this.itemFeatureMatrix.get(itemIdx, factorIdx) * Math.sqrt(numerator / denominator));
                }
            }
            this.updateProgress(60);
            for (userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                itemRatingsVector = this.trainMatrix.row(userIdx);
                if (itemRatingsVector.getNumEntries() <= 0) continue;
                RandomAccessSparseVector itemPredictsVector = new RandomAccessSparseVector(this.numItems);
                for (int itemIdx4 : itemRatingsVector.getIndices()) {
                    itemPredictsVector.set(itemIdx4, this.predictWithoutBound(userIdx, itemIdx4));
                }
                for (int factorIdx = 0; factorIdx < this.hiddenFeatureNum; ++factorIdx) {
                    DenseVector hiddenItemsVector = this.itemHiddenMatrix.column(factorIdx);
                    double numerator = hiddenItemsVector.dot(itemRatingsVector);
                    double denominator2 = hiddenItemsVector.dot(itemPredictsVector) + this.lambdaH * this.userHiddenMatrix.get(userIdx, factorIdx) + 1.0E-9;
                    this.userHiddenMatrix.set(userIdx, factorIdx, this.userHiddenMatrix.get(userIdx, factorIdx) * Math.sqrt(numerator / denominator2));
                }
            }
            this.updateProgress(90);
            for (itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                userRatingsVector = this.trainMatrix.column(itemIdx);
                if (userRatingsVector.getNumEntries() <= 0) continue;
                RandomAccessSparseVector userPredictsVector = new RandomAccessSparseVector(this.numUsers);
                for (int userIdx4 : userRatingsVector.getIndices()) {
                    userPredictsVector.set(userIdx4, this.predictWithoutBound(userIdx4, itemIdx));
                }
                for (int factorIdx = 0; factorIdx < this.hiddenFeatureNum; ++factorIdx) {
                    DenseVector hiddenUsersVector = this.userHiddenMatrix.column(factorIdx);
                    double numerator = hiddenUsersVector.dot(userRatingsVector);
                    double denominator3 = hiddenUsersVector.dot(userPredictsVector) + this.lambdaH * this.itemHiddenMatrix.get(itemIdx, factorIdx) + 1.0E-9;
                    this.itemHiddenMatrix.set(itemIdx, factorIdx, this.itemHiddenMatrix.get(itemIdx, factorIdx) * Math.sqrt(numerator / denominator3));
                }
            }
            this.updateProgress(100);
            for (MatrixEntry me : this.trainMatrix) {
                int userIdx5 = me.row();
                int itemIdx5 = me.column();
                double rating = me.get();
                double predRating = this.predictWithoutBound(userIdx5, itemIdx5);
                this.loss += (rating - predRating) * (rating - predRating);
            }
            for (MatrixEntry me : this.userFeatureAttention) {
                int userIdx6 = me.row();
                int featureIdx = me.column();
                double real = me.get();
                double pred = this.predUserAttention(userIdx6, featureIdx);
                this.loss += (real - pred) * (real - pred);
            }
            for (MatrixEntry me : this.itemFeatureQuality) {
                int itemIdx6 = me.row();
                int featureIdx = me.column();
                double real = me.get();
                double pred = this.predItemQuality(itemIdx6, featureIdx);
                this.loss += (real - pred) * (real - pred);
            }
            this.loss += this.lambdaU * (Math.pow(this.userFeatureMatrix.norm(), 2.0) + Math.pow(this.itemFeatureMatrix.norm(), 2.0));
            this.loss += this.lambdaH * (Math.pow(this.userHiddenMatrix.norm(), 2.0) + Math.pow(this.itemHiddenMatrix.norm(), 2.0));
            this.loss += this.lambdaV * Math.pow(this.featureMatrix.norm(), 2.0);
            this.LOG.info("iter:" + iter + ", loss:" + this.loss);
        }
        if (this.doExplain) {
            String[] userIds = this.conf.get("rec.explain.userids").split(" ");
            for (String userId : userIds) {
                this.explain(userId);
            }
        }
    }

    protected void explain(String userId) throws LibrecException {
        int userIdx = (Integer)this.userMappingData.get(userId);
        double[] predRatings = new double[this.numItems];
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            predRatings[itemIdx] = this.predictWithoutBound(userIdx, itemIdx);
        }
        int maxIndex = 0;
        int minIndex = 0;
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            double newnumber = predRatings[itemIdx];
            if (newnumber > predRatings[maxIndex]) {
                maxIndex = itemIdx;
            }
            if (!(newnumber < predRatings[minIndex])) continue;
            minIndex = itemIdx;
        }
        int recommendedItemIdx = maxIndex;
        int disRecommendedItemIdx = minIndex;
        String recommendedItemId = (String)this.itemMappingData.inverse().get(recommendedItemIdx);
        String disRecommendedItemId = (String)this.itemMappingData.inverse().get(disRecommendedItemIdx);
        double[] userFeatureValues = this.featureMatrix.times(this.userFeatureMatrix.row(userIdx)).getValues();
        double[] recItemFeatureValues = this.featureMatrix.times(this.itemFeatureMatrix.row(recommendedItemIdx)).getValues();
        double[] disRecItemFeatureValues = this.featureMatrix.times(this.itemFeatureMatrix.row(disRecommendedItemIdx)).getValues();
        Map userFeatureValueMap = new HashMap<Integer, Double>();
        for (int i = 0; i < this.numberOfFeatures; ++i) {
            userFeatureValueMap.put(i, userFeatureValues[i]);
        }
        userFeatureValueMap = EFMRecommender.sortByValue(userFeatureValueMap);
        int numFeatureToExplain = this.conf.getInt("rec.explain.numfeature");
        Object[] userTopFeatureIndices = Arrays.copyOfRange(userFeatureValueMap.keySet().toArray(), this.numberOfFeatures - numFeatureToExplain, this.numberOfFeatures);
        String[] userTopFeatureIds = new String[numFeatureToExplain];
        double[] userTopFeatureValues = new double[numFeatureToExplain];
        double[] recItemTopFeatureValues = new double[numFeatureToExplain];
        double[] disRecItemTopFeatureIdValues = new double[numFeatureToExplain];
        for (int i = 0; i < numFeatureToExplain; ++i) {
            int featureIdx = (Integer)userTopFeatureIndices[numFeatureToExplain - 1 - i];
            userTopFeatureValues[i] = userFeatureValues[featureIdx];
            recItemTopFeatureValues[i] = recItemFeatureValues[featureIdx];
            disRecItemTopFeatureIdValues[i] = disRecItemFeatureValues[featureIdx];
            userTopFeatureIds[i] = (String)this.featureDict.inverse().get(featureIdx);
        }
        StringBuilder userFeatureSb = new StringBuilder();
        StringBuilder recItemFeatureSb = new StringBuilder();
        StringBuilder disRecItemFeatureSb = new StringBuilder();
        for (int i = 0; i < numFeatureToExplain; ++i) {
            userFeatureSb.append(userTopFeatureIds[i]).append(":").append(this.normalize(userTopFeatureValues[i])).append("\n");
            recItemFeatureSb.append(userTopFeatureIds[i]).append(":").append(this.normalize(recItemTopFeatureValues[i])).append("\n");
            disRecItemFeatureSb.append(userTopFeatureIds[i]).append(":").append(this.normalize(disRecItemTopFeatureIdValues[i])).append("\n");
        }
        this.LOG.info("user " + userId + "'s most cared features are \n" + userFeatureSb);
        this.LOG.info("item " + recommendedItemId + "'s feature values are\n" + recItemFeatureSb);
        this.LOG.info("item " + disRecommendedItemId + "'s feature values are\n" + disRecItemFeatureSb);
        this.LOG.info("So we recommend item " + recommendedItemId + ", disRecommend item " + disRecommendedItemId + " to user " + userId);
        this.LOG.info("___________________________");
    }

    @Override
    protected double predict(int[] indices) {
        return this.predict(indices[0], indices[1]);
    }

    @Override
    protected double predict(int u, int j) {
        double pred = this.userFeatureMatrix.row(u).dot(this.itemFeatureMatrix.row(j)) + this.userHiddenMatrix.row(u).dot(this.itemHiddenMatrix.row(j));
        if (pred < this.minRate) {
            return this.minRate;
        }
        if (pred > this.maxRate) {
            return this.maxRate;
        }
        return pred;
    }

    protected double predictWithoutBound(int u, int j) {
        return this.userFeatureMatrix.row(u).dot(this.itemFeatureMatrix.row(j)) + this.userHiddenMatrix.row(u).dot(this.itemHiddenMatrix.row(j));
    }

    protected double predUserAttention(int userIdx, int featureIdx) {
        return this.userFeatureMatrix.row(userIdx).dot(this.featureMatrix.row(featureIdx));
    }

    protected double predItemQuality(int itemIdx, int featureIdx) {
        return this.itemFeatureMatrix.row(itemIdx).dot(this.featureMatrix.row(featureIdx));
    }

    protected static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected double normalize(double rating) {
        return (rating - this.minRate) / (this.maxRate - this.minRate);
    }
}

