/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.content;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.TensorEntry;
import net.librec.recommender.TensorRecommender;
import net.librec.similarity.CosineSimilarity;
import org.apache.commons.lang.StringUtils;

public class TFIDFRecommender
extends TensorRecommender {
    private BiMap<String, Integer> reviewMappingData;
    private Map<String, Integer> word2DocNum = new HashMap<String, Integer>();
    private Map<String, String> iwDict = new HashMap<String, String>();
    private Map<String, Double> idf = new HashMap<String, Double>();
    private Map<Integer, double[]> userVec = new HashMap<Integer, double[]>();
    private Map<Integer, double[]> itemVec = new HashMap<Integer, double[]>();
    private Table<Integer, Integer, double[]> featureVec_test = HashBasedTable.create();
    private CosineSimilarity similarity = new CosineSimilarity();
    private double smooth;

    @Override
    protected void setup() throws LibrecException {
        int[] entryKeys;
        super.setup();
        this.smooth = this.conf.getDouble("rec.tfidf.smooth", 1.0);
        this.reviewMappingData = DataFrame.getInnerMapping("review");
        int numberOfWords = 0;
        HashBasedTable<Integer, Integer, String> res = HashBasedTable.create();
        HashSet<String> wordSet = new HashSet<String>();
        for (TensorEntry tensorEntry : this.trainTensor) {
            entryKeys = tensorEntry.keys();
            int userIndex = entryKeys[0];
            int itemIndex = entryKeys[1];
            int reviewIndex = entryKeys[2];
            String reviewContent = (String)this.reviewMappingData.inverse().get(reviewIndex);
            String[] fReviewContent = reviewContent.split(":");
            for (String word : fReviewContent) {
                if (!this.iwDict.containsKey(word) && StringUtils.isNotEmpty(word)) {
                    this.iwDict.put(word, String.valueOf(numberOfWords));
                    ++numberOfWords;
                }
                wordSet.add(this.iwDict.get(word));
            }
            for (String word : wordSet) {
                if (!this.word2DocNum.containsKey(word)) {
                    this.word2DocNum.put(word, 1);
                    continue;
                }
                this.word2DocNum.put(word, this.word2DocNum.get(word) + 1);
            }
            wordSet.clear();
            res.put(userIndex, itemIndex, reviewContent);
        }
        for (TensorEntry tensorEntry : this.testTensor) {
            String[] fReviewContent;
            entryKeys = tensorEntry.keys();
            int reviewIndex = entryKeys[2];
            String reviewContent = (String)this.reviewMappingData.inverse().get(reviewIndex);
            for (String word : fReviewContent = reviewContent.split(":")) {
                if (this.iwDict.containsKey(word) || !StringUtils.isNotEmpty(word)) continue;
                this.iwDict.put(word, String.valueOf(numberOfWords));
                ++numberOfWords;
            }
        }
        for (String string : this.word2DocNum.keySet()) {
            this.idf.put(string, Math.log10((double)res.size() / ((double)this.word2DocNum.get(string).intValue() + this.smooth)));
        }
        HashBasedTable<Integer, Integer, double[]> featureVec = HashBasedTable.create();
        for (TensorEntry te : this.trainTensor) {
            int[] entryKeys2 = te.keys();
            int userIndex = entryKeys2[0];
            int itemIndex = entryKeys2[1];
            featureVec.put(userIndex, itemIndex, this.calcFeatureVector((String)this.reviewMappingData.inverse().get(entryKeys2[2])));
        }
        HashMap hashMap = new HashMap();
        HashMap itemCount = new HashMap();
        for (Table.Cell x : featureVec.cellSet()) {
            hashMap.put(x.getRowKey(), hashMap.containsKey(x.getRowKey()) ? (Integer)hashMap.get(x.getRowKey()) + 1 : 1);
            itemCount.put(x.getColumnKey(), itemCount.containsKey(x.getColumnKey()) ? (Integer)itemCount.get(x.getColumnKey()) + 1 : 1);
            if (this.userVec.containsKey(x.getRowKey())) {
                this.addVec(this.userVec.get(x.getRowKey()), (double[])x.getValue());
            } else {
                this.userVec.put((Integer)x.getRowKey(), new double[((double[])x.getValue()).length]);
                this.addVec(this.userVec.get(x.getRowKey()), (double[])x.getValue());
            }
            if (this.itemVec.containsKey(x.getColumnKey())) {
                this.addVec(this.itemVec.get(x.getColumnKey()), (double[])x.getValue());
                continue;
            }
            this.itemVec.put((Integer)x.getColumnKey(), new double[((double[])x.getValue()).length]);
            this.addVec(this.itemVec.get(x.getColumnKey()), (double[])x.getValue());
        }
        Iterator<Object> iterator = this.itemVec.keySet().iterator();
        while (iterator.hasNext()) {
            int item = (Integer)iterator.next();
            this.divVec(this.itemVec.get(item), (Integer)itemCount.get(item));
        }
        iterator = this.userVec.keySet().iterator();
        while (iterator.hasNext()) {
            int user = (Integer)iterator.next();
            this.divVec(this.userVec.get(user), (Integer)hashMap.get(user));
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
    }

    @Override
    protected double predict(int[] keys) throws LibrecException {
        return 0.0;
    }

    @Override
    protected double predict(int user, int item) {
        double sim = this.getSimilarity(this.userVec.get(user), this.itemVec.get(item));
        return sim;
    }

    double[] calcFeatureVector(String reviewContent) {
        double[] featureVector = new double[this.word2DocNum.size()];
        String[] content = reviewContent.split(":");
        HashMap<String, Integer> termNumber = new HashMap<String, Integer>();
        for (String word : content) {
            if (!termNumber.containsKey(this.iwDict.get(word))) {
                termNumber.put(this.iwDict.get(word), 1);
                continue;
            }
            termNumber.put(this.iwDict.get(word), (Integer)termNumber.get(this.iwDict.get(word)) + 1);
        }
        for (String word : termNumber.keySet()) {
            if (word == null || !this.idf.keySet().contains(word) || this.idf.get(word) == null) continue;
            featureVector[Integer.parseInt((String)word)] = (double)((Integer)termNumber.get(word)).intValue() / (double)content.length * this.idf.get(word);
        }
        return featureVector;
    }

    private void addVec(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b[i];
        }
    }

    private void divVec(double[] a, int de) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] / (double)de;
        }
    }

    protected double getSimilarity(double[] thisList, double[] thatList) {
        if (thisList == null || thatList == null || thisList.length < 1 || thatList.length < 1 || thisList.length != thatList.length) {
            return Double.NaN;
        }
        double innerProduct = 0.0;
        double thisPower2 = 0.0;
        double thatPower2 = 0.0;
        for (int i = 0; i < thisList.length; ++i) {
            innerProduct += thisList[i] * thatList[i];
            thisPower2 += thisList[i] * thisList[i];
            thatPower2 += thatList[i] * thatList[i];
        }
        return innerProduct / Math.sqrt(thisPower2 * thatPower2);
    }
}

