/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.recommender.MatrixRecommender;

@ModelData(value={"isRating", "external", "trainMatrix"})
public class ExternalRecommender
extends MatrixRecommender {
    List<Map<Integer, Integer>> userItemsPosList = Lists.newArrayList();

    @Override
    protected void trainModel() throws LibrecException {
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            HashMap<Integer, Integer> itemIndexPosMap = Maps.newHashMap();
            int[] itemIndices = this.trainMatrix.row(userIdx).getIndices();
            for (int i = 0; i < itemIndices.length; ++i) {
                itemIndexPosMap.put(itemIndices[i], i);
            }
            this.userItemsPosList.add(itemIndexPosMap);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        Map<Integer, Integer> currItemIndexPosMap = this.userItemsPosList.get(userIdx);
        return currItemIndexPosMap.get(itemIdx) != null ? (double)currItemIndexPosMap.get(itemIdx).intValue() : 0.0;
    }
}

