/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.recommender.MatrixRecommender;

public class PersonalityDiagnosisRecommender
extends MatrixRecommender {
    private float sigma;
    private double prior;
    List<Map<Integer, Integer>> userItemsPosList = Lists.newArrayList();

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.prior = 1.0 / (double)this.numUsers;
        this.sigma = this.conf.getFloat("rec.PersonalityDiagnosis.sigma").floatValue();
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            HashMap<Integer, Integer> itemIndexPosMap = Maps.newHashMap();
            int[] itemIndices = this.trainMatrix.row(userIdx).getIndices();
            for (int i = 0; i < itemIndices.length; ++i) {
                itemIndexPosMap.put(itemIndices[i], i);
            }
            this.userItemsPosList.add(itemIndexPosMap);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        double[] scaleProbs = new double[ratingScale.size()];
        SequentialSparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
        SequentialSparseVector userRatingsVector = this.trainMatrix.column(itemIdx);
        int index = 0;
        Iterator iterator = ratingScale.iterator();
        while (iterator.hasNext()) {
            double ratingValue = (Double)iterator.next();
            double prob = 0.0;
            for (Vector.VectorEntry vectorEntry : userRatingsVector) {
                int ratedUserIdx = vectorEntry.index();
                double userRatingValue = vectorEntry.get();
                SequentialSparseVector ratedItemRatingsVector = this.trainMatrix.row(ratedUserIdx);
                Map<Integer, Integer> currItemIndexPosMap = this.userItemsPosList.get(ratedUserIdx);
                double prod = 1.0;
                for (Vector.VectorEntry itemRatingEntry : itemRatingsVector) {
                    int ratedItemIdx = itemRatingEntry.index();
                    double itemRatingValue = itemRatingEntry.get();
                    if (currItemIndexPosMap.get(ratedItemIdx) == null) continue;
                    double ratedItemRatingValue = ratedItemRatingsVector.getAtPosition(currItemIndexPosMap.get(ratedItemIdx));
                    prod *= this.gaussian(itemRatingValue, ratedItemRatingValue, this.sigma);
                }
                prob += this.gaussian(ratingValue, userRatingValue, this.sigma) * prod;
            }
            scaleProbs[index++] = prob *= this.prior;
        }
        int maxIdx = 0;
        double max = -2.147483648E9;
        for (int ratingIdx = 0; ratingIdx < scaleProbs.length; ++ratingIdx) {
            if (!(scaleProbs[ratingIdx] > max)) continue;
            max = scaleProbs[ratingIdx];
            maxIdx = ratingIdx;
        }
        return (Double)ratingScale.get(maxIdx);
    }

    protected double gaussian(double x, double mu, double sigma) {
        return Math.exp(-0.5 * Math.pow(x - mu, 2.0) / (sigma * sigma));
    }
}

