/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.ext;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.recommender.MatrixRecommender;

@ModelData(value={"isRating", "slopeone", "devMatrix", "cardMatrix", "trainMatrix"})
public class SlopeOneRecommender
extends MatrixRecommender {
    private DenseMatrix devMatrix;
    private DenseMatrix cardMatrix;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.devMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.cardMatrix = new DenseMatrix(this.numItems, this.numItems);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            SequentialSparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
            for (Vector.VectorEntry itemIdxRating : itemRatingsVector) {
                int itemIdx = itemIdxRating.index();
                double userItemRating = itemIdxRating.get();
                for (Vector.VectorEntry comparedItemIdxRating : itemRatingsVector) {
                    int comparedItemIdx = comparedItemIdxRating.index();
                    if (itemIdx == comparedItemIdx) continue;
                    double comparedRating = comparedItemIdxRating.get();
                    this.devMatrix.set(itemIdx, comparedItemIdx, userItemRating - comparedRating);
                    this.cardMatrix.set(itemIdx, comparedItemIdx, 1.0);
                }
            }
        }
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            for (int comparedItemIdx = 0; comparedItemIdx < this.numItems; ++comparedItemIdx) {
                double card = this.cardMatrix.get(itemIdx, comparedItemIdx);
                if (!(card > 0.0)) continue;
                double sum2 = this.devMatrix.get(itemIdx, comparedItemIdx);
                this.devMatrix.set(itemIdx, comparedItemIdx, sum2 / card);
            }
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        SequentialSparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
        double predictRatings = 0.0;
        double cardinaryValues = 0.0;
        for (Vector.VectorEntry itemIdxRating : itemRatingsVector) {
            int comparedItemIdx = itemIdxRating.index();
            if (comparedItemIdx == itemIdx) continue;
            double userItemRating = itemIdxRating.get();
            double cardinaryValue = this.cardMatrix.get(itemIdx, comparedItemIdx);
            if (!(cardinaryValue > 0.0)) continue;
            predictRatings += (this.devMatrix.get(itemIdx, comparedItemIdx) + userItemRating) * cardinaryValue;
            cardinaryValues += cardinaryValue;
        }
        return cardinaryValues > 0.0 ? predictRatings / cardinaryValues : this.globalMean;
    }
}

