/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.hybrid;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.recommender.MatrixRecommender;

public class HybridRecommender
extends MatrixRecommender {
    Table<Integer, Integer, Double> userItemRanks = HashBasedTable.create();
    protected float lambda;
    Map<Integer, Integer> itemDegrees = new HashMap<Integer, Integer>();

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.lambda = this.conf.getFloat("rec.hybrid.lambda").floatValue();
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            this.itemDegrees.put(itemIdx, this.trainMatrix.column(itemIdx).size());
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
    }

    @Override
    protected synchronized double predict(int userIdx, int itemIdx) throws LibrecException {
        if (!this.userItemRanks.containsRow(userIdx)) {
            double sum2;
            this.userItemRanks.clear();
            SequentialSparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
            HashSet<Integer> itemsSet = Sets.newHashSetWithExpectedSize((int)((double)itemRatingsVector.size() * 1.5));
            for (Vector.VectorEntry vectorEntry : itemRatingsVector) {
                if (vectorEntry.get() == 0.0) continue;
                itemsSet.add(vectorEntry.index());
            }
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            for (int tempUserIdx = 0; tempUserIdx < this.numUsers; ++tempUserIdx) {
                SequentialSparseVector tempItemRatingsVector = this.trainMatrix.row(tempUserIdx);
                sum2 = 0.0;
                int tempItemsCount = tempItemRatingsVector.size();
                int[] nArray = tempItemRatingsVector.getIndices();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int tempItemIdx = nArray[i];
                    if (!itemsSet.contains(tempItemIdx)) continue;
                    sum2 += 1.0 / Math.pow(this.itemDegrees.get(tempItemIdx).intValue(), this.lambda);
                }
                if (tempItemsCount <= 0) continue;
                userResources.put(tempUserIdx, sum2 / (double)tempItemsCount);
            }
            for (int tempItemIdx = 0; tempItemIdx < this.numItems; ++tempItemIdx) {
                if (itemsSet.contains(tempItemIdx)) continue;
                SequentialSparseVector tempUserRatingsVector = this.trainMatrix.column(tempItemIdx);
                sum2 = 0.0;
                for (int tempUserIdx : tempUserRatingsVector.getIndices()) {
                    sum2 += userResources.containsKey(tempUserIdx) ? (Double)userResources.get(tempUserIdx) : 0.0;
                }
                double score = sum2 / Math.pow(this.itemDegrees.get(tempItemIdx).intValue(), 1.0f - this.lambda);
                this.userItemRanks.put(userIdx, tempItemIdx, score);
            }
        }
        return this.userItemRanks.contains(userIdx, itemIdx) ? this.userItemRanks.get(userIdx, itemIdx) : 0.0;
    }
}

