/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.item;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.librec.recommender.item.ContextKeyValueEntry;
import net.librec.recommender.item.KeyValue;
import net.librec.util.Lists;

public class RecommendedList {
    private boolean independentRanking = false;
    private transient List<List<KeyValue<Integer, Double>>> elementData;
    private transient TreeMultimap<Integer, KeyValue<Integer, Double>> contextMultimap = null;

    public RecommendedList(int initialCapacity) {
        this.elementData = new ArrayList<List<KeyValue<Integer, Double>>>(initialCapacity);
    }

    public RecommendedList(int initialCapacity, boolean independentRanking) {
        this.elementData = new ArrayList<List<KeyValue<Integer, Double>>>(initialCapacity);
        this.independentRanking = independentRanking;
    }

    public int size() {
        return this.elementData.size();
    }

    public void topNRank(int topN) {
        for (int contextIdx = 0; contextIdx < this.size(); ++contextIdx) {
            this.setList(contextIdx, Lists.sortKeyValueListTopK(this.elementData.get(contextIdx), true, topN));
        }
    }

    public void topNRankByIndex(int contextIdx, int topN) {
        this.setList(contextIdx, Lists.sortKeyValueListTopK(this.elementData.get(contextIdx), true, topN));
    }

    private void rangeCheck(int contextIdx) {
        int size = this.size();
        if (contextIdx > size || contextIdx < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(contextIdx, size));
        }
    }

    private String outOfBoundsMsg(int index, int size) {
        return " Context Index: " + index + ", Size: " + size;
    }

    public void setList(int contextIdx, List<KeyValue<Integer, Double>> elementList) {
        this.rangeCheck(contextIdx);
        this.elementData.set(contextIdx, elementList);
    }

    public void addList(ArrayList<KeyValue<Integer, Double>> elementList) {
        this.elementData.add(elementList);
    }

    public boolean add(int contextIdx, int key, double score) {
        this.rangeCheck(contextIdx);
        this.elementData.get(contextIdx).add(new KeyValue<Integer, Double>(key, score));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndependently(int userId, int itemId, double score) {
        if (this.contextMultimap == null) {
            RecommendedList recommendedList = this;
            synchronized (recommendedList) {
                this.contextMultimap = this.independentRanking ? TreeMultimap.create(Comparator.comparingInt(k -> k), Comparator.comparingDouble(v -> -((Double)v.value).doubleValue())) : TreeMultimap.create(Comparator.comparingInt(k -> k), Comparator.comparingInt(v -> (Integer)v.key));
            }
        }
        this.contextMultimap.put((Object)userId, new KeyValue<Integer, Double>(itemId, score));
    }

    public RecommendedList[] joinTransform(RecommendedList thatList, int topN) {
        int contextIdx = 0;
        this.elementData.parallelStream().forEach(keyValue -> {
            keyValue = null;
        });
        thatList.elementData.parallelStream().forEach(keyValue -> {
            keyValue = null;
        });
        for (Integer key : this.contextMultimap.keySet()) {
            int valueIdx = 0;
            SortedSet thatValue = thatList.getContextMultimap().get((Object)key);
            if (thatValue == null) continue;
            Iterator contextIte = this.contextMultimap.get((Object)key).iterator();
            Iterator thatContextIte = thatValue.iterator();
            while (contextIte.hasNext() && thatContextIte.hasNext()) {
                KeyValue contextValue = (KeyValue)contextIte.next();
                KeyValue thatContextValue = (KeyValue)thatContextIte.next();
                this.addList(new ArrayList<KeyValue<Integer, Double>>());
                thatList.addList(new ArrayList<KeyValue<Integer, Double>>());
                if (topN < 0) {
                    this.add(contextIdx, valueIdx, (Double)contextValue.getValue());
                    thatList.add(contextIdx, valueIdx, (Double)thatContextValue.getValue());
                    ++valueIdx;
                    continue;
                }
                if (topN <= valueIdx) break;
                this.add(contextIdx, valueIdx, (Double)contextValue.getValue());
                thatList.add(contextIdx, valueIdx, (Double)thatContextValue.getValue());
                ++valueIdx;
            }
            ++contextIdx;
        }
        return new RecommendedList[]{this, thatList};
    }

    public RecommendedList transform(int topN) {
        int contextIdx = 0;
        for (Integer key : this.contextMultimap.keySet()) {
            int valueIdx = 0;
            for (KeyValue value : this.contextMultimap.get((Object)key)) {
                this.addList(new ArrayList<KeyValue<Integer, Double>>());
                if (topN < 0) {
                    this.add(contextIdx, valueIdx, (Double)value.getValue());
                } else {
                    if (topN <= valueIdx) break;
                    this.add(contextIdx, valueIdx, (Double)value.getValue());
                }
                ++valueIdx;
            }
            ++contextIdx;
        }
        return this;
    }

    public TreeMultimap<Integer, KeyValue<Integer, Double>> getContextMultimap() {
        return this.contextMultimap;
    }

    public List<KeyValue<Integer, Double>> getKeyValueListByContext(int contextIdx) {
        this.rangeCheck(contextIdx);
        return this.elementData.get(contextIdx);
    }

    public Set<Integer> getKeySetByContext(int contextIdx) {
        this.rangeCheck(contextIdx);
        HashSet<Integer> keySet = new HashSet<Integer>();
        for (KeyValue<Integer, Double> keyValue : this.elementData.get(contextIdx)) {
            keySet.add(keyValue.getKey());
        }
        return keySet;
    }

    public Iterator<KeyValue<Integer, Double>> iterator(int contextIdx) {
        return this.elementData.get(contextIdx).iterator();
    }

    public Iterator<ContextKeyValueEntry> iterator() {
        return new RecommenderIterator();
    }

    private class RecommenderIterator
    implements Iterator<ContextKeyValueEntry> {
        private final ContextKeyValueEntry entry = new ContextKeyValueEntry();
        private int contextIdx = 0;
        private int keyIdx = 0;
        private Iterator<KeyValue<Integer, Double>> KeyValueEntryItr;

        RecommenderIterator() {
            this.KeyValueEntryItr = RecommendedList.this.iterator(this.contextIdx);
            while (!this.KeyValueEntryItr.hasNext() && this.contextIdx + 1 < RecommendedList.this.size()) {
                this.KeyValueEntryItr = RecommendedList.this.iterator(++this.contextIdx);
            }
        }

        @Override
        public boolean hasNext() {
            return this.KeyValueEntryItr.hasNext() || this.contextIdx + 1 < RecommendedList.this.size();
        }

        @Override
        public ContextKeyValueEntry next() {
            KeyValue<Integer, Double> KeyValueEntry = this.KeyValueEntryItr.next();
            this.entry.setContextIdx(this.contextIdx);
            this.entry.setKey(KeyValueEntry.getKey());
            this.entry.setValue(KeyValueEntry.getValue());
            this.entry.setKeyIdx(this.keyIdx);
            ++this.keyIdx;
            while (!this.KeyValueEntryItr.hasNext() && this.contextIdx + 1 < RecommendedList.this.size()) {
                this.KeyValueEntryItr = RecommendedList.this.iterator(++this.contextIdx);
                this.keyIdx = 0;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            ((List)RecommendedList.this.elementData.get(this.contextIdx)).remove(this.keyIdx);
        }

        public void setValue(double value) {
            ((KeyValue)((List)RecommendedList.this.elementData.get(this.contextIdx)).get(this.keyIdx)).setValue(value);
            this.entry.setValue(value);
        }
    }
}

