/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.nn.ranking;

import java.util.Collection;
import java.util.Map;
import net.librec.recommender.nn.ranking.CDAELayerImp;
import net.librec.recommender.nn.ranking.CDAEParamInitializer;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class CDAELayer
extends FeedForwardLayer {
    private int numUsers = 0;

    public CDAELayer() {
    }

    private CDAELayer(Builder builder) {
        super((FeedForwardLayer.Builder)builder);
        this.numUsers = builder.numUsers;
    }

    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        CDAELayerImp myCustomLayer = new CDAELayerImp(conf);
        myCustomLayer.setListeners(iterationListeners);
        myCustomLayer.setIndex(layerIndex);
        myCustomLayer.setParamsViewArray(layerParamsView);
        Map paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        myCustomLayer.setParamTable(paramTable);
        myCustomLayer.setConf(conf);
        return myCustomLayer;
    }

    public ParamInitializer initializer() {
        CDAEParamInitializer.numUsers = this.numUsers;
        return CDAEParamInitializer.getInstance();
    }

    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
            case "uw": {
                return this.l1;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
            case "uw": {
                return this.l2;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
            case "uw": {
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private int numUsers;

        public CDAELayer build() {
            return new CDAELayer(this);
        }

        public Builder setNumUsers(int numUsers) {
            this.numUsers = numUsers;
            return this;
        }
    }
}

