/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.nn.ranking;

import java.util.Arrays;
import net.librec.recommender.nn.ranking.CDAELayer;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class CDAELayerImp
extends BaseLayer<CDAELayer> {
    public CDAELayerImp(NeuralNetConfiguration conf) {
        super(conf);
    }

    public INDArray preOutput(INDArray x, boolean training) {
        if (x == null) {
            throw new IllegalArgumentException("No null input allowed");
        }
        this.setInput(x);
        return this.preOutput(training);
    }

    public INDArray preOutput(boolean training) {
        this.applyDropOutIfNecessary(training);
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        INDArray U = this.getParam("uw");
        if (this.input.rank() != 2 || this.input.columns() != W.rows()) {
            if (this.input.rank() != 2) {
                throw new DL4JInvalidInputException("Input that is not a matrix; expected matrix (rank 2), got rank " + this.input.rank() + " array with shape " + Arrays.toString(this.input.shape()) + ". Missing preprocessor or wrong input type? " + this.layerId());
            }
            throw new DL4JInvalidInputException("Input cardinality (" + this.input.columns() + " columns; shape = " + Arrays.toString(this.input.shape()) + ") is invalid: does not match layer input cardinality (layer # inputs = " + W.size(0) + ") " + this.layerId());
        }
        if (this.conf.isUseDropConnect() && training && this.conf.getLayer().getDropOut() > 0.0) {
            W = Dropout.applyDropConnect((Layer)this, (String)"W");
        }
        INDArray ret = this.input.mmul(W).addi(U).addiRowVector(b);
        if (this.maskArray != null) {
            this.applyMask(ret);
        }
        return ret;
    }

    public INDArray activate(boolean training) {
        return super.activate(training);
    }

    public boolean isPretrainLayer() {
        return false;
    }

    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray z = this.preOutput(true);
        INDArray delta = (INDArray)((CDAELayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            this.applyMask(delta);
        }
        DefaultGradient ret = new DefaultGradient();
        INDArray weightGrad = (INDArray)this.gradientViews.get("W");
        Nd4j.gemm((INDArray)this.input, (INDArray)delta, (INDArray)weightGrad, (boolean)true, (boolean)false, (double)1.0, (double)0.0);
        INDArray userWeightGrad = (INDArray)this.gradientViews.get("uw");
        userWeightGrad.assign(delta);
        INDArray biasGrad = (INDArray)this.gradientViews.get("b");
        biasGrad.assign(delta.sum(new int[]{0}));
        ret.gradientForVariable().put("W", weightGrad);
        ret.gradientForVariable().put("b", biasGrad);
        ret.gradientForVariable().put("uw", userWeightGrad);
        INDArray epsilonNext = ((INDArray)this.params.get("W")).mmul(delta.transpose()).transpose();
        return new Pair((Object)ret, (Object)epsilonNext);
    }

    public double calcL2(boolean backpropParamsOnly) {
        double l2Norm;
        if (!this.conf.isUseRegularization()) {
            return 0.0;
        }
        double l2Sum = 0.0;
        if (this.conf.getL2ByParam("W") > 0.0) {
            l2Norm = this.getParam("W").norm2Number().doubleValue();
            l2Sum += 0.5 * this.conf.getL2ByParam("W") * l2Norm * l2Norm;
        }
        if (this.conf.getL2ByParam("uw") > 0.0) {
            l2Norm = this.getParam("uw").norm2Number().doubleValue();
            l2Sum += 0.5 * this.conf.getL2ByParam("uw") * l2Norm * l2Norm;
        }
        if (this.conf.getL2ByParam("b") > 0.0) {
            l2Norm = this.getParam("b").norm2Number().doubleValue();
            l2Sum += 0.5 * this.conf.getL2ByParam("b") * l2Norm * l2Norm;
        }
        return l2Sum;
    }
}

