/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.nn.ranking;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.MatrixEntry;
import net.librec.recommender.MatrixRecommender;
import net.librec.recommender.nn.ranking.CDAELayer;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.LossFunctions;

@ModelData(value={"isRanking", "cdae", "CDAEModel", "predictedMatrix"})
public class CDAERecommender
extends MatrixRecommender {
    private int inputDim;
    private int hiddenDim;
    private double learningRate;
    private double momentum;
    private double lambdaReg;
    private int numIterations;
    private String hiddenActivation;
    private String outputActivation;
    private MultiLayerNetwork CDAEModel;
    private INDArray trainSet;
    private INDArray predictedMatrix;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.inputDim = this.numItems;
        this.hiddenDim = this.conf.getInt("rec.hidden.dimension");
        this.learningRate = this.conf.getDouble("rec.iterator.learnrate");
        this.lambdaReg = this.conf.getDouble("rec.weight.regularization");
        this.numIterations = this.conf.getInt("rec.iterator.maximum");
        this.hiddenActivation = this.conf.get("rec.hidden.activation");
        this.outputActivation = this.conf.get("rec.output.activation");
        int[] matrixShape = new int[]{this.numUsers, this.numItems};
        this.trainSet = Nd4j.zeros((int[])matrixShape);
        for (MatrixEntry me : this.trainMatrix) {
            this.trainSet.put(me.row(), me.column(), (Number)me.get());
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(6).iterations(1).updater(Updater.ADAM).learningRate(this.learningRate).weightInit(WeightInit.XAVIER).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).regularization(true).l2(this.lambdaReg).list().layer(0, (Layer)((CDAELayer.Builder)((CDAELayer.Builder)((CDAELayer.Builder)new CDAELayer.Builder().nIn(this.inputDim)).nOut(this.hiddenDim)).activation(Activation.fromString((String)this.hiddenActivation))).setNumUsers(this.numUsers).build()).layer(1, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder().nIn(this.hiddenDim)).nOut(this.inputDim)).lossFunction(LossFunctions.LossFunction.SQUARED_LOSS)).activation(Activation.fromString((String)this.outputActivation))).build()).pretrain(false).backprop(true).build();
        this.CDAEModel = new MultiLayerNetwork(conf);
        this.CDAEModel.init();
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            this.CDAEModel.fit(this.trainSet, this.trainSet);
            this.loss = this.CDAEModel.score();
            if (this.isConverged(iter) && this.earlyStop) break;
            this.lastLoss = this.loss;
        }
        this.predictedMatrix = this.CDAEModel.output(this.trainSet);
        for (MatrixEntry me : this.trainMatrix) {
            this.predictedMatrix.put(me.row(), me.column(), (Number)0);
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return this.predictedMatrix.getDouble(userIdx, itemIdx);
    }
}

