/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.nn.rating;

import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;

public class AutoRecLossFunction
implements ILossFunction {
    public static INDArray trainMask;

    private INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray yMinusyHat = Transforms.abs((INDArray)labels.sub(output));
        INDArray scoreArr = yMinusyHat.mul(yMinusyHat);
        scoreArr = scoreArr.mul(trainMask);
        if (mask != null) {
            scoreArr.muliColumnVector(mask);
        }
        return scoreArr;
    }

    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(new int[]{1});
    }

    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray yMinusyHat = labels.sub(output);
        INDArray dldyhat = yMinusyHat.mul((Number)-2);
        INDArray gradients = (INDArray)activationFn.backprop(preOutput.dup(), dldyhat).getFirst();
        gradients = gradients.mul(trainMask);
        if (mask != null) {
            gradients.muliColumnVector(mask);
        }
        return gradients;
    }

    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    public String toString() {
        return super.toString() + "AutoRecLossFunction";
    }

    public String name() {
        return "";
    }
}

