/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.poi;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.common.LibrecException;
import net.librec.data.convertor.appender.LocationDataAppender;
import net.librec.data.structure.AbstractBaseDataEntry;
import net.librec.data.structure.LibrecDataList;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.recommender.AbstractRecommender;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;

public class USGRecommender
extends AbstractRecommender {
    private SequentialAccessSparseMatrix socialSimilarityMatrix;
    private SequentialAccessSparseMatrix userSimilarityMatrix;
    private SequentialAccessSparseMatrix socialMatrix;
    private SequentialAccessSparseMatrix trainMatrix;
    private SequentialAccessSparseMatrix testMatrix;
    private double alpha;
    private double beta;
    private double eta;
    private double w0;
    private double w1;
    private int numPois;
    private int numUsers;
    private int limitUserNum;
    private static final int BSIZE = 0x100000;
    private String socialPath;
    private KeyValue<Double, Double>[] locationCoordinates;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        BiMap userIds = this.userMappingData.inverse();
        BiMap itemIds = this.itemMappingData.inverse();
        this.numPois = this.itemMappingData.size();
        this.numUsers = this.userMappingData.size();
        this.trainMatrix = (SequentialAccessSparseMatrix)this.getDataModel().getTrainDataSet();
        this.testMatrix = (SequentialAccessSparseMatrix)this.getDataModel().getTestDataSet();
        this.alpha = this.conf.getDouble("rec.alpha", 0.1);
        this.beta = this.conf.getDouble("rec.beta", 0.1);
        this.eta = this.conf.getDouble("rec.eta", 0.05);
        this.limitUserNum = this.conf.getInt("rec.limit.userNum", this.numUsers);
        this.locationCoordinates = ((LocationDataAppender)this.getDataModel().getDataAppender()).getLocationAppender();
        this.userSimilarityMatrix = this.context.getSimilarity().getSimilarityMatrix().toSparseMatrix();
        this.socialPath = this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.social.path");
        int[] numDroppedItemsArray = new int[this.numUsers];
        int maxNumTestItemsByUser = 0;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            numDroppedItemsArray[userIdx] = this.numPois - this.trainMatrix.row(userIdx).getNumEntries();
            int numTestItemsByUser = this.testMatrix.row(userIdx).getNumEntries();
            maxNumTestItemsByUser = maxNumTestItemsByUser < numTestItemsByUser ? numTestItemsByUser : maxNumTestItemsByUser;
        }
        this.conf.setInts("rec.eval.auc.dropped.num", numDroppedItemsArray);
        this.conf.setInt("rec.eval.key.test.max.num", maxNumTestItemsByUser);
        this.conf.setInt("rec.eval.item.num", this.testMatrix.columnSize());
        int[] itemPurchasedCount = new int[this.numPois];
        for (int itemIdx = 0; itemIdx < this.numPois; ++itemIdx) {
            int[] userArray;
            int userNum = 0;
            for (int userIdx : userArray = this.trainMatrix.column(itemIdx).getIndices()) {
                if (userIdx < 0 || userIdx >= this.limitUserNum) continue;
                ++userNum;
            }
            for (int userIdx : userArray = this.testMatrix.column(itemIdx).getIndices()) {
                if (userIdx < 0 || userIdx >= this.limitUserNum) continue;
                ++userNum;
            }
            itemPurchasedCount[itemIdx] = userNum;
        }
        this.conf.setInts("rec.eval.item.purchase.num", itemPurchasedCount);
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.LOG.info("start buliding socialmatrix" + new Date());
        try {
            this.buildSocialMatrix(this.socialPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.LOG.info("start buliding socialSimilarityMatrix" + new Date());
        this.buildSocialSimilarity();
        this.LOG.info("start fitting the powerlaw distribution" + new Date());
        this.fitPowerLaw();
    }

    public double[] predictScore(int userIdx, int itemIdx) {
        double[] predictScore = new double[]{0.0, 0.0, 0.0};
        int[] userArray = this.trainMatrix.column(itemIdx).getIndices();
        List<Integer> userList = Ints.asList(userArray);
        Iterator userSimIter = this.userSimilarityMatrix.row(userIdx).iterator();
        ArrayList<Double> neighborSimis = new ArrayList<Double>();
        while (userSimIter.hasNext()) {
            Vector.VectorEntry userRatingEntry = (Vector.VectorEntry)userSimIter.next();
            int similarUserIdx = userRatingEntry.index();
            if (!userList.contains(similarUserIdx)) continue;
            neighborSimis.add(userRatingEntry.get());
        }
        if (neighborSimis.size() == 0) {
            predictScore[0] = 0.0;
        } else {
            double sum2 = 0.0;
            for (int i = 0; i < neighborSimis.size(); ++i) {
                sum2 += ((Double)neighborSimis.get(i)).doubleValue();
            }
            predictScore[0] = sum2;
        }
        ArrayList<Double> socialNeighborSimis = new ArrayList<Double>();
        for (Vector.VectorEntry userRatingEntry : this.socialSimilarityMatrix.row(userIdx)) {
            int similarUserIdx = userRatingEntry.index();
            if (!userList.contains(similarUserIdx)) continue;
            socialNeighborSimis.add(userRatingEntry.get());
        }
        if (socialNeighborSimis.size() == 0) {
            predictScore[1] = 0.0;
        } else {
            double sum3 = 0.0;
            for (int i = 0; i < socialNeighborSimis.size(); ++i) {
                sum3 += ((Double)socialNeighborSimis.get(i)).doubleValue();
            }
            predictScore[1] = sum3;
        }
        double geoScore = 1.0;
        int[] itemList = this.trainMatrix.row(userIdx).getIndices();
        if (itemList.length == 0) {
            geoScore = 0.0;
        } else {
            for (int visitedPOI : itemList) {
                double distance = this.getDistance(this.locationCoordinates[visitedPOI].getKey(), this.locationCoordinates[visitedPOI].getValue(), this.locationCoordinates[itemIdx].getKey(), this.locationCoordinates[itemIdx].getValue());
                if (distance < 0.01) {
                    distance = 0.01;
                }
                geoScore *= this.w0 * Math.pow(distance, this.w1);
            }
        }
        predictScore[2] = geoScore;
        return predictScore;
    }

    public void buildSocialSimilarity() {
        HashBasedTable<Integer, Integer, Double> socialSimilarityTable = HashBasedTable.create();
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] socialNeighborList;
            SequentialSparseVector userVector = this.trainMatrix.row(userIdx);
            if (userVector.getNumEntries() == 0) continue;
            for (int socialNeighborIdx : socialNeighborList = this.socialMatrix.column(userIdx).getIndices()) {
                double sim;
                if (userIdx >= socialNeighborIdx) continue;
                SequentialSparseVector socialVector = this.trainMatrix.row(socialNeighborIdx);
                int[] friendList = this.socialMatrix.column(socialNeighborIdx).getIndices();
                if (socialVector.getNumEntries() == 0 || friendList.length == 0 || !(this.getCorrelation(userVector, socialVector) > 0.0) || !(this.getCorrelation(socialNeighborList, friendList) > 0.0) || Double.isNaN(sim = (1.0 - this.eta) * this.getCorrelation(userVector, socialVector) + this.eta * this.getCorrelation(socialNeighborList, friendList)) || sim == 0.0) continue;
                socialSimilarityTable.put(userIdx, socialNeighborIdx, sim);
            }
        }
        this.socialSimilarityMatrix = new SequentialAccessSparseMatrix(this.numUsers, this.numUsers, socialSimilarityTable);
    }

    public void fitPowerLaw() {
        HashMap<Integer, Double> distanceMap = new HashMap<Integer, Double>();
        HashMap<Double, Double> logdistanceMap = new HashMap<Double, Double>();
        int pairNum = 0;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            int[] itemList = this.trainMatrix.row(userIdx).getIndices();
            if (itemList.length == 0) continue;
            for (int i = 0; i < itemList.length - 1; ++i) {
                for (int j = i + 1; j < itemList.length; ++j) {
                    double distance = this.getDistance(this.locationCoordinates[itemList[i]].getKey(), this.locationCoordinates[itemList[i]].getValue(), this.locationCoordinates[itemList[j]].getKey(), this.locationCoordinates[itemList[j]].getValue());
                    if ((int)distance > 0) {
                        int intDistance = (int)distance;
                        if (!distanceMap.containsKey(intDistance)) {
                            distanceMap.put(intDistance, 0.0);
                        }
                        distanceMap.put(intDistance, (Double)distanceMap.get(intDistance) + 1.0);
                    }
                    ++pairNum;
                }
            }
        }
        for (Map.Entry distanceEntry : distanceMap.entrySet()) {
            logdistanceMap.put(Math.log10(((Integer)distanceEntry.getKey()).intValue()), Math.log10((Double)distanceEntry.getValue() * 1.0 / (double)pairNum));
        }
        this.w0 = Randoms.random();
        this.w1 = Randoms.random();
        double reg = 0.1;
        double lrate = 1.0E-5;
        int maxIterations = 2000;
        for (int i = 0; i < maxIterations; ++i) {
            double w0Gradient = 0.0;
            double w1Gradient = 0.0;
            for (Map.Entry distanceEntry : logdistanceMap.entrySet()) {
                double distance = (Double)distanceEntry.getKey();
                double probability = (Double)distanceEntry.getValue();
                w0Gradient += this.w0 + this.w1 * distance - probability;
                w1Gradient += (this.w0 + this.w1 * distance - probability) * distance;
            }
            this.w0 -= lrate * (w0Gradient + reg * this.w0);
            this.w1 -= lrate * (w1Gradient + reg * this.w1);
        }
        this.w0 = Math.pow(10.0, this.w0);
    }

    protected double getDistance(Double lat1, Double long1, Double lat2, Double long2) {
        if (Math.abs(lat1 - lat2) < 1.0E-6 && Math.abs(long1 - long2) < 1.0E-6) {
            return 0.0;
        }
        double degreesToRadius = Math.PI / 180;
        double phi1 = (90.0 - lat1) * degreesToRadius;
        double phi2 = (90.0 - lat2) * degreesToRadius;
        double theta1 = long1 * degreesToRadius;
        double theta2 = long2 * degreesToRadius;
        double cos = Math.sin(phi1) * Math.sin(phi2) * Math.cos(theta1 - theta2) + Math.cos(phi1) * Math.cos(phi2);
        double arc = Math.acos(cos);
        double earthRadius = 6371.0;
        return arc * earthRadius;
    }

    public double getCorrelation(SequentialSparseVector thisVector, SequentialSparseVector thatVector) {
        Set<Integer> elements = this.unionArrays(thisVector.getIndices(), thatVector.getIndices());
        int numAllElements = elements.size();
        int numCommonElements = thisVector.getIndices().length + thatVector.getIndices().length - numAllElements;
        return ((double)numCommonElements + 0.0) / (double)numAllElements;
    }

    public Set<Integer> unionArrays(int[] arr1, int[] arr2) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int num : arr1) {
            set.add(num);
        }
        for (int num : arr2) {
            set.add(num);
        }
        return set;
    }

    public double getCorrelation(int[] thisList, int[] thatList) {
        HashSet<Integer> elements = new HashSet<Integer>();
        for (int num : thisList) {
            elements.add(num);
        }
        for (int num : thatList) {
            elements.add(num);
        }
        int numAllElements = elements.size();
        int numCommonElements = thisList.length + thatList.length - numAllElements;
        return ((double)numCommonElements + 0.0) / (double)numAllElements;
    }

    @Override
    public RecommendedList recommendRating(DataSet predictDataSet) throws LibrecException {
        return null;
    }

    @Override
    public RecommendedList recommendRating(LibrecDataList<AbstractBaseDataEntry> dataList) throws LibrecException {
        return null;
    }

    @Override
    public RecommendedList recommendRank() throws LibrecException {
        this.LOG.info("Eveluate for users from id 0 to id\t" + (this.limitUserNum - 1));
        RecommendedList recommendedList = new RecommendedList(this.numUsers);
        for (int userIdx2 = 0; userIdx2 < this.numUsers; ++userIdx2) {
            recommendedList.addList(new ArrayList<KeyValue<Integer, Double>>());
        }
        ArrayList<Integer> userList = new ArrayList<Integer>();
        for (int userIdx3 = 0; userIdx3 < this.limitUserNum; ++userIdx3) {
            userList.add(userIdx3);
        }
        userList.parallelStream().forEach(userIdx -> {
            List<Integer> itemList = Ints.asList(this.trainMatrix.row((int)userIdx).getIndices());
            ArrayList<KeyValue<Integer, double[]>> tempItemValueList = new ArrayList<KeyValue<Integer, double[]>>();
            double[] maxScore = new double[]{0.0, 0.0, 0.0};
            for (int itemIdx = 0; itemIdx < this.numPois; ++itemIdx) {
                if (itemList.contains(itemIdx)) continue;
                double[] predictRating = this.predictScore((int)userIdx, itemIdx);
                if (predictRating[0] >= maxScore[0]) {
                    maxScore[0] = predictRating[0];
                }
                if (predictRating[1] >= maxScore[1]) {
                    maxScore[1] = predictRating[1];
                }
                if (predictRating[2] >= maxScore[2]) {
                    maxScore[2] = predictRating[2];
                }
                tempItemValueList.add(new KeyValue<Integer, double[]>(itemIdx, new double[]{predictRating[0], predictRating[1], predictRating[2]}));
            }
            ArrayList<KeyValue<Integer, Double>> itemValueList = new ArrayList<KeyValue<Integer, Double>>();
            for (KeyValue keyValue : tempItemValueList) {
                double[] scores = (double[])keyValue.getValue();
                if (maxScore[0] != 0.0) {
                    scores[0] = scores[0] / maxScore[0];
                }
                if (maxScore[1] != 0.0) {
                    scores[1] = scores[1] / maxScore[1];
                }
                if (maxScore[2] != 0.0) {
                    scores[2] = scores[2] / maxScore[2];
                }
                double predictRating = (1.0 - this.alpha - this.beta) * scores[0] + this.alpha * scores[1] + this.beta * scores[2];
                itemValueList.add(new KeyValue(keyValue.getKey(), predictRating));
            }
            recommendedList.setList((int)userIdx, (List<KeyValue<Integer, Double>>)itemValueList);
            recommendedList.topNRankByIndex((int)userIdx, this.topN);
        });
        if (recommendedList.size() == 0) {
            throw new IndexOutOfBoundsException("No item is recommended, there is something error in the recommendation algorithm! Please check it!");
        }
        this.LOG.info("end recommendation");
        return recommendedList;
    }

    @Override
    public RecommendedList recommendRank(LibrecDataList<AbstractBaseDataEntry> dataList) throws LibrecException {
        return null;
    }

    private void buildSocialMatrix(String inputDataPath) throws IOException {
        this.LOG.info("Now loading users' social relation data success! " + this.socialPath);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        final ArrayList files = new ArrayList();
        final ArrayList fileSizeList = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileSizeList.add(file.toFile().length());
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        Files.walkFileTree(Paths.get(inputDataPath, new String[0]), (FileVisitor<? super Path>)finder);
        long allFileSize = 0L;
        for (Long everyFileSize : fileSizeList) {
            allFileSize += everyFileSize.longValue();
        }
        for (File dataFile : files) {
            int len;
            FileInputStream fis = new FileInputStream(dataFile);
            FileChannel fileRead = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            String bufferLine = new String();
            byte[] bytes = new byte[0x100000];
            while ((len = fileRead.read(buffer)) != -1) {
                buffer.flip();
                buffer.get(bytes, 0, len);
                bufferLine = bufferLine.concat(new String(bytes, 0, len)).replaceAll("\r", "\n");
                String[] bufferData = bufferLine.split("(\n)+");
                boolean isComplete = bufferLine.endsWith("\n");
                int loopLength = isComplete ? bufferData.length : bufferData.length - 1;
                for (int i = 0; i < loopLength; ++i) {
                    String line = new String(bufferData[i]);
                    String[] data = line.trim().split("[ \t,]+");
                    String userA = data[0];
                    String userB = data[1];
                    Double rate = data.length >= 3 ? Double.valueOf(data[2]) : 1.0;
                    if (!this.userMappingData.containsKey(userA) || !this.userMappingData.containsKey(userB)) continue;
                    int row = (Integer)this.userMappingData.get(userA);
                    int col = (Integer)this.userMappingData.get(userB);
                    dataTable.put(row, col, rate);
                    dataTable.put(col, row, rate);
                }
                if (!isComplete) {
                    bufferLine = bufferData[bufferData.length - 1];
                }
                buffer.clear();
            }
            fileRead.close();
            fis.close();
        }
        int numRows2 = this.userMappingData.size();
        int numCols = this.userMappingData.size();
        this.socialMatrix = new SequentialAccessSparseMatrix(numRows2, numCols, dataTable);
        dataTable = null;
        this.LOG.info("Load users' social relation data success! " + this.socialPath);
    }
}

