/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.ArrayList;
import java.util.List;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.convertor.appender.ItemFeatureAppender;
import net.librec.data.convertor.appender.SocialDataAppender;
import net.librec.data.convertor.appender.UserFeatureAppender;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.Vector;
import net.librec.similarity.RecommenderSimilarity;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRecommenderSimilarity
implements RecommenderSimilarity {
    protected Configuration conf;
    protected SymmMatrix similarityMatrix;

    @Override
    public void buildSimilarityMatrix(DataModel dataModel) {
        this.conf = dataModel.getContext().getConf();
        String similarityKey = this.conf.get("rec.recommender.similarity.key", "user");
        if (StringUtils.isNotBlank(similarityKey)) {
            if (StringUtils.equals(similarityKey, "social")) {
                this.buildSocialSimilarityMatrix(dataModel);
            }
            if (StringUtils.contains(similarityKey, "feature")) {
                this.buildFeatureSimilarityMatrix(dataModel);
            } else {
                boolean isUser = StringUtils.equals(similarityKey, "user");
                SequentialAccessSparseMatrix trainMatrix = dataModel.getDataSplitter().getTrainData();
                int numUsers = trainMatrix.rowSize();
                int numItems = trainMatrix.columnSize();
                int count = isUser ? numUsers : numItems;
                this.similarityMatrix = new SymmMatrix(count);
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                for (int index = 0; index < count; ++index) {
                    indexList.add(index);
                }
                indexList.parallelStream().forEach(thisIndex -> {
                    SequentialSparseVector thisVector;
                    SequentialSparseVector sequentialSparseVector = thisVector = isUser ? trainMatrix.row((int)thisIndex) : trainMatrix.column((int)thisIndex);
                    if (thisVector.getNumEntries() != 0) {
                        for (int thatIndex = thisIndex + 1; thatIndex < count; ++thatIndex) {
                            double sim;
                            SequentialSparseVector thatVector;
                            SequentialSparseVector sequentialSparseVector2 = thatVector = isUser ? trainMatrix.row(thatIndex) : trainMatrix.column(thatIndex);
                            if (thatVector.getNumEntries() == 0 || Double.isNaN(sim = this.getCorrelation(thisVector, thatVector)) || sim == 0.0) continue;
                            this.similarityMatrix.set((int)thisIndex, thatIndex, sim);
                        }
                    }
                });
            }
        }
    }

    public void buildSocialSimilarityMatrix(DataModel dataModel) {
        SequentialAccessSparseMatrix trainMatrix = dataModel.getDataSplitter().getTrainData();
        SequentialAccessSparseMatrix socialMatrix = ((SocialDataAppender)dataModel.getDataAppender()).getUserAppender();
        int numUsers = trainMatrix.rowSize();
        this.similarityMatrix = new SymmMatrix(numUsers);
        for (int userIdx = 0; userIdx < numUsers; ++userIdx) {
            SequentialSparseVector userVector = trainMatrix.row(userIdx);
            if (userVector.getNumEntries() == 0) continue;
            SequentialSparseVector socialVector = socialMatrix.row(userIdx);
            for (Vector.VectorEntry vectorEntry : socialVector) {
                double sim;
                int socialUserIndex = vectorEntry.index();
                SequentialSparseVector socialUserVector = trainMatrix.row(socialUserIndex);
                if (socialUserVector.getNumEntries() == 0 || Double.isNaN(sim = this.getCorrelation(userVector, socialVector))) continue;
                this.similarityMatrix.set(userIdx, socialUserIndex, sim);
            }
        }
    }

    public void buildFeatureSimilarityMatrix(DataModel dataModel) {
        int numElements;
        String similarityKey = this.conf.get("rec.recommender.similarity.key", "user");
        boolean isUser = StringUtils.contains(similarityKey, "user");
        SequentialAccessSparseMatrix featureMatrix = isUser ? ((UserFeatureAppender)dataModel.getFeatureAppender()).getUserFeatures() : ((ItemFeatureAppender)dataModel.getFeatureAppender()).getItemFeatures();
        int count = numElements = featureMatrix.rowSize();
        this.similarityMatrix = new SymmMatrix(count);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int index = 0; index < count; ++index) {
            indexList.add(index);
        }
        indexList.parallelStream().forEach(thisIndex -> {
            SequentialSparseVector thisVector = featureMatrix.row((int)thisIndex);
            if (thisVector.getNumEntries() != 0) {
                for (int thatIndex = thisIndex + 1; thatIndex < count; ++thatIndex) {
                    double sim;
                    SequentialSparseVector thatVector = featureMatrix.row(thatIndex);
                    if (thatVector.getNumEntries() == 0 || Double.isNaN(sim = this.getCorrelation(thisVector, thatVector)) || sim == 0.0) continue;
                    this.similarityMatrix.set((int)thisIndex, thatIndex, sim);
                }
            }
        });
    }

    public double getCorrelation(SequentialSparseVector thisVector, SequentialSparseVector thatVector) {
        ArrayList<Double> thisList = new ArrayList<Double>();
        ArrayList<Double> thatList = new ArrayList<Double>();
        int thisPosition = 0;
        int thatPosition = 0;
        int thisSize = thisVector.getNumEntries();
        int thatSize = thatVector.getNumEntries();
        while (thisPosition < thisSize && thatPosition < thatSize) {
            int thatIndex;
            int thisIndex = thisVector.getIndexAtPosition(thisPosition);
            if (thisIndex == (thatIndex = thatVector.getIndexAtPosition(thatPosition))) {
                thisList.add(thisVector.getAtPosition(thisPosition));
                thatList.add(thatVector.getAtPosition(thatPosition));
                ++thisPosition;
                ++thatPosition;
                continue;
            }
            if (thisIndex > thatIndex) {
                ++thatPosition;
                continue;
            }
            ++thisPosition;
        }
        double sim = this.getSimilarity(thisList, thatList);
        if (!Double.isNaN(sim)) {
            int n = thisList.size();
            int shrinkage = this.conf.getInt("rec.similarity.shrinkage", 0);
            if (shrinkage > 0) {
                sim *= (double)n / ((double)(n + shrinkage) + 0.0);
            }
        }
        return sim;
    }

    public double getCorrelationIndependently(Configuration conf, SequentialSparseVector thisVector, SequentialSparseVector thatVector) {
        this.conf = conf;
        return this.getCorrelation(thisVector, thatVector);
    }

    protected abstract double getSimilarity(List<? extends Number> var1, List<? extends Number> var2);

    @Override
    public SymmMatrix getSimilarityMatrix() {
        return this.similarityMatrix;
    }
}

