/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.List;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class CosineSimilarity
extends AbstractRecommenderSimilarity {
    @Override
    protected double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        if (thisList == null || thatList == null || thisList.size() < 1 || thatList.size() < 1 || thisList.size() != thatList.size()) {
            return Double.NaN;
        }
        double innerProduct = 0.0;
        double thisPower2 = 0.0;
        double thatPower2 = 0.0;
        for (int i = 0; i < thisList.size(); ++i) {
            innerProduct += thisList.get(i).doubleValue() * thatList.get(i).doubleValue();
            thisPower2 += thisList.get(i).doubleValue() * thisList.get(i).doubleValue();
            thatPower2 += thatList.get(i).doubleValue() * thatList.get(i).doubleValue();
        }
        return innerProduct / Math.sqrt(thisPower2 * thatPower2);
    }
}

