/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.HashSet;
import java.util.List;
import net.librec.math.structure.Vector;
import net.librec.math.structure.VectorBasedSequentialSparseVector;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class JaccardSimilarity
extends AbstractRecommenderSimilarity {
    public double getCorrelation(VectorBasedSequentialSparseVector thisVector, VectorBasedSequentialSparseVector thatVector) {
        HashSet<Integer> elements = new HashSet<Integer>();
        for (Vector.VectorEntry vectorEntry : thisVector) {
            elements.add(vectorEntry.index());
        }
        for (Vector.VectorEntry vectorEntry : thatVector) {
            elements.add(vectorEntry.index());
        }
        int numAllElements = elements.size();
        int numCommonElements = thisVector.getNumEntries() + thatVector.getNumEntries() - numAllElements;
        return ((double)numCommonElements + 0.0) / (double)numAllElements;
    }

    @Override
    protected double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        return 0.0;
    }
}

