/*
 * Decompiled with CFR 0.152.
 */
package net.librec.similarity;

import java.util.List;
import net.librec.math.algorithm.Maths;
import net.librec.similarity.AbstractRecommenderSimilarity;

public class PCCSimilarity
extends AbstractRecommenderSimilarity {
    @Override
    public double getSimilarity(List<? extends Number> thisList, List<? extends Number> thatList) {
        if (thisList == null || thatList == null || thisList.size() < 2 || thatList.size() < 2 || thisList.size() != thatList.size()) {
            return Double.NaN;
        }
        double thisMu = Maths.mean(thisList);
        double thatMu = Maths.mean(thatList);
        double num = 0.0;
        double thisPow2 = 0.0;
        double thatPow2 = 0.0;
        for (int i = 0; i < thisList.size(); ++i) {
            double thisMinusMu = thisList.get(i).doubleValue() - thisMu;
            double thatMinusMu = thatList.get(i).doubleValue() - thatMu;
            num += thisMinusMu * thatMinusMu;
            thisPow2 += thisMinusMu * thisMinusMu;
            thatPow2 += thatMinusMu * thatMinusMu;
        }
        return num / (Math.sqrt(thisPow2) * Math.sqrt(thatPow2));
    }
}

