/*
 * Decompiled with CFR 0.152.
 */
package net.librec.tool.driver;

import java.io.FileInputStream;
import java.util.Properties;
import net.librec.conf.Configuration;
import net.librec.data.model.TextDataModel;
import net.librec.tool.LibrecTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class DataDriver
implements LibrecTool {
    @Override
    public int run(String[] args) throws Exception {
        String[] keyValuePair;
        String[] optionValues;
        Options options = new Options();
        options.addOption("build", false, "build model");
        options.addOption("load", false, "load model");
        options.addOption("save", false, "save model");
        options.addOption("conf", true, "the path of configuration file");
        options.addOption("jobconf", true, "a specified key-value pair for configuration");
        options.addOption("D", true, "a specified key-value pair for configuration");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args, false);
        Configuration conf = new Configuration();
        if (cmd.hasOption("conf")) {
            String confFilePath = cmd.getOptionValue("conf");
            Properties prop = new Properties();
            prop.load(new FileInputStream(confFilePath));
            for (String name : prop.stringPropertyNames()) {
                conf.set(name, prop.getProperty(name));
            }
        }
        if (cmd.hasOption("jobconf")) {
            for (String optionValue : optionValues = cmd.getOptionValues("jobconf")) {
                keyValuePair = optionValue.split("=");
                conf.set(keyValuePair[0], keyValuePair[1]);
            }
        }
        if (cmd.hasOption("D")) {
            for (String optionValue : optionValues = cmd.getOptionValues("D")) {
                keyValuePair = optionValue.split("=");
                conf.set(keyValuePair[0], keyValuePair[1]);
            }
        }
        TextDataModel dataModel = new TextDataModel(conf);
        dataModel.buildDataModel();
        System.out.println("well done!!!");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        DataDriver tool = new DataDriver();
        Options options = new Options();
        options.addOption("build", false, "build model");
        options.addOption("load", false, "load model");
        options.addOption("save", false, "save model");
        options.addOption("conf", true, "the path of configuration file");
        options.addOption("jobconf", true, "a specified key-value pair for configuration");
        options.addOption("D", true, "a specified key-value pair for configuration");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("build")) {
            tool.run(args);
        } else if (cmd.hasOption("load") || cmd.hasOption("save")) {
            // empty if block
        }
    }
}

