/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.librec.util.Systems;
import net.librec.util.URLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log LOG = LogFactory.getLog(FileUtil.class);
    public static final long ONE_KB = 1024L;
    public static final long ONE_K = 1000L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_M = 1000000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_G = 1000000000L;
    public static final String comma = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";

    private FileUtil() {
    }

    public static String formatBytes(long size) {
        String display = size / 0x40000000L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1.073741824E9) + " GB" : (size / 0x100000L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1048576.0) + " MB" : (size / 1024L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1024.0) + " KB" : String.valueOf(size) + " bytes"));
        return display;
    }

    public static String formatSize(long size) {
        String display = size / 1000000000L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1.0E9) + " G" : (size / 1000000L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1000000.0) + " M" : (size / 1000L > 0L ? String.format("%.2f", ((double)size + 0.0) / 1000.0) + " K" : String.valueOf(size)));
        return display;
    }

    public static String getResource(String filePath) {
        if (FileUtil.exist(filePath)) {
            return filePath;
        }
        String path = FileUtil.makeDirPath("src", "main", "resources") + filePath;
        if (FileUtil.exist(path)) {
            return path;
        }
        URL is = Class.class.getResource(filePath);
        if (is != null) {
            return is.getFile();
        }
        is = Class.class.getResource(path);
        if (is != null) {
            return is.getFile();
        }
        return null;
    }

    public static List<BufferedReader> getReader(String path) throws IOException, URISyntaxException {
        boolean isRelativePath;
        File file = new File(path);
        ArrayList<BufferedReader> readerList = new ArrayList<BufferedReader>();
        boolean bl = isRelativePath = !path.startsWith("/") && path.indexOf(":") <= 0;
        if (isRelativePath) {
            URL url;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FileUtil.class.getClassLoader();
            }
            if (null != (url = classLoader.getResource(path))) {
                file = new File(url.toURI());
            }
        }
        if (file.isFile()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            readerList.add(reader);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                readerList.add(reader);
            }
        }
        return readerList;
    }

    public static BufferedReader getReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedWriter getWriter(String path) throws Exception {
        return FileUtil.getWriter(new File(path));
    }

    public static BufferedWriter getWriter(File file) throws Exception {
        return new BufferedWriter(new FileWriter(file));
    }

    public static String getCurrentFolder() {
        return Paths.get("", new String[0]).toAbsolutePath().getFileName().toString();
    }

    public static String getCurrentPath() {
        return Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    public static String makeDirPath(String dirPath) {
        switch (Systems.getOs()) {
            case Windows: {
                dirPath = dirPath.replace('/', '\\');
                break;
            }
            default: {
                dirPath = dirPath.replace('\\', '/');
            }
        }
        if (!dirPath.endsWith(Systems.FILE_SEPARATOR)) {
            dirPath = dirPath + Systems.FILE_SEPARATOR;
        }
        return dirPath;
    }

    public static String makeDirPath(String ... dirs) {
        String dirPath = "";
        for (String dir : dirs) {
            dirPath = dirPath + FileUtil.makeDirPath(dir);
        }
        return dirPath;
    }

    public static String makeDirectory(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return FileUtil.makeDirPath(dir.getPath());
    }

    public static String makeDirectory(String ... dirs) {
        String dirPath = FileUtil.makeDirPath(dirs);
        return FileUtil.makeDirectory(dirPath);
    }

    public static void writeString(String filePath, String content) throws Exception {
        FileUtil.writeString(filePath, content, false);
    }

    public static void writeString(String filePath, String content, boolean append) throws Exception {
        String dirPath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        if (content.endsWith("\n")) {
            bw.write(content);
        } else {
            bw.write(content + "\n");
        }
        bw.close();
    }

    public static <T> void writeList(String filePath, Collection<T> objs) throws Exception {
        FileUtil.writeList(filePath, objs, null, false);
    }

    public static <T> void writeList(String filePath, Collection<T> objs, boolean append) throws Exception {
        FileUtil.writeList(filePath, objs, null, append);
    }

    public static synchronized <T> void writeListSyn(String filePath, List<T> objs) throws Exception {
        FileUtil.writeList(filePath, objs, null, false);
    }

    public static <T> void writeList(String filePath, Collection<T> ts, Converter<T, String> lw, boolean append) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        StringBuilder contents = new StringBuilder();
        int count = 0;
        for (T t : ts) {
            contents.append((Object)(lw != null ? lw.transform(t) : t));
            contents.append("\n");
            if (++count < 1000) continue;
            bw.write(contents.toString());
            count = 0;
            contents = new StringBuilder();
        }
        if (contents.capacity() > 0) {
            bw.write(contents.toString());
        }
        bw.close();
    }

    public static <T> void writeVector(String filePath, List<T> objs) throws Exception {
        FileUtil.writeVector(filePath, objs, null, false);
    }

    public static <T> void writeVector(String filePath, List<T> ts, Converter<T, String> wh, boolean append) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), "UTF-8"));
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (T t : ts) {
            sb.append(wh.transform(t));
            if (++i >= ts.size()) continue;
            sb.append(", ");
        }
        bw.write(sb.toString() + "\n");
        bw.close();
    }

    public static String readAsString(String filePath, String ... keywords) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        block0: while ((line = br.readLine()) != null) {
            if (keywords != null && keywords.length > 0) {
                for (String keyword : keywords) {
                    if (!line.contains(keyword)) continue;
                    sb.append(line + "\r\n");
                    continue block0;
                }
                continue;
            }
            sb.append(line + "\r\n");
        }
        br.close();
        return sb.toString();
    }

    public static String readAsString(String filePath, int ... lines) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        int count = 0;
        int num = 0;
        while ((line = br.readLine()) != null) {
            if (++count == lines[num]) {
                ++num;
                sb.append(line + "\r\n");
            }
            if (num < lines.length) continue;
        }
        br.close();
        return sb.toString();
    }

    public static String readAsString(String path) throws Exception {
        if (path.startsWith("http://") || path.contains("www.")) {
            return URLReader.read(path);
        }
        return FileUtil.readAsString(path, new String[0]);
    }

    public static List<String> readAsList(String filePath) throws Exception {
        return FileUtil.readAsList(filePath, null);
    }

    public static <T> List<T> readAsList(String filePath, Converter<String, T> rh) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        ArrayList<String> contents = new ArrayList<String>();
        String t = null;
        String line = null;
        while ((line = br.readLine()) != null) {
            t = rh == null ? line : rh.transform(line);
            if (t == null) continue;
            contents.add(t);
        }
        br.close();
        return contents;
    }

    public static Set<String> readAsSet(String filePath) throws Exception {
        return FileUtil.readAsSet(filePath, null);
    }

    public static <T> Set<T> readAsSet(String filePath, Converter<String, T> rh) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashSet<String> contents = new HashSet<String>();
        String line = null;
        String t = null;
        while ((line = br.readLine()) != null) {
            t = rh == null ? line : rh.transform(line);
            if (t == null) continue;
            contents.add(t);
        }
        br.close();
        return contents;
    }

    public static Map<String, String> readAsMap(String filePath) throws Exception {
        return FileUtil.readAsMap(filePath, ",");
    }

    public static Map<String, String> readAsMap(String filePath, String seperator) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<String, String> contents = new HashMap<String, String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] data = line.split(seperator);
            if (data.length <= 1) continue;
            contents.put(data[0], data[1]);
        }
        br.close();
        return contents;
    }

    public static <T, E> Map<T, E> readAsMap(String filePath, Converter<String, Object[]> rh) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<Object, Object> contents = new HashMap<Object, Object>();
        String line = null;
        while ((line = br.readLine()) != null) {
            Object[] obs = rh.transform(line);
            contents.put(obs[0], obs[1]);
        }
        br.close();
        return contents;
    }

    public static Map<String, Double> readAsIDMap(String filePath) throws Exception {
        return FileUtil.readAsIDMap(filePath, ",");
    }

    public static Map<String, Double> readAsIDMap(String filePath, String sep) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        HashMap<String, Double> contents = new HashMap<String, Double>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] data = line.split(sep);
            if (data.length <= 1) continue;
            contents.put(data[0], new Double(data[1]));
        }
        br.close();
        return contents;
    }

    public static void serialize(Object obj, String filePath) throws Exception {
        FileOutputStream fos = new FileOutputStream(filePath);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        fos.close();
    }

    public static Object deserialize(String filePath) throws Exception {
        FileInputStream fis = new FileInputStream(filePath);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object obj = ois.readObject();
        ois.close();
        fis.close();
        return obj;
    }

    public static void renameFiles(String dirPath, String regex, String replacement) throws Exception {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            throw new Exception(dirPath + " is not a directory");
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                FileUtil.renameFile(file, regex, replacement);
            }
        }
    }

    public static void renameFile(File file, String regex, String replacement) {
        String filename = file.getName();
        filename = filename.replaceAll(regex, replacement);
        String path = FileUtil.makeDirPath(file.getPath());
        file.renameTo(new File(path + filename));
    }

    public static void copyFile(String source, String target) throws Exception {
        FileUtil.copyFile(new File(source), new File(target));
    }

    public static void copyFile(File source, File target) throws Exception {
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target);
        FileChannel inChannel = fis.getChannel();
        FileChannel outChannel = fos.getChannel();
        int maxCount = 67076096;
        long size = inChannel.size();
        for (long position = 0L; position < size; position += inChannel.transferTo(position, maxCount, outChannel)) {
        }
        inChannel.close();
        outChannel.close();
        fis.close();
        fos.close();
    }

    public static void deleteFile(String source) throws Exception {
        new File(source).delete();
    }

    public static void deleteDirectory(String dirPath) throws Exception {
        FileUtil.deleteDirectory(new File(dirPath));
    }

    public static void deleteDirectory(File dir) throws Exception {
        FileUtil.cleanDirectory(dir);
        dir.delete();
    }

    public static void cleanDirectory(String dirPath) throws Exception {
        FileUtil.cleanDirectory(new File(dirPath));
    }

    public static void cleanDirectory(File dir) throws Exception {
        File[] fs;
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new Exception("The path '" + dir.getPath() + "' is not a directory. ");
        }
        for (File f : fs = dir.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteDirectory(f.getPath());
                continue;
            }
            f.delete();
        }
    }

    public static void moveFile(String source, String target) throws Exception {
        FileUtil.copyFile(source, target);
        FileUtil.deleteFile(source);
    }

    public static void moveDirectory(String sourceDir, String targetDir) throws Exception {
        FileUtil.copyDirectory(sourceDir, targetDir);
        FileUtil.deleteDirectory(sourceDir);
    }

    public static void copyDirectory(String sourceDir, String targetDir) throws Exception {
        File sDir = new File(sourceDir);
        File tDir = new File(targetDir);
        if (sDir.isDirectory()) {
            File[] files;
            if (!tDir.exists()) {
                tDir.mkdirs();
            }
            for (File f : files = sDir.listFiles()) {
                if (f.isDirectory()) {
                    FileUtil.copyDirectory(f.getPath(), tDir + Systems.FILE_SEPARATOR + f.getName() + Systems.FILE_SEPARATOR);
                    continue;
                }
                FileUtil.copyFile(f, new File(tDir.getPath() + Systems.FILE_SEPARATOR + f.getName()));
            }
        }
    }

    public static void empty(String filePath) throws Exception {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
    }

    public static boolean exist(String filePath) {
        return new File(filePath).exists();
    }

    public static File[] listFiles(String dirPath) {
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            return dir.listFiles();
        }
        return new File[]{dir};
    }

    public static void zipFolder(String dirPath, String filePath) throws Exception {
        File outFile = new File(filePath);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        byte[] buffer = new byte[1024];
        CRC32 crc = new CRC32();
        for (File file : FileUtil.listFiles(dirPath)) {
            int bytesRead;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            crc.reset();
            while ((bytesRead = bis.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
            }
            bis.close();
            bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(file.getName());
            entry.setMethod(0);
            entry.setCompressedSize(file.length());
            entry.setSize(file.length());
            entry.setCrc(crc.getValue());
            zos.putNextEntry(entry);
            while ((bytesRead = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            bis.close();
        }
        zos.close();
        LOG.debug("A zip-file is created to: " + outFile.getPath());
    }

    public static interface Converter<K, T> {
        public T transform(K var1) throws Exception;
    }

    public static interface MapWriter<K, V> {
        public String processEntry(K var1, V var2);
    }
}

