/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.librec.math.algorithm.Randoms;
import net.librec.recommender.item.KeyValue;

public class Lists {
    public static int initSize(int capacity) {
        return (int)Math.ceil((double)capacity / 0.7);
    }

    public static <E> int initSize(Collection<E> collection) {
        return Lists.initSize(collection.size());
    }

    public static void shaffle(int[] data) {
        int N = data.length;
        if (N <= 1) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            int j = Randoms.uniform(i, N);
            int swap = data[i];
            data[i] = data[j];
            data[j] = swap;
        }
    }

    public static void shaffle(double[] data) {
        int N = data.length;
        if (N <= 1) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            int j = Randoms.uniform(i, N);
            double swap = data[i];
            data[i] = data[j];
            data[j] = swap;
        }
    }

    public static <T> void shaffle(List<T> data) {
        int N = data.size();
        if (N <= 1) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            int j = Randoms.uniform(i, N);
            T swap = data.get(i);
            data.set(i, data.get(j));
            data.set(j, swap);
        }
    }

    public static <T> List<T> subset(List<T> data, int n) {
        ArrayList<T> ts = new ArrayList<T>();
        for (int i = 0; i < data.size(); ++i) {
            ts.add(data.get(i));
            if (ts.size() >= n) break;
        }
        return ts;
    }

    public static <T> List<T> intersect(List<T> list1, List<T> list2) {
        ArrayList<T> ts = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            ts.add(t);
        }
        return ts;
    }

    public static <T> int overlapSize(List<T> list1, List<T> list2) {
        int res = 0;
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            ++res;
        }
        return res;
    }

    public static <T> List<T> except(List<T> list1, List<T> list2) {
        ArrayList<T> ts = new ArrayList<T>();
        for (T t : list1) {
            if (list2.contains(t)) continue;
            ts.add(t);
        }
        return ts;
    }

    public static <T> int exceptSize(List<T> list1, List<T> list2) {
        int res = 0;
        for (T t : list1) {
            if (list2.contains(t)) continue;
            ++res;
        }
        return res;
    }

    public static <T> boolean isEmpty(List<T> ts) {
        return ts == null || ts.size() < 1;
    }

    public static double[] toArray(Collection<? extends Number> data) {
        if (data == null || data.size() < 1) {
            return null;
        }
        double[] da = new double[data.size()];
        int i = 0;
        for (Number number : data) {
            da[i++] = number.doubleValue();
        }
        return da;
    }

    public static List<Double> toList(double[] data) {
        if (data == null || data.length < 1) {
            return null;
        }
        ArrayList<Double> da = new ArrayList<Double>();
        for (double d : data) {
            da.add(d);
        }
        return da;
    }

    public static List<Integer> toList(int[] data) {
        ArrayList<Integer> da = new ArrayList<Integer>();
        int[] nArray = data;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer d = nArray[i];
            da.add(d);
        }
        return da;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortMap(Map<K, V> data, boolean inverse) {
        ArrayList<Map.Entry<K, V>> pairs = new ArrayList<Map.Entry<K, V>>(data.entrySet());
        Lists.sortList(pairs, inverse);
        return pairs;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortMap(Map<K, V> data) {
        return Lists.sortMap(data, false);
    }

    public static <K, V extends Comparable<? super V>> void sortList(List<Map.Entry<K, V>> data, final boolean inverse) {
        Collections.sort(data, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                int res = ((Comparable)a.getValue()).compareTo(b.getValue());
                return inverse ? -res : res;
            }
        });
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> void sortListByKey(List<Map.Entry<K, V>> data, final boolean inverse) {
        data.sort(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                int res = ((Comparable)a.getKey()).compareTo(b.getKey());
                return inverse ? -res : res;
            }
        });
    }

    public static <K, V extends Comparable<? super V>> void sortList(List<Map.Entry<K, V>> data) {
        Lists.sortList(data, false);
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortListTopK(List<Map.Entry<K, V>> data, final boolean inverse, int k) {
        int n = k = data.size() > k ? k : data.size();
        if (k == 0) {
            return new ArrayList<Map.Entry<K, V>>();
        }
        PriorityQueue<Map.Entry<K, V>> topKDataQueue = new PriorityQueue<Map.Entry<K, V>>(k, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                int res = ((Comparable)a.getValue()).compareTo(b.getValue());
                return inverse ? res : -res;
            }
        });
        Iterator<Map.Entry<K, V>> iterator = data.iterator();
        for (int i = 0; i < k; ++i) {
            topKDataQueue.add(iterator.next());
        }
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            int res = ((Comparable)entry.getValue()).compareTo(((Map.Entry)topKDataQueue.peek()).getValue());
            if ((inverse ? -res : res) >= 0) continue;
            topKDataQueue.poll();
            topKDataQueue.add(entry);
        }
        ArrayList<Map.Entry<K, V>> topKDataList = new ArrayList<Map.Entry<K, V>>(topKDataQueue);
        Lists.sortList(topKDataList, inverse);
        return topKDataList;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortList(List<Map.Entry<K, V>> data, int k) {
        return Lists.sortListTopK(data, false, k);
    }

    public static <K, V extends Comparable<? super V>> List<KeyValue<K, V>> sortKeyValueListTopK(List<KeyValue<K, V>> data, final boolean inverse, int k) {
        int n = k = data.size() > k ? k : data.size();
        if (k == 0) {
            return new ArrayList<KeyValue<K, V>>();
        }
        PriorityQueue<KeyValue<K, V>> topKDataQueue = new PriorityQueue<KeyValue<K, V>>(k, new Comparator<KeyValue<K, V>>(){

            @Override
            public int compare(KeyValue<K, V> a, KeyValue<K, V> b) {
                int res = ((Comparable)a.getValue()).compareTo(b.getValue());
                return inverse ? res : -res;
            }
        });
        Iterator<KeyValue<K, V>> iterator = data.iterator();
        for (int i = 0; i < k; ++i) {
            topKDataQueue.add(iterator.next());
        }
        while (iterator.hasNext()) {
            KeyValue<K, V> entry = iterator.next();
            int res = ((Comparable)entry.getValue()).compareTo(((KeyValue)topKDataQueue.peek()).getValue());
            if ((inverse ? -res : res) >= 0) continue;
            topKDataQueue.poll();
            topKDataQueue.add(entry);
        }
        ArrayList<KeyValue<K, V>> topKDataList = new ArrayList<KeyValue<K, V>>(topKDataQueue);
        Lists.sortKeyValueList(topKDataList, inverse);
        return topKDataList;
    }

    public static <K, V extends Comparable<? super V>> void sortKeyValueList(List<KeyValue<K, V>> data, final boolean inverse) {
        Collections.sort(data, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                int res = ((Comparable)a.getValue()).compareTo(b.getValue());
                return inverse ? -res : res;
            }
        });
    }

    public static <K, V extends Comparable<? super V>> void sortKeyValueList(List<KeyValue<K, V>> data) {
        Lists.sortKeyValueList(data, false);
    }

    public static <K, V extends Comparable<? super V>> List<KeyValue<K, V>> sortKeyValueListTopK(List<KeyValue<K, V>> data, int k) {
        return Lists.sortKeyValueListTopK(data, false, k);
    }
}

