/*
 * Decompiled with CFR 0.152.
 */
package net.librec.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class URLReader {
    public static String read(String url) throws Exception {
        URL link = new URL(url);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(link.openStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        br.close();
        return sb.toString();
    }

    public static String read(String url, String proxyHost, int proxyPort) throws Exception {
        InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
        URL link = new URL(url);
        URLConnection conn = link.openConnection(proxy);
        conn.setConnectTimeout(10000);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        br.close();
        return sb.toString();
    }

    public static String read(String url, Proxy proxy) throws Exception {
        URL link = new URL(url);
        URLConnection conn = link.openConnection(proxy);
        conn.setConnectTimeout(10000);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        br.close();
        return sb.toString();
    }
}

