/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import com.google.common.collect.BiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.math.structure.DataFrame;
import net.librec.util.StringUtil;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDataAppender
extends TextDataConvertor {
    private static final Log LOG = LogFactory.getLog(TextDataConvertor.class);
    private static final int BSIZE = 0x100000;
    private static final String DATA_COLUMN_DEFAULT_FORMAT = "UIR";
    private String dataColumnFormat;
    private String inputDataPath;
    private double binThold = -1.0;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private float loadFilePathRate;
    private float loadDataFileRate;
    private float loadAllFileRate;
    private String[] m_header;
    private String[] m_attr;
    private String m_sep;
    private float m_fileRate;

    public AutoDataAppender(String path) {
        super(path);
        this.inputDataPath = path;
        this.m_sep = "[ \\t,]+";
    }

    @Override
    public void processData() throws IOException {
        this.readDataAuto(this.inputDataPath);
    }

    private void readDataAuto(String ... inputDataPath) throws IOException {
        LOG.info(String.format("Dataset: %s", Arrays.toString(inputDataPath)));
        this.matrix = new DataFrame();
        if (Objects.isNull(this.m_header)) {
            if (DATA_COLUMN_DEFAULT_FORMAT.toLowerCase().equals("uirt")) {
                this.m_header = new String[]{"user", "item", "rating", "datetime"};
                this.m_attr = new String[]{"STRING", "STRING", "NUMERIC", "DATE"};
            } else {
                this.m_header = new String[]{"user", "item", "rating"};
                this.m_attr = new String[]{"STRING", "STRING", "NUMERIC"};
            }
        }
        this.matrix.setAttrType(this.m_attr);
        this.matrix.setHeader(this.m_header);
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        for (String path : inputDataPath) {
            Files.walkFileTree(Paths.get(path.trim(), new String[0]), (FileVisitor<? super Path>)finder);
        }
        int numFiles = files.size();
        int cur = 0;
        Pattern pattern = Pattern.compile(this.m_sep);
        for (File file : files) {
            try {
                Source fileSource = Okio.source(file);
                Throwable throwable = null;
                try {
                    BufferedSource bufferedSource = Okio.buffer(fileSource);
                    Throwable throwable2 = null;
                    try {
                        String temp;
                        while ((temp = bufferedSource.readUtf8Line()) != null && !"".equals(temp.trim())) {
                            String[] eachRow = pattern.split(temp);
                            for (int i = 0; i < this.m_header.length; ++i) {
                                if (!Objects.equals(this.m_attr[i], "STRING")) continue;
                                DataFrame.setId(eachRow[i], this.matrix.getHeader(i));
                            }
                            this.matrix.add(eachRow);
                        }
                        LOG.info(String.format("DataSet: %s is finished", StringUtil.last(file.toString(), 38)));
                        this.m_fileRate = ++cur / numFiles;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedSource == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedSource.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedSource.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fileSource == null) continue;
                    if (throwable != null) {
                        try {
                            fileSource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fileSource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOG.info(String.format("user number: %d,\t item number is: %d", this.matrix.numUsers(), this.matrix.numItems()));
    }

    public int numUsers() {
        return this.userIds.size();
    }

    public int numItems() {
        return this.itemIds.size();
    }

    public int getUserId(String rawId) {
        return (Integer)this.userIds.get(rawId);
    }

    public int getItemId(String rawId) {
        return (Integer)this.itemIds.get(rawId);
    }

    public BiMap<String, Integer> getUserIds() {
        return this.userIds;
    }

    public BiMap<String, Integer> getItemIds() {
        return this.itemIds;
    }
}

