/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.data.splitter.LOOCVDataSplitter;
import net.librec.eval.EvalContext;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.filter.RecommendedFilter;
import net.librec.job.RecommenderJob;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.similarity.RecommenderSimilarity;
import net.librec.util.ReflectionUtil;
import net.that_recsys_lab.auto.IJobCmd;
import net.that_recsys_lab.auto.cmd.CheckCmd;
import net.that_recsys_lab.auto.cmd.EvalCmd;
import net.that_recsys_lab.auto.cmd.ExpCmd;
import net.that_recsys_lab.auto.cmd.ReRunEvalCmd;
import net.that_recsys_lab.auto.cmd.SeqCmd;
import net.that_recsys_lab.auto.cmd.SplitCmd;
import org.apache.commons.logging.Log;

public class AutoRecommenderJob
extends RecommenderJob {
    private List<IJobCmd> m_commands;
    protected Configuration m_conf;
    public DataModel m_data;
    protected String m_modelSplit;
    protected int m_cvCount;
    protected boolean m_kcvReload;
    public Map<String, List<Double>> m_cvEvalResults;
    public List<Recommender> m_recommenders;
    private Map<Measure.MeasureValue, Double> m_evaluatedMap;

    public AutoRecommenderJob(Configuration conf) {
        super(conf);
        this.m_conf = conf;
        this.m_modelSplit = conf.get("data.model.splitter");
        this.m_cvCount = 1;
        this.m_cvEvalResults = new HashMap<String, List<Double>>();
        if (this.m_modelSplit.equals("kcv")) {
            this.m_cvCount = this.m_conf.getInt("data.splitter.cv.number", 1);
            this.m_kcvReload = this.m_conf.getBoolean("data.splitter.cv.reload", false);
            if (this.m_kcvReload) {
                this.m_conf.set("data.model.splitter", "testset");
                this.m_conf.set("data.input.path", "split/cv_1/train.txt");
                this.m_conf.set("data.testset.path", "split/cv_1/test.txt");
            }
        }
        this.m_recommenders = new ArrayList<Recommender>(this.m_cvCount);
        try {
            this.setData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Configuration getConf() {
        return this.m_conf;
    }

    public Log getLOG() {
        return this.LOG;
    }

    public int getCVCount() {
        return this.m_cvCount;
    }

    public DataModel getData() {
        return this.m_data;
    }

    public void setData() throws ClassNotFoundException, IOException, LibrecException {
        this.m_data = ReflectionUtil.newInstance(this.getDataModelClass(), this.m_conf);
        this.m_conf.set("data.splitter.cv.index", "1");
        this.m_conf.setBoolean("feature.appender.read.ready", false);
        this.m_data.buildDataModel();
    }

    public void setCommands(String arg) {
        this.m_commands = new ArrayList<IJobCmd>(5);
        switch (arg) {
            case "check": {
                this.m_commands.add(new CheckCmd(this));
                break;
            }
            case "split": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>();
                    subcmds.add(new SplitCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            case "reRunEval": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>();
                    subcmds.add(new SplitCmd(this, i, false, true));
                    subcmds.add(new ReRunEvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            case "exp-eval": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>();
                    subcmds.add(new SplitCmd(this, i, false, true));
                    subcmds.add(new ExpCmd(this, i));
                    subcmds.add(new EvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            case "full": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>();
                    subcmds.add(new SplitCmd(this, i, true, false));
                    subcmds.add(new SplitCmd(this, i, false, true));
                    subcmds.add(new ExpCmd(this, i));
                    subcmds.add(new EvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            case "run": {
                ArrayList<IJobCmd> cmds = new ArrayList<IJobCmd>(this.m_cvCount);
                for (int i = 1; i <= this.m_cvCount; ++i) {
                    ArrayList<IJobCmd> subcmds = new ArrayList<IJobCmd>();
                    subcmds.add(new SplitCmd(this, i, false, true));
                    subcmds.add(new ExpCmd(this, i));
                    subcmds.add(new EvalCmd(this, i));
                    cmds.add(new SeqCmd(this, subcmds));
                }
                this.m_commands.add(new SeqCmd(this, cmds));
                break;
            }
            default: {
                System.out.println("You've failed to enter a proper command.  LibRecAuto Terminating.");
                return;
            }
        }
    }

    @Override
    public void runJob() throws LibrecException, IOException, ClassNotFoundException {
        for (IJobCmd cmd : this.m_commands) {
            cmd.execute();
        }
        if (this.m_cvCount > 1) {
            this.printCVAverageResult();
        }
    }

    public void generateSimilarityAutoOverload(RecommenderContext context) {
        String[] similarityKeys = this.m_conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            for (int i = 0; i < similarityKeys.length; ++i) {
                if (this.getSimilarityClass(i) == null) continue;
                RecommenderSimilarity similarity = ReflectionUtil.newInstance(this.getSimilarityClass(i), this.m_conf);
                this.m_conf.set("rec.recommender.similarity.key", similarityKeys[i]);
                similarity.buildSimilarityMatrix(this.m_data);
                if (similarityKeys[i].equals("item") || similarityKeys[i].equals("user")) {
                    context.setSimilarity(similarity);
                }
                context.addSimilarities(similarityKeys[i], similarity);
            }
        }
    }

    public void executeEvaluatorAutoOverload(Recommender recommender, RecommenderContext context) throws ClassNotFoundException, IOException, LibrecException {
        block11: {
            EvalContext evalContext;
            block12: {
                if (!this.m_conf.getBoolean("rec.eval.enable")) break block11;
                DataSet dataSet = this.m_data.getTestDataSet();
                String[] similarityKeys = this.m_conf.getStrings("rec.recommender.similarities");
                evalContext = null;
                if (similarityKeys != null && similarityKeys.length > 0) {
                    if (context.getSimilarity() == null) {
                        this.generateSimilarityAutoOverload(context);
                    }
                    SymmMatrix similarityMatrix = context.getSimilarity().getSimilarityMatrix();
                    Map<String, RecommenderSimilarity> similarities = context.getSimilarities();
                    evalContext = new EvalContext(this.m_conf, recommender, dataSet, similarityMatrix, similarities);
                } else {
                    evalContext = new EvalContext(this.m_conf, recommender, dataSet);
                }
                String[] evalClassKeys = this.m_conf.getStrings("rec.eval.classes");
                if (evalClassKeys == null || evalClassKeys.length <= 0) break block12;
                for (int classIdx = 0; classIdx < evalClassKeys.length; ++classIdx) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(this.getEvaluatorClass(evalClassKeys[classIdx]), null);
                    evaluator.setTopN(this.m_conf.getInt("rec.recommender.ranking.topn", 10));
                    evaluator.setDataModel(this.m_data);
                    double evalValue = evaluator.evaluate(evalContext);
                    this.LOG.info("Evaluator info:" + evaluator.getClass().getSimpleName() + " is " + evalValue);
                    this.collectCVResults(evaluator.getClass().getSimpleName(), evalValue);
                }
                break block11;
            }
            this.m_evaluatedMap = new HashMap<Measure.MeasureValue, Double>();
            boolean isRanking = this.m_conf.getBoolean("rec.recommender.isranking");
            int topN = 10;
            if (isRanking && (topN = this.m_conf.getInt("rec.recommender.ranking.topn", 10).intValue()) <= 0) {
                throw new IndexOutOfBoundsException("rec.recommender.ranking.topn should be more than 0!");
            }
            List<Measure.MeasureValue> measureValueList = Measure.getMeasureEnumList(isRanking, topN);
            if (measureValueList != null) {
                for (Measure.MeasureValue measureValue : measureValueList) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(measureValue.getMeasure().getEvaluatorClass());
                    if (isRanking && measureValue.getTopN() != null && measureValue.getTopN() > 0) {
                        evaluator.setTopN(measureValue.getTopN());
                    }
                    double evaluatedValue = evaluator.evaluate(evalContext);
                    this.m_evaluatedMap.put(measureValue, evaluatedValue);
                }
            }
            if (this.m_evaluatedMap.size() <= 0) break block11;
            for (Map.Entry entry : this.m_evaluatedMap.entrySet()) {
                String evalName = null;
                if (entry == null || entry.getKey() == null) continue;
                if (((Measure.MeasureValue)entry.getKey()).getTopN() != null && ((Measure.MeasureValue)entry.getKey()).getTopN() > 0) {
                    this.LOG.info("Evaluator value:" + (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " top " + ((Measure.MeasureValue)entry.getKey()).getTopN() + " is " + entry.getValue());
                    evalName = (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " top " + ((Measure.MeasureValue)entry.getKey()).getTopN();
                } else {
                    this.LOG.info("Evaluator value:" + (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + " is " + entry.getValue());
                    evalName = (Object)((Object)((Measure.MeasureValue)entry.getKey()).getMeasure()) + "";
                }
                if (null == this.m_cvEvalResults) continue;
                this.collectCVResults(evalName, (Double)entry.getValue());
            }
        }
    }

    private void collectCVResults(String evalName, Double evalValue) {
        DataSplitter splitter = this.m_data.getDataSplitter();
        if (splitter != null) {
            if (this.m_cvEvalResults.containsKey(evalName)) {
                this.m_cvEvalResults.get(evalName).add(evalValue);
            } else {
                ArrayList<Double> newList = new ArrayList<Double>();
                newList.add(evalValue);
                this.m_cvEvalResults.put(evalName, newList);
            }
        }
    }

    private List<RecommendedItem> filterResult(List<RecommendedItem> recommendedList) throws ClassNotFoundException, IOException {
        if (this.getFilterClass() != null) {
            RecommendedFilter filter = ReflectionUtil.newInstance(this.getFilterClass(), null);
            recommendedList = filter.filter(recommendedList);
        }
        return recommendedList;
    }

    private void printCVAverageResult() {
        DataSplitter splitter = this.m_data.getDataSplitter();
        if (splitter != null && (splitter instanceof KCVDataSplitter || splitter instanceof LOOCVDataSplitter)) {
            this.LOG.info("Average Evaluation Result of Cross Validation:");
            for (Map.Entry<String, List<Double>> entry : this.m_cvEvalResults.entrySet()) {
                String evalName = entry.getKey();
                List<Double> evalList = entry.getValue();
                double sum2 = 0.0;
                for (double value : evalList) {
                    sum2 += value;
                }
                double avgEvalResult = sum2 / (double)evalList.size();
                this.LOG.info("Evaluator value:" + evalName + " is " + avgEvalResult);
            }
        }
    }
}

