/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto;

import com.google.common.collect.BiMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.MatrixRecommender;
import net.that_recsys_lab.auto.AutoDataAppender;

public class OracleAlgo
extends MatrixRecommender {
    private SequentialAccessSparseMatrix resultsMatrix;
    private TextDataConvertor resultsModel;
    private BiMap<Integer, String> userMappingInverse;
    private BiMap<Integer, String> itemMappingInverse;
    private BiMap<String, Integer> result_userMapping;
    private BiMap<String, Integer> result_itemMapping;

    @Override
    protected void trainModel() throws LibrecException {
        System.out.println("** Training model in OracleAlgo **");
        try {
            this.LoadResults();
            this.userMappingInverse = this.userMappingData.inverse();
            this.itemMappingInverse = this.itemMappingData.inverse();
            this.resultsModel.getMatrix();
            this.result_userMapping = DataFrame.getUserIds();
            this.resultsModel.getMatrix();
            this.result_itemMapping = DataFrame.getItemIds();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        String user_raw = (String)this.userMappingInverse.get(userIdx);
        String item_raw = (String)this.itemMappingInverse.get(itemIdx);
        double predictedRating = Double.NaN;
        try {
            int user_inner = (Integer)this.result_userMapping.get(user_raw);
            int item_inner = (Integer)this.result_itemMapping.get(item_raw);
            predictedRating = this.resultsMatrix.get(user_inner, item_inner);
            if (predictedRating == -2.0) {
                predictedRating = 0.0;
            }
        }
        catch (NullPointerException user_inner) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return predictedRating;
    }

    private void LoadResults() throws FileNotFoundException {
        Integer cvSplit = Integer.parseInt(this.conf.get("data.splitter.cv.index", "1"));
        String path = this.conf.get("dfs.result.dir") + "/out-" + cvSplit + ".txt";
        AutoDataAppender tempResultModel = new AutoDataAppender(path);
        try {
            tempResultModel.processData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SequentialAccessSparseMatrix temp = tempResultModel.getPreferenceMatrix();
        this.resultsMatrix = temp.clone();
        this.resultsModel = tempResultModel;
    }
}

