/*
 * Decompiled with CFR 0.152.
 */
package net.that_recsys_lab.auto.cmd;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.util.ReflectionUtil;
import net.that_recsys_lab.auto.AutoRecommenderJob;
import net.that_recsys_lab.auto.IJobCmd;

public class ReRunEvalCmd
implements IJobCmd {
    private AutoRecommenderJob job;
    private int m_splitId;
    private String ORACLE_ALGO_CLASSNAME = "net.that_recsys_lab.auto.OracleAlgo";

    public ReRunEvalCmd(AutoRecommenderJob job) {
        this.job = job;
        this.m_splitId = 1;
    }

    public ReRunEvalCmd(AutoRecommenderJob job, int splitId) {
        this.job = job;
        this.m_splitId = splitId;
    }

    @Override
    public void execute() throws LibrecException, IOException, ClassNotFoundException {
        this.executeEval();
    }

    public void executeEval() throws LibrecException, IOException, ClassNotFoundException {
        this.getConf().set("rec.recommender.class", this.ORACLE_ALGO_CLASSNAME);
        Integer dataDir = this.getConf().get("dfs.data.dir").length() + 1;
        int endingIndex = this.trainFileNameGen().length() - 10;
        this.getConf().set("data.splitter.cv.index", String.valueOf(this.m_splitId));
        this.getConf().set("data.input.path", this.trainFileNameGen().substring(dataDir, endingIndex));
        this.getConf().set("data.testset.path", this.testFileNameGen().substring(dataDir));
        this.recalculateMetrics();
    }

    private void recalculateMetrics() throws LibrecException, IOException, ClassNotFoundException {
        RecommenderContext context = new RecommenderContext(this.getConf(), this.job.getData());
        this.job.generateSimilarityAutoOverload(context);
        Recommender recommender = ReflectionUtil.newInstance(this.job.getRecommenderClass(), this.getConf());
        recommender.train(context);
        this.job.executeEvaluatorAutoOverload(recommender, context);
    }

    private Configuration getConf() {
        return this.job.getConf();
    }

    private String trainFileNameGen() throws IOException, ClassNotFoundException {
        return this.fileNameGenAux(true);
    }

    private String testFileNameGen() throws IOException, ClassNotFoundException {
        return this.fileNameGenAux(false);
    }

    private String fileNameGenAux(Boolean flag) throws IOException, ClassNotFoundException {
        String outputPath = this.getConf().get("dfs.data.dir") + '/' + this.getConf().get("dfs.split.dir");
        outputPath = flag != false ? outputPath + "/cv_" + String.valueOf(this.m_splitId) + "/train.txt" : outputPath + "/cv_" + String.valueOf(this.m_splitId) + "/test.txt";
        return outputPath;
    }
}

