# AIPOSE

<div align="center">

[![Downloads](https://static.pepy.tech/personalized-badge/aipose?period=month&units=international_system&left_color=grey&right_color=blue&left_text=PyPi%20Downloads)](https://pepy.tech/project/aipose)
[![Stars](https://img.shields.io/github/stars/Tlaloc-Es/aipose?color=yellow&style=flat)](https://github.com/Tlaloc-Es/aipose/stargazers)

</div>


<p align="center">
        <img src="./logo.png" width="200" height="240"/>
    </p>

Library to use pose estimation in your projects easily.
## Instalation [![PyPI](https://img.shields.io/pypi/v/aipose.svg)](https://pypi.org/project/aipose/)

You can install `aipose` from [Pypi](https://pypi.org/project/aipose/). It's going to install the library itself and its prerequisites as well.

```bash
pip install aipose
```

You can install `aipose` from its source code.

```bash
git clone https://github.com/Tlaloc-Es/aipose.git
cd aipose
pip install -e .
```

## Run demo

Use the following command to run a demo with your cam and YOLOv7 pose estimator,

```bash
posewebcam
```

## How to use

You can check the section notebooks in the repository to check the usage of the library or you can ask in the [Issues section](https://github.com/Tlaloc-Es/aipose/issues).

The examples are:

* [How to draw key points in a video](https://github.com/Tlaloc-Es/aipose/blob/master/notebooks/video.ipynb)
* [How to draw key points in a webcam](https://github.com/Tlaloc-Es/aipose/blob/master/notebooks/webcam.ipynb)
* [How to draw key points in a picture](https://github.com/Tlaloc-Es/aipose/blob/master/notebooks/plot_keypoints.ipynb)
* [How to capture a frame to apply your business logic](https://github.com/Tlaloc-Es/aipose/blob/master/notebooks/custom%20manager.ipynb)
* [How to stop the video stream when anybody raises hands with YOLOv7](https://github.com/Tlaloc-Es/aipose/blob/master/notebooks/process_keypoints.ipynb)

## References

* https://github.com/RizwanMunawar/yolov7-pose-estimation

## Support

You can do a donation with the following link.

<a href="https://www.buymeacoffee.com/tlaloc" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-orange.png" alt="Buy Me A Coffee" height="41" width="174"></a>

Or you can try to make a pull request with your improvements to the repo.

## Source of videos and images

* Video by Mikhail Nilov: https://www.pexels.com/video/a-woman-exercising-using-an-exercise-ball-6739975/