import numpy as np
from numpy.testing import assert_almost_equal

from wildboar.datasets import load_two_lead_ecg
from wildboar.distance import matrix_profile


def test_matrix_profile_self_join_performance(benchmark):
    X, y = load_two_lead_ecg()
    benchmark(matrix_profile, x=X[:10].reshape(-1))


def test_matrix_profile_ab_join_performance(benchmark):
    X, y = load_two_lead_ecg()
    benchmark(matrix_profile, x=X[:10].reshape(-1), y=X[10:20].reshape(-1))


def test_matrix_profile_self_join():
    X, y = load_two_lead_ecg()
    mp = matrix_profile(X[:10].reshape(-1))

    desired = np.array(
        [
            0.27618657260892654,
            1.0554301512432789,
            0.7588059280273162,
            0.1488230782667199,
            0.25595531149532785,
            0.3644992342498726,
            0.5234736999834144,
            0.363698476907543,
            0.5481421265897276,
            0.35416174646569426,
        ]
    )
    assert_almost_equal(mp[:10], desired)


def test_matrix_profile_self_join_n_samples():
    X, y = load_two_lead_ecg()
    mp = matrix_profile(X[:10])
    desired = np.array(
        [
            [
                1.4586498076854104,
                1.4467365490083097,
                0.7588059280270435,
                0.3904680291557426,
                0.9467496074353395,
                0.6593719617427912,
                0.5234736999834144,
                0.363698476907438,
                0.6189181204449019,
                0.8645612988017564,
            ],
            [
                1.0525399927074106,
                0.8259428007698474,
                0.342713453444541,
                0.14853487803760085,
                0.3853146156573823,
                0.29721944221565544,
                1.1740019465570506,
                0.8195859280763638,
                0.8670526810940837,
                0.7530679516192695,
            ],
            [
                0.28496746648951543,
                0.20294506413256136,
                0.2435110409046112,
                0.15393733370740934,
                0.18992276854684462,
                0.0800730564260178,
                0.8960533034190347,
                1.1279808210574787,
                0.7770430355523702,
                0.6309354483384741,
            ],
            [
                0.6062620161003718,
                0.5587718035490568,
                0.1959149587529992,
                0.20254407552633083,
                0.13807556733641763,
                0.3874161691594712,
                1.064269376118339,
                0.17772460508391602,
                0.25448963890557463,
                0.16355254941586592,
            ],
            [
                1.3736653232996774,
                0.907108498573625,
                0.7847446171185899,
                1.156796022975651,
                0.9066909638152494,
                0.478818489260254,
                0.7464754485801568,
                0.4312335884859304,
                0.47881848926066206,
                0.7009016514151587,
            ],
            [
                0.8940742997666457,
                0.8671533413301612,
                0.756247074366988,
                0.7287912519421545,
                0.21863818877054428,
                0.17967018899684342,
                0.19193678109476467,
                0.22019977608746172,
                0.4513008331069323,
                1.0554341649168666,
            ],
            [
                0.2485631846206986,
                0.11438388322780667,
                0.041614681409738494,
                0.9813454329895592,
                1.0120537808245802,
                0.3651481463113221,
                0.3202352693527206,
                0.36394535930920896,
                0.3792852462154986,
                0.3804280941596281,
            ],
            [
                0.3541616476153807,
                0.2608849238260666,
                0.2677769780582238,
                0.17128166152746926,
                0.5678949700027617,
                0.8784376047772038,
                1.2478672212548703,
                0.9586011392636432,
                0.3299626620525322,
                0.8472268668943336,
            ],
            [
                0.17879325340388713,
                0.23906125654859295,
                0.5245291383132006,
                0.835159133851027,
                0.8555613331652552,
                0.6678034241367441,
                0.36722208260161726,
                0.8494125986140834,
                0.7967774089824612,
                1.2687469769172344,
            ],
            [
                0.5431860040994623,
                0.6493259588572171,
                1.8554915623342167,
                0.925543876524477,
                0.4314528982279053,
                0.17255605705915866,
                0.19327668019613156,
                0.31639250165788724,
                0.9109058346072486,
                1.0052360983658788,
            ],
        ]
    )

    assert_almost_equal(mp[:, :10], desired)

    mp1 = matrix_profile(X[:100:2, :40:2])
    mp2 = matrix_profile(X[:100, :40:2])[::2]
    assert_almost_equal(mp1, mp2)
