# Authors: Isak Samsten
# License: BSD 3 clause

import numpy as np
from numpy.testing import assert_equal

from wildboar.datasets import load_gun_point
from wildboar.tree import ProximityTreeClassifier
from wildboar.utils.estimator_checks import check_estimator


def test_check_estimator():
    check_estimator(
        ProximityTreeClassifier(metric_factories={"euclidean": {}}),
        ignore=["check_sample_weights_invariance"],
    )


def test_proximity_tree_metric_factories():
    pass


def test_proximity_tree():
    x_train, x_test, y_train, y_test = load_gun_point(merge_train_test=False)
    clf = ProximityTreeClassifier(random_state=123)
    clf.fit(x_train, y_train)

    expected_predict = np.array(
        [
            2.0,
            2.0,
            1.0,
            1.0,
            2.0,
            1.0,
            2.0,
            2.0,
            2.0,
            1.0,
            1.0,
            1.0,
            1.0,
            1.0,
            2.0,
            1.0,
            2.0,
            2.0,
            1.0,
            2.0,
            1.0,
            1.0,
            1.0,
            2.0,
            1.0,
            2.0,
            1.0,
            1.0,
            2.0,
            1.0,
            1.0,
            2.0,
            2.0,
            1.0,
            2.0,
            1.0,
            2.0,
            2.0,
            2.0,
            2.0,
            2.0,
            1.0,
            1.0,
            1.0,
            2.0,
            1.0,
            1.0,
            2.0,
            1.0,
            2.0,
        ]
    )
    assert_equal(clf.predict(x_train), expected_predict)

    assert clf.score(x_test, y_test) > 0.74

    expected_branch = np.array(
        [
            [
                1,
                2,
                3,
                -1,
                5,
                -1,
                -1,
                8,
                9,
                -1,
                11,
                -1,
                13,
                -1,
                -1,
                -1,
                17,
                18,
                -1,
                -1,
                21,
                22,
                -1,
                -1,
                25,
                26,
                -1,
                28,
                -1,
                -1,
                -1,
            ],
            [
                16,
                7,
                4,
                -1,
                6,
                -1,
                -1,
                15,
                10,
                -1,
                12,
                -1,
                14,
                -1,
                -1,
                -1,
                20,
                19,
                -1,
                -1,
                24,
                23,
                -1,
                -1,
                30,
                27,
                -1,
                29,
                -1,
                -1,
                -1,
            ],
        ]
    )
    assert_equal(clf.tree_.branch, expected_branch)

    expected_apply = np.array(
        [
            29,
            3,
            18,
            11,
            14,
            13,
            26,
            28,
            5,
            13,
            3,
            23,
            13,
            29,
            11,
            5,
            13,
            13,
            15,
            14,
            11,
            28,
            9,
            13,
            11,
            22,
            29,
            29,
            9,
            14,
            13,
            28,
            22,
            9,
            13,
            6,
            9,
            6,
            11,
            14,
            9,
            18,
            6,
            6,
            29,
            26,
            30,
            14,
            15,
            5,
            14,
            29,
            9,
            18,
            9,
            26,
            28,
            14,
            9,
            15,
            29,
            18,
            29,
            14,
            14,
            6,
            11,
            14,
            13,
            13,
            3,
            14,
            5,
            22,
            22,
            14,
            14,
            18,
            22,
            14,
            26,
            19,
            18,
            3,
            9,
            14,
            23,
            9,
            9,
            3,
            9,
            28,
            9,
            30,
            15,
            13,
            14,
            30,
            29,
            9,
            28,
            11,
            29,
            5,
            3,
            5,
            14,
            22,
            9,
            15,
            14,
            15,
            29,
            22,
            9,
            11,
            28,
            11,
            3,
            28,
            11,
            22,
            3,
            18,
            26,
            29,
            6,
            6,
            28,
            18,
            30,
            14,
            11,
            3,
            19,
            18,
            23,
            14,
            29,
            5,
            18,
            19,
            9,
            18,
            13,
            13,
            5,
            5,
            29,
            26,
        ]
    )

    assert_equal(clf.apply(x_test), expected_apply)
