###
### This file was automatically generated
###

from archinfo.arch import register_arch, Endness, Register

from .common import ArchPcode


class ArchPcode_x86_LE_32_System_Management_Mode(ArchPcode):
    name = 'x86:LE:32:System Management Mode'
    pcode_arch = 'x86:LE:32:System Management Mode'
    description = 'Intel/AMD 32-bit x86 System Management Mode'
    bits = 32
    ip_offset = 0x284
    sp_offset = 0x10
    bp_offset = sp_offset
    instruction_endness = Endness.LE
    register_list = [
        Register('eax', 4, 0x0),
        Register('ax', 2, 0x0),
        Register('al', 1, 0x0),
        Register('ah', 1, 0x1),
        Register('ecx', 4, 0x4),
        Register('cx', 2, 0x4),
        Register('cl', 1, 0x4),
        Register('ch', 1, 0x5),
        Register('edx', 4, 0x8),
        Register('dx', 2, 0x8),
        Register('dl', 1, 0x8),
        Register('dh', 1, 0x9),
        Register('ebx', 4, 0xc),
        Register('bx', 2, 0xc),
        Register('bl', 1, 0xc),
        Register('bh', 1, 0xd),
        Register('esp', 4, 0x10),
        Register('sp', 2, 0x10),
        Register('ebp', 4, 0x14),
        Register('bp', 2, 0x14),
        Register('esi', 4, 0x18),
        Register('si', 2, 0x18),
        Register('edi', 4, 0x1c),
        Register('di', 2, 0x1c),
        Register('es', 2, 0x100),
        Register('cs', 2, 0x102),
        Register('ss', 2, 0x104),
        Register('ds', 2, 0x106),
        Register('fs', 2, 0x108),
        Register('gs', 2, 0x10a),
        Register('fs_offset', 4, 0x110),
        Register('gs_offset', 4, 0x114),
        Register('cf', 1, 0x200),
        Register('f1', 1, 0x201),
        Register('pf', 1, 0x202),
        Register('f3', 1, 0x203),
        Register('af', 1, 0x204),
        Register('f5', 1, 0x205),
        Register('zf', 1, 0x206),
        Register('sf', 1, 0x207),
        Register('tf', 1, 0x208),
        Register('if', 1, 0x209),
        Register('df', 1, 0x20a),
        Register('of', 1, 0x20b),
        Register('iopl', 1, 0x20c),
        Register('nt', 1, 0x20d),
        Register('f15', 1, 0x20e),
        Register('rf', 1, 0x20f),
        Register('vm', 1, 0x210),
        Register('ac', 1, 0x211),
        Register('vif', 1, 0x212),
        Register('vip', 1, 0x213),
        Register('id', 1, 0x214),
        Register('eflags', 4, 0x280),
        Register('flags', 2, 0x280),
        Register('eip', 4, 0x284, alias_names=('pc', 'ip')),
        Register('ip', 2, 0x284),
        Register('dr0', 4, 0x300),
        Register('dr1', 4, 0x304),
        Register('dr2', 4, 0x308),
        Register('dr3', 4, 0x30c),
        Register('dr4', 4, 0x310),
        Register('dr5', 4, 0x314),
        Register('dr6', 4, 0x318),
        Register('dr7', 4, 0x31c),
        Register('cr0', 4, 0x320),
        Register('cr2', 4, 0x328),
        Register('cr3', 4, 0x32c),
        Register('cr4', 4, 0x330),
        Register('tr0', 4, 0x400),
        Register('tr1', 4, 0x404),
        Register('tr2', 4, 0x408),
        Register('tr3', 4, 0x40c),
        Register('tr4', 4, 0x410),
        Register('tr5', 4, 0x414),
        Register('tr6', 4, 0x418),
        Register('tr7', 4, 0x41c),
        Register('xcr0', 8, 0x600),
        Register('bndcfgs', 8, 0x700),
        Register('bndcfgu', 8, 0x708),
        Register('bndstatus', 8, 0x710),
        Register('bnd0', 16, 0x740),
        Register('bnd0_lb', 8, 0x740),
        Register('bnd0_ub', 8, 0x748),
        Register('bnd1', 16, 0x750),
        Register('bnd1_lb', 8, 0x750),
        Register('bnd1_ub', 8, 0x758),
        Register('bnd2', 16, 0x760),
        Register('bnd2_lb', 8, 0x760),
        Register('bnd2_ub', 8, 0x768),
        Register('bnd3', 16, 0x770),
        Register('bnd3_lb', 8, 0x770),
        Register('bnd3_ub', 8, 0x778),
        Register('ssp', 8, 0x7c0),
        Register('ia32_pl2_ssp', 8, 0x7c8),
        Register('ia32_pl1_ssp', 8, 0x7d0),
        Register('ia32_pl0_ssp', 8, 0x7d8),
        Register('st0', 10, 0x1000),
        Register('st1', 10, 0x100a),
        Register('st2', 10, 0x1014),
        Register('st3', 10, 0x101e),
        Register('st4', 10, 0x1028),
        Register('st5', 10, 0x1032),
        Register('st6', 10, 0x103c),
        Register('st7', 10, 0x1046),
        Register('c0', 1, 0x1080),
        Register('c1', 1, 0x1081),
        Register('c2', 1, 0x1082),
        Register('c3', 1, 0x1083),
        Register('mxcsr', 4, 0x1084),
        Register('fpucontrolword', 2, 0x1090),
        Register('fpustatusword', 2, 0x1092),
        Register('fputagword', 2, 0x1094),
        Register('fpulastinstructionopcode', 2, 0x1096),
        Register('fpudatapointer', 4, 0x1098),
        Register('fpuinstructionpointer', 4, 0x109c),
        Register('mm0', 8, 0x1100),
        Register('mm0_da', 4, 0x1100),
        Register('mm0_wa', 2, 0x1100),
        Register('mm0_ba', 1, 0x1100),
        Register('mm0_bb', 1, 0x1101),
        Register('mm0_wb', 2, 0x1102),
        Register('mm0_bc', 1, 0x1102),
        Register('mm0_bd', 1, 0x1103),
        Register('mm0_db', 4, 0x1104),
        Register('mm0_wc', 2, 0x1104),
        Register('mm0_be', 1, 0x1104),
        Register('mm0_bf', 1, 0x1105),
        Register('mm0_wd', 2, 0x1106),
        Register('mm0_bg', 1, 0x1106),
        Register('mm0_bh', 1, 0x1107),
        Register('mm1', 8, 0x1108),
        Register('mm1_da', 4, 0x1108),
        Register('mm1_wa', 2, 0x1108),
        Register('mm1_ba', 1, 0x1108),
        Register('mm1_bb', 1, 0x1109),
        Register('mm1_wb', 2, 0x110a),
        Register('mm1_bc', 1, 0x110a),
        Register('mm1_bd', 1, 0x110b),
        Register('mm1_db', 4, 0x110c),
        Register('mm1_wc', 2, 0x110c),
        Register('mm1_be', 1, 0x110c),
        Register('mm1_bf', 1, 0x110d),
        Register('mm1_wd', 2, 0x110e),
        Register('mm1_bg', 1, 0x110e),
        Register('mm1_bh', 1, 0x110f),
        Register('mm2', 8, 0x1110),
        Register('mm2_da', 4, 0x1110),
        Register('mm2_wa', 2, 0x1110),
        Register('mm2_ba', 1, 0x1110),
        Register('mm2_bb', 1, 0x1111),
        Register('mm2_wb', 2, 0x1112),
        Register('mm2_bc', 1, 0x1112),
        Register('mm2_bd', 1, 0x1113),
        Register('mm2_db', 4, 0x1114),
        Register('mm2_wc', 2, 0x1114),
        Register('mm2_be', 1, 0x1114),
        Register('mm2_bf', 1, 0x1115),
        Register('mm2_wd', 2, 0x1116),
        Register('mm2_bg', 1, 0x1116),
        Register('mm2_bh', 1, 0x1117),
        Register('mm3', 8, 0x1118),
        Register('mm3_da', 4, 0x1118),
        Register('mm3_wa', 2, 0x1118),
        Register('mm3_ba', 1, 0x1118),
        Register('mm3_bb', 1, 0x1119),
        Register('mm3_wb', 2, 0x111a),
        Register('mm3_bc', 1, 0x111a),
        Register('mm3_bd', 1, 0x111b),
        Register('mm3_db', 4, 0x111c),
        Register('mm3_wc', 2, 0x111c),
        Register('mm3_be', 1, 0x111c),
        Register('mm3_bf', 1, 0x111d),
        Register('mm3_wd', 2, 0x111e),
        Register('mm3_bg', 1, 0x111e),
        Register('mm3_bh', 1, 0x111f),
        Register('mm4', 8, 0x1120),
        Register('mm4_da', 4, 0x1120),
        Register('mm4_wa', 2, 0x1120),
        Register('mm4_ba', 1, 0x1120),
        Register('mm4_bb', 1, 0x1121),
        Register('mm4_wb', 2, 0x1122),
        Register('mm4_bc', 1, 0x1122),
        Register('mm4_bd', 1, 0x1123),
        Register('mm4_db', 4, 0x1124),
        Register('mm4_wc', 2, 0x1124),
        Register('mm4_be', 1, 0x1124),
        Register('mm4_bf', 1, 0x1125),
        Register('mm4_wd', 2, 0x1126),
        Register('mm4_bg', 1, 0x1126),
        Register('mm4_bh', 1, 0x1127),
        Register('mm5', 8, 0x1128),
        Register('mm5_da', 4, 0x1128),
        Register('mm5_wa', 2, 0x1128),
        Register('mm5_ba', 1, 0x1128),
        Register('mm5_bb', 1, 0x1129),
        Register('mm5_wb', 2, 0x112a),
        Register('mm5_bc', 1, 0x112a),
        Register('mm5_bd', 1, 0x112b),
        Register('mm5_db', 4, 0x112c),
        Register('mm5_wc', 2, 0x112c),
        Register('mm5_be', 1, 0x112c),
        Register('mm5_bf', 1, 0x112d),
        Register('mm5_wd', 2, 0x112e),
        Register('mm5_bg', 1, 0x112e),
        Register('mm5_bh', 1, 0x112f),
        Register('mm6', 8, 0x1130),
        Register('mm6_da', 4, 0x1130),
        Register('mm6_wa', 2, 0x1130),
        Register('mm6_ba', 1, 0x1130),
        Register('mm6_bb', 1, 0x1131),
        Register('mm6_wb', 2, 0x1132),
        Register('mm6_bc', 1, 0x1132),
        Register('mm6_bd', 1, 0x1133),
        Register('mm6_db', 4, 0x1134),
        Register('mm6_wc', 2, 0x1134),
        Register('mm6_be', 1, 0x1134),
        Register('mm6_bf', 1, 0x1135),
        Register('mm6_wd', 2, 0x1136),
        Register('mm6_bg', 1, 0x1136),
        Register('mm6_bh', 1, 0x1137),
        Register('mm7', 8, 0x1138),
        Register('mm7_da', 4, 0x1138),
        Register('mm7_wa', 2, 0x1138),
        Register('mm7_ba', 1, 0x1138),
        Register('mm7_bb', 1, 0x1139),
        Register('mm7_wb', 2, 0x113a),
        Register('mm7_bc', 1, 0x113a),
        Register('mm7_bd', 1, 0x113b),
        Register('mm7_db', 4, 0x113c),
        Register('mm7_wc', 2, 0x113c),
        Register('mm7_be', 1, 0x113c),
        Register('mm7_bf', 1, 0x113d),
        Register('mm7_wd', 2, 0x113e),
        Register('mm7_bg', 1, 0x113e),
        Register('mm7_bh', 1, 0x113f),
        Register('ymm0', 32, 0x1200),
        Register('xmm0', 16, 0x1200),
        Register('xmm0_qa', 8, 0x1200),
        Register('xmm0_da', 4, 0x1200),
        Register('xmm0_wa', 2, 0x1200),
        Register('xmm0_ba', 1, 0x1200),
        Register('xmm0_bb', 1, 0x1201),
        Register('xmm0_wb', 2, 0x1202),
        Register('xmm0_bc', 1, 0x1202),
        Register('xmm0_bd', 1, 0x1203),
        Register('xmm0_db', 4, 0x1204),
        Register('xmm0_wc', 2, 0x1204),
        Register('xmm0_be', 1, 0x1204),
        Register('xmm0_bf', 1, 0x1205),
        Register('xmm0_wd', 2, 0x1206),
        Register('xmm0_bg', 1, 0x1206),
        Register('xmm0_bh', 1, 0x1207),
        Register('xmm0_qb', 8, 0x1208),
        Register('xmm0_dc', 4, 0x1208),
        Register('xmm0_we', 2, 0x1208),
        Register('xmm0_bi', 1, 0x1208),
        Register('xmm0_bj', 1, 0x1209),
        Register('xmm0_wf', 2, 0x120a),
        Register('xmm0_bk', 1, 0x120a),
        Register('xmm0_bl', 1, 0x120b),
        Register('xmm0_dd', 4, 0x120c),
        Register('xmm0_wg', 2, 0x120c),
        Register('xmm0_bm', 1, 0x120c),
        Register('xmm0_bn', 1, 0x120d),
        Register('xmm0_wh', 2, 0x120e),
        Register('xmm0_bo', 1, 0x120e),
        Register('xmm0_bp', 1, 0x120f),
        Register('ymm0_h', 16, 0x1210),
        Register('ymm1', 32, 0x1220),
        Register('xmm1', 16, 0x1220),
        Register('xmm1_qa', 8, 0x1220),
        Register('xmm1_da', 4, 0x1220),
        Register('xmm1_wa', 2, 0x1220),
        Register('xmm1_ba', 1, 0x1220),
        Register('xmm1_bb', 1, 0x1221),
        Register('xmm1_wb', 2, 0x1222),
        Register('xmm1_bc', 1, 0x1222),
        Register('xmm1_bd', 1, 0x1223),
        Register('xmm1_db', 4, 0x1224),
        Register('xmm1_wc', 2, 0x1224),
        Register('xmm1_be', 1, 0x1224),
        Register('xmm1_bf', 1, 0x1225),
        Register('xmm1_wd', 2, 0x1226),
        Register('xmm1_bg', 1, 0x1226),
        Register('xmm1_bh', 1, 0x1227),
        Register('xmm1_qb', 8, 0x1228),
        Register('xmm1_dc', 4, 0x1228),
        Register('xmm1_we', 2, 0x1228),
        Register('xmm1_bi', 1, 0x1228),
        Register('xmm1_bj', 1, 0x1229),
        Register('xmm1_wf', 2, 0x122a),
        Register('xmm1_bk', 1, 0x122a),
        Register('xmm1_bl', 1, 0x122b),
        Register('xmm1_dd', 4, 0x122c),
        Register('xmm1_wg', 2, 0x122c),
        Register('xmm1_bm', 1, 0x122c),
        Register('xmm1_bn', 1, 0x122d),
        Register('xmm1_wh', 2, 0x122e),
        Register('xmm1_bo', 1, 0x122e),
        Register('xmm1_bp', 1, 0x122f),
        Register('ymm1_h', 16, 0x1230),
        Register('ymm2', 32, 0x1240),
        Register('xmm2', 16, 0x1240),
        Register('xmm2_qa', 8, 0x1240),
        Register('xmm2_da', 4, 0x1240),
        Register('xmm2_wa', 2, 0x1240),
        Register('xmm2_ba', 1, 0x1240),
        Register('xmm2_bb', 1, 0x1241),
        Register('xmm2_wb', 2, 0x1242),
        Register('xmm2_bc', 1, 0x1242),
        Register('xmm2_bd', 1, 0x1243),
        Register('xmm2_db', 4, 0x1244),
        Register('xmm2_wc', 2, 0x1244),
        Register('xmm2_be', 1, 0x1244),
        Register('xmm2_bf', 1, 0x1245),
        Register('xmm2_wd', 2, 0x1246),
        Register('xmm2_bg', 1, 0x1246),
        Register('xmm2_bh', 1, 0x1247),
        Register('xmm2_qb', 8, 0x1248),
        Register('xmm2_dc', 4, 0x1248),
        Register('xmm2_we', 2, 0x1248),
        Register('xmm2_bi', 1, 0x1248),
        Register('xmm2_bj', 1, 0x1249),
        Register('xmm2_wf', 2, 0x124a),
        Register('xmm2_bk', 1, 0x124a),
        Register('xmm2_bl', 1, 0x124b),
        Register('xmm2_dd', 4, 0x124c),
        Register('xmm2_wg', 2, 0x124c),
        Register('xmm2_bm', 1, 0x124c),
        Register('xmm2_bn', 1, 0x124d),
        Register('xmm2_wh', 2, 0x124e),
        Register('xmm2_bo', 1, 0x124e),
        Register('xmm2_bp', 1, 0x124f),
        Register('ymm2_h', 16, 0x1250),
        Register('ymm3', 32, 0x1260),
        Register('xmm3', 16, 0x1260),
        Register('xmm3_qa', 8, 0x1260),
        Register('xmm3_da', 4, 0x1260),
        Register('xmm3_wa', 2, 0x1260),
        Register('xmm3_ba', 1, 0x1260),
        Register('xmm3_bb', 1, 0x1261),
        Register('xmm3_wb', 2, 0x1262),
        Register('xmm3_bc', 1, 0x1262),
        Register('xmm3_bd', 1, 0x1263),
        Register('xmm3_db', 4, 0x1264),
        Register('xmm3_wc', 2, 0x1264),
        Register('xmm3_be', 1, 0x1264),
        Register('xmm3_bf', 1, 0x1265),
        Register('xmm3_wd', 2, 0x1266),
        Register('xmm3_bg', 1, 0x1266),
        Register('xmm3_bh', 1, 0x1267),
        Register('xmm3_qb', 8, 0x1268),
        Register('xmm3_dc', 4, 0x1268),
        Register('xmm3_we', 2, 0x1268),
        Register('xmm3_bi', 1, 0x1268),
        Register('xmm3_bj', 1, 0x1269),
        Register('xmm3_wf', 2, 0x126a),
        Register('xmm3_bk', 1, 0x126a),
        Register('xmm3_bl', 1, 0x126b),
        Register('xmm3_dd', 4, 0x126c),
        Register('xmm3_wg', 2, 0x126c),
        Register('xmm3_bm', 1, 0x126c),
        Register('xmm3_bn', 1, 0x126d),
        Register('xmm3_wh', 2, 0x126e),
        Register('xmm3_bo', 1, 0x126e),
        Register('xmm3_bp', 1, 0x126f),
        Register('ymm3_h', 16, 0x1270),
        Register('ymm4', 32, 0x1280),
        Register('xmm4', 16, 0x1280),
        Register('xmm4_qa', 8, 0x1280),
        Register('xmm4_da', 4, 0x1280),
        Register('xmm4_wa', 2, 0x1280),
        Register('xmm4_ba', 1, 0x1280),
        Register('xmm4_bb', 1, 0x1281),
        Register('xmm4_wb', 2, 0x1282),
        Register('xmm4_bc', 1, 0x1282),
        Register('xmm4_bd', 1, 0x1283),
        Register('xmm4_db', 4, 0x1284),
        Register('xmm4_wc', 2, 0x1284),
        Register('xmm4_be', 1, 0x1284),
        Register('xmm4_bf', 1, 0x1285),
        Register('xmm4_wd', 2, 0x1286),
        Register('xmm4_bg', 1, 0x1286),
        Register('xmm4_bh', 1, 0x1287),
        Register('xmm4_qb', 8, 0x1288),
        Register('xmm4_dc', 4, 0x1288),
        Register('xmm4_we', 2, 0x1288),
        Register('xmm4_bi', 1, 0x1288),
        Register('xmm4_bj', 1, 0x1289),
        Register('xmm4_wf', 2, 0x128a),
        Register('xmm4_bk', 1, 0x128a),
        Register('xmm4_bl', 1, 0x128b),
        Register('xmm4_dd', 4, 0x128c),
        Register('xmm4_wg', 2, 0x128c),
        Register('xmm4_bm', 1, 0x128c),
        Register('xmm4_bn', 1, 0x128d),
        Register('xmm4_wh', 2, 0x128e),
        Register('xmm4_bo', 1, 0x128e),
        Register('xmm4_bp', 1, 0x128f),
        Register('ymm4_h', 16, 0x1290),
        Register('ymm5', 32, 0x12a0),
        Register('xmm5', 16, 0x12a0),
        Register('xmm5_qa', 8, 0x12a0),
        Register('xmm5_da', 4, 0x12a0),
        Register('xmm5_wa', 2, 0x12a0),
        Register('xmm5_ba', 1, 0x12a0),
        Register('xmm5_bb', 1, 0x12a1),
        Register('xmm5_wb', 2, 0x12a2),
        Register('xmm5_bc', 1, 0x12a2),
        Register('xmm5_bd', 1, 0x12a3),
        Register('xmm5_db', 4, 0x12a4),
        Register('xmm5_wc', 2, 0x12a4),
        Register('xmm5_be', 1, 0x12a4),
        Register('xmm5_bf', 1, 0x12a5),
        Register('xmm5_wd', 2, 0x12a6),
        Register('xmm5_bg', 1, 0x12a6),
        Register('xmm5_bh', 1, 0x12a7),
        Register('xmm5_qb', 8, 0x12a8),
        Register('xmm5_dc', 4, 0x12a8),
        Register('xmm5_we', 2, 0x12a8),
        Register('xmm5_bi', 1, 0x12a8),
        Register('xmm5_bj', 1, 0x12a9),
        Register('xmm5_wf', 2, 0x12aa),
        Register('xmm5_bk', 1, 0x12aa),
        Register('xmm5_bl', 1, 0x12ab),
        Register('xmm5_dd', 4, 0x12ac),
        Register('xmm5_wg', 2, 0x12ac),
        Register('xmm5_bm', 1, 0x12ac),
        Register('xmm5_bn', 1, 0x12ad),
        Register('xmm5_wh', 2, 0x12ae),
        Register('xmm5_bo', 1, 0x12ae),
        Register('xmm5_bp', 1, 0x12af),
        Register('ymm5_h', 16, 0x12b0),
        Register('ymm6', 32, 0x12c0),
        Register('xmm6', 16, 0x12c0),
        Register('xmm6_qa', 8, 0x12c0),
        Register('xmm6_da', 4, 0x12c0),
        Register('xmm6_wa', 2, 0x12c0),
        Register('xmm6_ba', 1, 0x12c0),
        Register('xmm6_bb', 1, 0x12c1),
        Register('xmm6_wb', 2, 0x12c2),
        Register('xmm6_bc', 1, 0x12c2),
        Register('xmm6_bd', 1, 0x12c3),
        Register('xmm6_db', 4, 0x12c4),
        Register('xmm6_wc', 2, 0x12c4),
        Register('xmm6_be', 1, 0x12c4),
        Register('xmm6_bf', 1, 0x12c5),
        Register('xmm6_wd', 2, 0x12c6),
        Register('xmm6_bg', 1, 0x12c6),
        Register('xmm6_bh', 1, 0x12c7),
        Register('xmm6_qb', 8, 0x12c8),
        Register('xmm6_dc', 4, 0x12c8),
        Register('xmm6_we', 2, 0x12c8),
        Register('xmm6_bi', 1, 0x12c8),
        Register('xmm6_bj', 1, 0x12c9),
        Register('xmm6_wf', 2, 0x12ca),
        Register('xmm6_bk', 1, 0x12ca),
        Register('xmm6_bl', 1, 0x12cb),
        Register('xmm6_dd', 4, 0x12cc),
        Register('xmm6_wg', 2, 0x12cc),
        Register('xmm6_bm', 1, 0x12cc),
        Register('xmm6_bn', 1, 0x12cd),
        Register('xmm6_wh', 2, 0x12ce),
        Register('xmm6_bo', 1, 0x12ce),
        Register('xmm6_bp', 1, 0x12cf),
        Register('ymm6_h', 16, 0x12d0),
        Register('ymm7', 32, 0x12e0),
        Register('xmm7', 16, 0x12e0),
        Register('xmm7_qa', 8, 0x12e0),
        Register('xmm7_da', 4, 0x12e0),
        Register('xmm7_wa', 2, 0x12e0),
        Register('xmm7_ba', 1, 0x12e0),
        Register('xmm7_bb', 1, 0x12e1),
        Register('xmm7_wb', 2, 0x12e2),
        Register('xmm7_bc', 1, 0x12e2),
        Register('xmm7_bd', 1, 0x12e3),
        Register('xmm7_db', 4, 0x12e4),
        Register('xmm7_wc', 2, 0x12e4),
        Register('xmm7_be', 1, 0x12e4),
        Register('xmm7_bf', 1, 0x12e5),
        Register('xmm7_wd', 2, 0x12e6),
        Register('xmm7_bg', 1, 0x12e6),
        Register('xmm7_bh', 1, 0x12e7),
        Register('xmm7_qb', 8, 0x12e8),
        Register('xmm7_dc', 4, 0x12e8),
        Register('xmm7_we', 2, 0x12e8),
        Register('xmm7_bi', 1, 0x12e8),
        Register('xmm7_bj', 1, 0x12e9),
        Register('xmm7_wf', 2, 0x12ea),
        Register('xmm7_bk', 1, 0x12ea),
        Register('xmm7_bl', 1, 0x12eb),
        Register('xmm7_dd', 4, 0x12ec),
        Register('xmm7_wg', 2, 0x12ec),
        Register('xmm7_bm', 1, 0x12ec),
        Register('xmm7_bn', 1, 0x12ed),
        Register('xmm7_wh', 2, 0x12ee),
        Register('xmm7_bo', 1, 0x12ee),
        Register('xmm7_bp', 1, 0x12ef),
        Register('ymm7_h', 16, 0x12f0),
        Register('ymm8', 32, 0x1300),
        Register('xmm8', 16, 0x1300),
        Register('xmm8_qa', 8, 0x1300),
        Register('xmm8_da', 4, 0x1300),
        Register('xmm8_wa', 2, 0x1300),
        Register('xmm8_ba', 1, 0x1300),
        Register('xmm8_bb', 1, 0x1301),
        Register('xmm8_wb', 2, 0x1302),
        Register('xmm8_bc', 1, 0x1302),
        Register('xmm8_bd', 1, 0x1303),
        Register('xmm8_db', 4, 0x1304),
        Register('xmm8_wc', 2, 0x1304),
        Register('xmm8_be', 1, 0x1304),
        Register('xmm8_bf', 1, 0x1305),
        Register('xmm8_wd', 2, 0x1306),
        Register('xmm8_bg', 1, 0x1306),
        Register('xmm8_bh', 1, 0x1307),
        Register('xmm8_qb', 8, 0x1308),
        Register('xmm8_dc', 4, 0x1308),
        Register('xmm8_we', 2, 0x1308),
        Register('xmm8_bi', 1, 0x1308),
        Register('xmm8_bj', 1, 0x1309),
        Register('xmm8_wf', 2, 0x130a),
        Register('xmm8_bk', 1, 0x130a),
        Register('xmm8_bl', 1, 0x130b),
        Register('xmm8_dd', 4, 0x130c),
        Register('xmm8_wg', 2, 0x130c),
        Register('xmm8_bm', 1, 0x130c),
        Register('xmm8_bn', 1, 0x130d),
        Register('xmm8_wh', 2, 0x130e),
        Register('xmm8_bo', 1, 0x130e),
        Register('xmm8_bp', 1, 0x130f),
        Register('ymm8_h', 16, 0x1310),
        Register('ymm9', 32, 0x1320),
        Register('xmm9', 16, 0x1320),
        Register('xmm9_qa', 8, 0x1320),
        Register('xmm9_da', 4, 0x1320),
        Register('xmm9_wa', 2, 0x1320),
        Register('xmm9_ba', 1, 0x1320),
        Register('xmm9_bb', 1, 0x1321),
        Register('xmm9_wb', 2, 0x1322),
        Register('xmm9_bc', 1, 0x1322),
        Register('xmm9_bd', 1, 0x1323),
        Register('xmm9_db', 4, 0x1324),
        Register('xmm9_wc', 2, 0x1324),
        Register('xmm9_be', 1, 0x1324),
        Register('xmm9_bf', 1, 0x1325),
        Register('xmm9_wd', 2, 0x1326),
        Register('xmm9_bg', 1, 0x1326),
        Register('xmm9_bh', 1, 0x1327),
        Register('xmm9_qb', 8, 0x1328),
        Register('xmm9_dc', 4, 0x1328),
        Register('xmm9_we', 2, 0x1328),
        Register('xmm9_bi', 1, 0x1328),
        Register('xmm9_bj', 1, 0x1329),
        Register('xmm9_wf', 2, 0x132a),
        Register('xmm9_bk', 1, 0x132a),
        Register('xmm9_bl', 1, 0x132b),
        Register('xmm9_dd', 4, 0x132c),
        Register('xmm9_wg', 2, 0x132c),
        Register('xmm9_bm', 1, 0x132c),
        Register('xmm9_bn', 1, 0x132d),
        Register('xmm9_wh', 2, 0x132e),
        Register('xmm9_bo', 1, 0x132e),
        Register('xmm9_bp', 1, 0x132f),
        Register('ymm9_h', 16, 0x1330),
        Register('ymm10', 32, 0x1340),
        Register('xmm10', 16, 0x1340),
        Register('xmm10_qa', 8, 0x1340),
        Register('xmm10_da', 4, 0x1340),
        Register('xmm10_wa', 2, 0x1340),
        Register('xmm10_ba', 1, 0x1340),
        Register('xmm10_bb', 1, 0x1341),
        Register('xmm10_wb', 2, 0x1342),
        Register('xmm10_bc', 1, 0x1342),
        Register('xmm10_bd', 1, 0x1343),
        Register('xmm10_db', 4, 0x1344),
        Register('xmm10_wc', 2, 0x1344),
        Register('xmm10_be', 1, 0x1344),
        Register('xmm10_bf', 1, 0x1345),
        Register('xmm10_wd', 2, 0x1346),
        Register('xmm10_bg', 1, 0x1346),
        Register('xmm10_bh', 1, 0x1347),
        Register('xmm10_qb', 8, 0x1348),
        Register('xmm10_dc', 4, 0x1348),
        Register('xmm10_we', 2, 0x1348),
        Register('xmm10_bi', 1, 0x1348),
        Register('xmm10_bj', 1, 0x1349),
        Register('xmm10_wf', 2, 0x134a),
        Register('xmm10_bk', 1, 0x134a),
        Register('xmm10_bl', 1, 0x134b),
        Register('xmm10_dd', 4, 0x134c),
        Register('xmm10_wg', 2, 0x134c),
        Register('xmm10_bm', 1, 0x134c),
        Register('xmm10_bn', 1, 0x134d),
        Register('xmm10_wh', 2, 0x134e),
        Register('xmm10_bo', 1, 0x134e),
        Register('xmm10_bp', 1, 0x134f),
        Register('ymm10_h', 16, 0x1350),
        Register('ymm11', 32, 0x1360),
        Register('xmm11', 16, 0x1360),
        Register('xmm11_qa', 8, 0x1360),
        Register('xmm11_da', 4, 0x1360),
        Register('xmm11_wa', 2, 0x1360),
        Register('xmm11_ba', 1, 0x1360),
        Register('xmm11_bb', 1, 0x1361),
        Register('xmm11_wb', 2, 0x1362),
        Register('xmm11_bc', 1, 0x1362),
        Register('xmm11_bd', 1, 0x1363),
        Register('xmm11_db', 4, 0x1364),
        Register('xmm11_wc', 2, 0x1364),
        Register('xmm11_be', 1, 0x1364),
        Register('xmm11_bf', 1, 0x1365),
        Register('xmm11_wd', 2, 0x1366),
        Register('xmm11_bg', 1, 0x1366),
        Register('xmm11_bh', 1, 0x1367),
        Register('xmm11_qb', 8, 0x1368),
        Register('xmm11_dc', 4, 0x1368),
        Register('xmm11_we', 2, 0x1368),
        Register('xmm11_bi', 1, 0x1368),
        Register('xmm11_bj', 1, 0x1369),
        Register('xmm11_wf', 2, 0x136a),
        Register('xmm11_bk', 1, 0x136a),
        Register('xmm11_bl', 1, 0x136b),
        Register('xmm11_dd', 4, 0x136c),
        Register('xmm11_wg', 2, 0x136c),
        Register('xmm11_bm', 1, 0x136c),
        Register('xmm11_bn', 1, 0x136d),
        Register('xmm11_wh', 2, 0x136e),
        Register('xmm11_bo', 1, 0x136e),
        Register('xmm11_bp', 1, 0x136f),
        Register('ymm11_h', 16, 0x1370),
        Register('ymm12', 32, 0x1380),
        Register('xmm12', 16, 0x1380),
        Register('xmm12_qa', 8, 0x1380),
        Register('xmm12_da', 4, 0x1380),
        Register('xmm12_wa', 2, 0x1380),
        Register('xmm12_ba', 1, 0x1380),
        Register('xmm12_bb', 1, 0x1381),
        Register('xmm12_wb', 2, 0x1382),
        Register('xmm12_bc', 1, 0x1382),
        Register('xmm12_bd', 1, 0x1383),
        Register('xmm12_db', 4, 0x1384),
        Register('xmm12_wc', 2, 0x1384),
        Register('xmm12_be', 1, 0x1384),
        Register('xmm12_bf', 1, 0x1385),
        Register('xmm12_wd', 2, 0x1386),
        Register('xmm12_bg', 1, 0x1386),
        Register('xmm12_bh', 1, 0x1387),
        Register('xmm12_qb', 8, 0x1388),
        Register('xmm12_dc', 4, 0x1388),
        Register('xmm12_we', 2, 0x1388),
        Register('xmm12_bi', 1, 0x1388),
        Register('xmm12_bj', 1, 0x1389),
        Register('xmm12_wf', 2, 0x138a),
        Register('xmm12_bk', 1, 0x138a),
        Register('xmm12_bl', 1, 0x138b),
        Register('xmm12_dd', 4, 0x138c),
        Register('xmm12_wg', 2, 0x138c),
        Register('xmm12_bm', 1, 0x138c),
        Register('xmm12_bn', 1, 0x138d),
        Register('xmm12_wh', 2, 0x138e),
        Register('xmm12_bo', 1, 0x138e),
        Register('xmm12_bp', 1, 0x138f),
        Register('ymm12_h', 16, 0x1390),
        Register('ymm13', 32, 0x13a0),
        Register('xmm13', 16, 0x13a0),
        Register('xmm13_qa', 8, 0x13a0),
        Register('xmm13_da', 4, 0x13a0),
        Register('xmm13_wa', 2, 0x13a0),
        Register('xmm13_ba', 1, 0x13a0),
        Register('xmm13_bb', 1, 0x13a1),
        Register('xmm13_wb', 2, 0x13a2),
        Register('xmm13_bc', 1, 0x13a2),
        Register('xmm13_bd', 1, 0x13a3),
        Register('xmm13_db', 4, 0x13a4),
        Register('xmm13_wc', 2, 0x13a4),
        Register('xmm13_be', 1, 0x13a4),
        Register('xmm13_bf', 1, 0x13a5),
        Register('xmm13_wd', 2, 0x13a6),
        Register('xmm13_bg', 1, 0x13a6),
        Register('xmm13_bh', 1, 0x13a7),
        Register('xmm13_qb', 8, 0x13a8),
        Register('xmm13_dc', 4, 0x13a8),
        Register('xmm13_we', 2, 0x13a8),
        Register('xmm13_bi', 1, 0x13a8),
        Register('xmm13_bj', 1, 0x13a9),
        Register('xmm13_wf', 2, 0x13aa),
        Register('xmm13_bk', 1, 0x13aa),
        Register('xmm13_bl', 1, 0x13ab),
        Register('xmm13_dd', 4, 0x13ac),
        Register('xmm13_wg', 2, 0x13ac),
        Register('xmm13_bm', 1, 0x13ac),
        Register('xmm13_bn', 1, 0x13ad),
        Register('xmm13_wh', 2, 0x13ae),
        Register('xmm13_bo', 1, 0x13ae),
        Register('xmm13_bp', 1, 0x13af),
        Register('ymm13_h', 16, 0x13b0),
        Register('ymm14', 32, 0x13c0),
        Register('xmm14', 16, 0x13c0),
        Register('xmm14_qa', 8, 0x13c0),
        Register('xmm14_da', 4, 0x13c0),
        Register('xmm14_wa', 2, 0x13c0),
        Register('xmm14_ba', 1, 0x13c0),
        Register('xmm14_bb', 1, 0x13c1),
        Register('xmm14_wb', 2, 0x13c2),
        Register('xmm14_bc', 1, 0x13c2),
        Register('xmm14_bd', 1, 0x13c3),
        Register('xmm14_db', 4, 0x13c4),
        Register('xmm14_wc', 2, 0x13c4),
        Register('xmm14_be', 1, 0x13c4),
        Register('xmm14_bf', 1, 0x13c5),
        Register('xmm14_wd', 2, 0x13c6),
        Register('xmm14_bg', 1, 0x13c6),
        Register('xmm14_bh', 1, 0x13c7),
        Register('xmm14_qb', 8, 0x13c8),
        Register('xmm14_dc', 4, 0x13c8),
        Register('xmm14_we', 2, 0x13c8),
        Register('xmm14_bi', 1, 0x13c8),
        Register('xmm14_bj', 1, 0x13c9),
        Register('xmm14_wf', 2, 0x13ca),
        Register('xmm14_bk', 1, 0x13ca),
        Register('xmm14_bl', 1, 0x13cb),
        Register('xmm14_dd', 4, 0x13cc),
        Register('xmm14_wg', 2, 0x13cc),
        Register('xmm14_bm', 1, 0x13cc),
        Register('xmm14_bn', 1, 0x13cd),
        Register('xmm14_wh', 2, 0x13ce),
        Register('xmm14_bo', 1, 0x13ce),
        Register('xmm14_bp', 1, 0x13cf),
        Register('ymm14_h', 16, 0x13d0),
        Register('ymm15', 32, 0x13e0),
        Register('xmm15', 16, 0x13e0),
        Register('xmm15_qa', 8, 0x13e0),
        Register('xmm15_da', 4, 0x13e0),
        Register('xmm15_wa', 2, 0x13e0),
        Register('xmm15_ba', 1, 0x13e0),
        Register('xmm15_bb', 1, 0x13e1),
        Register('xmm15_wb', 2, 0x13e2),
        Register('xmm15_bc', 1, 0x13e2),
        Register('xmm15_bd', 1, 0x13e3),
        Register('xmm15_db', 4, 0x13e4),
        Register('xmm15_wc', 2, 0x13e4),
        Register('xmm15_be', 1, 0x13e4),
        Register('xmm15_bf', 1, 0x13e5),
        Register('xmm15_wd', 2, 0x13e6),
        Register('xmm15_bg', 1, 0x13e6),
        Register('xmm15_bh', 1, 0x13e7),
        Register('xmm15_qb', 8, 0x13e8),
        Register('xmm15_dc', 4, 0x13e8),
        Register('xmm15_we', 2, 0x13e8),
        Register('xmm15_bi', 1, 0x13e8),
        Register('xmm15_bj', 1, 0x13e9),
        Register('xmm15_wf', 2, 0x13ea),
        Register('xmm15_bk', 1, 0x13ea),
        Register('xmm15_bl', 1, 0x13eb),
        Register('xmm15_dd', 4, 0x13ec),
        Register('xmm15_wg', 2, 0x13ec),
        Register('xmm15_bm', 1, 0x13ec),
        Register('xmm15_bn', 1, 0x13ed),
        Register('xmm15_wh', 2, 0x13ee),
        Register('xmm15_bo', 1, 0x13ee),
        Register('xmm15_bp', 1, 0x13ef),
        Register('ymm15_h', 16, 0x13f0),
        Register('xmmtmp1', 16, 0x1400),
        Register('xmmtmp1_qa', 8, 0x1400),
        Register('xmmtmp1_da', 4, 0x1400),
        Register('xmmtmp1_db', 4, 0x1404),
        Register('xmmtmp1_qb', 8, 0x1408),
        Register('xmmtmp1_dc', 4, 0x1408),
        Register('xmmtmp1_dd', 4, 0x140c),
        Register('xmmtmp2', 16, 0x1410),
        Register('xmmtmp2_qa', 8, 0x1410),
        Register('xmmtmp2_da', 4, 0x1410),
        Register('xmmtmp2_db', 4, 0x1414),
        Register('xmmtmp2_qb', 8, 0x1418),
        Register('xmmtmp2_dc', 4, 0x1418),
        Register('xmmtmp2_dd', 4, 0x141c),
        Register('contextreg', 4, 0x2000),
        Register('idtr', 6, 0x2200),
        Register('idtr_limit', 2, 0x2200),
        Register('idtr_address', 4, 0x2202),
        Register('gdtr', 6, 0x2210),
        Register('gdtr_limit', 2, 0x2210),
        Register('gdtr_address', 4, 0x2212),
        Register('ldtr', 6, 0x2220),
        Register('ldtr_limit', 2, 0x2220),
        Register('ldtr_address', 4, 0x2222),
        Register('tr', 6, 0x2230),
        Register('tr_limit', 2, 0x2230),
        Register('tr_address', 4, 0x2232)
    ]

register_arch(['x86:le:32:system management mode'], 32, Endness.LE, ArchPcode_x86_LE_32_System_Management_Mode)
