# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("dnsapi.dll")
prototypes = \
    {
        # 
        'DnsQueryConfig': SimTypeFunction([SimTypeInt(signed=False, label="DNS_CONFIG_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Config", "Flag", "pwsAdapterName", "pReserved", "pBuffer", "pBufLen"]),
        # 
        'DnsRecordCopyEx': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DNS_CHARSET"), SimTypeInt(signed=False, label="DNS_CHARSET")], SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), arg_names=["pRecord", "CharSetIn", "CharSetOut"]),
        # 
        'DnsRecordSetCopyEx': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DNS_CHARSET"), SimTypeInt(signed=False, label="DNS_CHARSET")], SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), arg_names=["pRecordSet", "CharSetIn", "CharSetOut"]),
        # 
        'DnsRecordCompare': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRecord1", "pRecord2"]),
        # 
        'DnsRecordSetCompare': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRR1", "pRR2", "ppDiff1", "ppDiff2"]),
        # 
        'DnsRecordSetDetach': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), arg_names=["pRecordList"]),
        # 
        'DnsFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="DNS_FREE_TYPE")], SimTypeBottom(label="Void"), arg_names=["pData", "FreeType"]),
        # 
        'DnsQuery_A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "wType", "Options", "pExtra", "ppQueryResults", "pReserved"]),
        # 
        'DnsQuery_UTF8': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "wType", "Options", "pExtra", "ppQueryResults", "pReserved"]),
        # 
        'DnsQuery_W': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "wType", "Options", "pExtra", "ppQueryResults", "pReserved"]),
        # 
        'DnsQueryEx': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "QueryName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "QueryType": SimTypeShort(signed=False, label="UInt16"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "pDnsServerList": SimTypePointer(SimStruct({"MaxCount": SimTypeInt(signed=False, label="UInt32"), "AddrCount": SimTypeInt(signed=False, label="UInt32"), "Tag": SimTypeInt(signed=False, label="UInt32"), "Family": SimTypeShort(signed=False, label="UInt16"), "WordReserved": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeInt(signed=False, label="UInt32"), "MatchFlag": SimTypeInt(signed=False, label="UInt32"), "Reserved1": SimTypeInt(signed=False, label="UInt32"), "Reserved2": SimTypeInt(signed=False, label="UInt32"), "AddrArray": SimTypePointer(SimStruct({"MaxSa": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "Data": SimUnion({"DnsAddrUserDword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 8)}, name="<anon>", label="None")}, name="DNS_ADDR", pack=False, align=None), offset=0)}, name="DNS_ADDR_ARRAY", pack=False, align=None), offset=0), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pQueryCompletionCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "QueryStatus": SimTypeInt(signed=True, label="Int32"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "pQueryRecords": SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), "Reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_QUERY_RESULT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pQueryContext", "pQueryResults"]), offset=0), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_QUERY_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "QueryStatus": SimTypeInt(signed=True, label="Int32"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "pQueryRecords": SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), "Reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_QUERY_RESULT", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Reserved": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="DNS_QUERY_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pQueryRequest", "pQueryResults", "pCancelHandle"]),
        # 
        'DnsCancelQuery': SimTypeFunction([SimTypePointer(SimStruct({"Reserved": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="DNS_QUERY_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancelHandle"]),
        # 
        'DnsAcquireContextHandle_W': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CredentialFlags", "Credentials", "pContext"]),
        # 
        'DnsAcquireContextHandle_A': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CredentialFlags", "Credentials", "pContext"]),
        # 
        'DnsReleaseContextHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hContext"]),
        # 
        'DnsModifyRecordsInSet_W': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAddRecords", "pDeleteRecords", "Options", "hCredentials", "pExtraList", "pReserved"]),
        # 
        'DnsModifyRecordsInSet_A': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAddRecords", "pDeleteRecords", "Options", "hCredentials", "pExtraList", "pReserved"]),
        # 
        'DnsModifyRecordsInSet_UTF8': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAddRecords", "pDeleteRecords", "Options", "hCredentials", "pExtraList", "pReserved"]),
        # 
        'DnsReplaceRecordSetW': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pReplaceSet", "Options", "hContext", "pExtraInfo", "pReserved"]),
        # 
        'DnsReplaceRecordSetA': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pReplaceSet", "Options", "hContext", "pExtraInfo", "pReserved"]),
        # 
        'DnsReplaceRecordSetUTF8': SimTypeFunction([SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pReplaceSet", "Options", "hContext", "pExtraInfo", "pReserved"]),
        # 
        'DnsValidateName_W': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DNS_NAME_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "Format"]),
        # 
        'DnsValidateName_A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="DNS_NAME_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "Format"]),
        # 
        'DnsValidateName_UTF8': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="DNS_NAME_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "Format"]),
        # 
        'DnsNameCompare_A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName1", "pName2"]),
        # 
        'DnsNameCompare_W': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName1", "pName2"]),
        # 
        'DnsWriteQuestionToBuffer_W': SimTypeFunction([SimTypePointer(SimStruct({"MessageHead": SimStruct({"Xid": SimTypeShort(signed=False, label="UInt16"), "_bitfield1": SimTypeChar(label="Byte"), "_bitfield2": SimTypeChar(label="Byte"), "QuestionCount": SimTypeShort(signed=False, label="UInt16"), "AnswerCount": SimTypeShort(signed=False, label="UInt16"), "NameServerCount": SimTypeShort(signed=False, label="UInt16"), "AdditionalCount": SimTypeShort(signed=False, label="UInt16")}, name="DNS_HEADER", pack=False, align=None), "MessageBody": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="DNS_MESSAGE_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDnsBuffer", "pdwBufferSize", "pszName", "wType", "Xid", "fRecursionDesired"]),
        # 
        'DnsWriteQuestionToBuffer_UTF8': SimTypeFunction([SimTypePointer(SimStruct({"MessageHead": SimStruct({"Xid": SimTypeShort(signed=False, label="UInt16"), "_bitfield1": SimTypeChar(label="Byte"), "_bitfield2": SimTypeChar(label="Byte"), "QuestionCount": SimTypeShort(signed=False, label="UInt16"), "AnswerCount": SimTypeShort(signed=False, label="UInt16"), "NameServerCount": SimTypeShort(signed=False, label="UInt16"), "AdditionalCount": SimTypeShort(signed=False, label="UInt16")}, name="DNS_HEADER", pack=False, align=None), "MessageBody": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="DNS_MESSAGE_BUFFER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDnsBuffer", "pdwBufferSize", "pszName", "wType", "Xid", "fRecursionDesired"]),
        # 
        'DnsExtractRecordsFromMessage_W': SimTypeFunction([SimTypePointer(SimStruct({"MessageHead": SimStruct({"Xid": SimTypeShort(signed=False, label="UInt16"), "_bitfield1": SimTypeChar(label="Byte"), "_bitfield2": SimTypeChar(label="Byte"), "QuestionCount": SimTypeShort(signed=False, label="UInt16"), "AnswerCount": SimTypeShort(signed=False, label="UInt16"), "NameServerCount": SimTypeShort(signed=False, label="UInt16"), "AdditionalCount": SimTypeShort(signed=False, label="UInt16")}, name="DNS_HEADER", pack=False, align=None), "MessageBody": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="DNS_MESSAGE_BUFFER", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDnsBuffer", "wMessageLength", "ppRecord"]),
        # 
        'DnsExtractRecordsFromMessage_UTF8': SimTypeFunction([SimTypePointer(SimStruct({"MessageHead": SimStruct({"Xid": SimTypeShort(signed=False, label="UInt16"), "_bitfield1": SimTypeChar(label="Byte"), "_bitfield2": SimTypeChar(label="Byte"), "QuestionCount": SimTypeShort(signed=False, label="UInt16"), "AnswerCount": SimTypeShort(signed=False, label="UInt16"), "NameServerCount": SimTypeShort(signed=False, label="UInt16"), "AdditionalCount": SimTypeShort(signed=False, label="UInt16")}, name="DNS_HEADER", pack=False, align=None), "MessageBody": SimTypePointer(SimTypeBottom(label="CHAR"), offset=0)}, name="DNS_MESSAGE_BUFFER", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDnsBuffer", "wMessageLength", "ppRecord"]),
        # 
        'DnsGetProxyInformation': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "proxyInformationType": SimTypeInt(signed=False, label="DNS_PROXY_INFORMATION_TYPE"), "proxyName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_PROXY_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "proxyInformationType": SimTypeInt(signed=False, label="DNS_PROXY_INFORMATION_TYPE"), "proxyName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="DNS_PROXY_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["completionContext", "status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hostName", "proxyInformation", "defaultProxyInformation", "completionRoutine", "completionContext"]),
        # 
        'DnsFreeProxyName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["proxyName"]),
        # 
        'DnsConnectionGetProxyInfoForHostUrl': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ProxyInfo": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pwszConnectionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fDirectConfiguration": SimTypeInt(signed=True, label="Int32"), "hConnection": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="DNS_CONNECTION_PROXY_INFO_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszHostUrl", "pSelectionContext", "dwSelectionContextLength", "dwExplicitInterfaceIndex", "pProxyInfoEx"]),
        # 
        'DnsConnectionFreeProxyInfoEx': SimTypeFunction([SimTypePointer(SimStruct({"ProxyInfo": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pwszConnectionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fDirectConfiguration": SimTypeInt(signed=True, label="Int32"), "hConnection": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="DNS_CONNECTION_PROXY_INFO_EX", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pProxyInfoEx"]),
        # 
        'DnsConnectionGetProxyInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_TYPE"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszConnectionName", "Type", "pProxyInfo"]),
        # 
        'DnsConnectionFreeProxyInfo': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pProxyInfo"]),
        # 
        'DnsConnectionSetProxyInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_TYPE"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszConnectionName", "Type", "pProxyInfo"]),
        # 
        'DnsConnectionDeleteProxyInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszConnectionName", "Type"]),
        # 
        'DnsConnectionGetProxyList': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cProxies": SimTypeInt(signed=False, label="UInt32"), "pProxies": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_TYPE"), "Info": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None)}, name="DNS_CONNECTION_PROXY_ELEMENT", pack=False, align=None), offset=0)}, name="DNS_CONNECTION_PROXY_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszConnectionName", "pProxyList"]),
        # 
        'DnsConnectionFreeProxyList': SimTypeFunction([SimTypePointer(SimStruct({"cProxies": SimTypeInt(signed=False, label="UInt32"), "pProxies": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_TYPE"), "Info": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "pwszFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Switch": SimTypeInt(signed=False, label="DNS_CONNECTION_PROXY_INFO_SWITCH"), "Anonymous": SimUnion({"Config": SimStruct({"pwszServer": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszException": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Port": SimTypeShort(signed=False, label="UInt16")}, name="_DNS_CONNECTION_PROXY_INFO_CONFIG", pack=False, align=None), "Script": SimStruct({"pwszScript": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszUsername": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="_DNS_CONNECTION_PROXY_INFO_SCRIPT", pack=False, align=None)}, name="<anon>", label="None")}, name="DNS_CONNECTION_PROXY_INFO", pack=False, align=None)}, name="DNS_CONNECTION_PROXY_ELEMENT", pack=False, align=None), offset=0)}, name="DNS_CONNECTION_PROXY_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pProxyList"]),
        # 
        'DnsConnectionGetNameList': SimTypeFunction([SimTypePointer(SimStruct({"cNames": SimTypeInt(signed=False, label="UInt32"), "pNames": SimTypePointer(SimStruct({"wszName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65)}, name="DNS_CONNECTION_NAME", pack=False, align=None), offset=0)}, name="DNS_CONNECTION_NAME_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pNameList"]),
        # 
        'DnsConnectionFreeNameList': SimTypeFunction([SimTypePointer(SimStruct({"cNames": SimTypeInt(signed=False, label="UInt32"), "pNames": SimTypePointer(SimStruct({"wszName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65)}, name="DNS_CONNECTION_NAME", pack=False, align=None), offset=0)}, name="DNS_CONNECTION_NAME_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pNameList"]),
        # 
        'DnsConnectionUpdateIfIndexTable': SimTypeFunction([SimTypePointer(SimStruct({"pConnectionIfIndexEntries": SimTypePointer(SimStruct({"pwszConnectionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_CONNECTION_IFINDEX_ENTRY", pack=False, align=None), offset=0), "nEntries": SimTypeInt(signed=False, label="UInt32")}, name="DNS_CONNECTION_IFINDEX_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pConnectionIfIndexEntries"]),
        # 
        'DnsConnectionSetPolicyEntries': SimTypeFunction([SimTypeInt(signed=False, label="DNS_CONNECTION_POLICY_TAG"), SimTypePointer(SimStruct({"pPolicyEntries": SimTypePointer(SimStruct({"pwszHost": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszAppId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbAppSid": SimTypeInt(signed=False, label="UInt32"), "pbAppSid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nConnections": SimTypeInt(signed=False, label="UInt32"), "ppwszConnections": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwPolicyEntryFlags": SimTypeInt(signed=False, label="UInt32")}, name="DNS_CONNECTION_POLICY_ENTRY", pack=False, align=None), offset=0), "nEntries": SimTypeInt(signed=False, label="UInt32")}, name="DNS_CONNECTION_POLICY_ENTRY_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PolicyEntryTag", "pPolicyEntryList"]),
        # 
        'DnsConnectionDeletePolicyEntries': SimTypeFunction([SimTypeInt(signed=False, label="DNS_CONNECTION_POLICY_TAG")], SimTypeInt(signed=False, label="UInt32"), arg_names=["PolicyEntryTag"]),
        # 
        'DnsServiceConstructInstance': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimUnion({"IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0)], SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0), arg_names=["pServiceName", "pHostName", "pIp4", "pIp6", "wPort", "wPriority", "wWeight", "dwPropertiesCount", "keys", "values"]),
        # 
        'DnsServiceCopyInstance': SimTypeFunction([SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0), arg_names=["pOrig"]),
        # 
        'DnsServiceFreeInstance': SimTypeFunction([SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pInstance"]),
        # 
        'DnsServiceBrowse': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "QueryName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"pBrowseCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Status", "pQueryContext", "pDnsRecord"]), offset=0), "pBrowseCallbackV2": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "QueryStatus": SimTypeInt(signed=True, label="Int32"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "pQueryRecords": SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), "Reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_QUERY_RESULT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pQueryContext", "pQueryResults"]), offset=0)}, name="<anon>", label="None"), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_BROWSE_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRequest", "pCancel"]),
        # 
        'DnsServiceBrowseCancel': SimTypeFunction([SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancelHandle"]),
        # 
        'DnsServiceResolve': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "QueryName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pResolveCompletionCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Status", "pQueryContext", "pInstance"]), offset=0), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_RESOLVE_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRequest", "pCancel"]),
        # 
        'DnsServiceResolveCancel': SimTypeFunction([SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancelHandle"]),
        # 
        'DnsServiceRegister': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pServiceInstance": SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0), "pRegisterCompletionCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Status", "pQueryContext", "pInstance"]), offset=0), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCredentials": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "unicastEnabled": SimTypeInt(signed=True, label="Int32")}, name="DNS_SERVICE_REGISTER_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pRequest", "pCancel"]),
        # 
        'DnsServiceDeRegister': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pServiceInstance": SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0), "pRegisterCompletionCallback": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pszInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ip4Address": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ip6Address": SimTypePointer(SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None"), offset=0), "wPort": SimTypeShort(signed=False, label="UInt16"), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "dwPropertyCount": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "values": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "dwInterfaceIndex": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SERVICE_INSTANCE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Status", "pQueryContext", "pInstance"]), offset=0), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCredentials": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "unicastEnabled": SimTypeInt(signed=True, label="Int32")}, name="DNS_SERVICE_REGISTER_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pRequest", "pCancel"]),
        # 
        'DnsServiceRegisterCancel': SimTypeFunction([SimTypePointer(SimStruct({"reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_SERVICE_CANCEL", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCancelHandle"]),
        # 
        'DnsStartMulticastQuery': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ulRefCount": SimTypeInt(signed=False, label="UInt32"), "Query": SimTypePointer(SimTypeChar(label="Char"), offset=0), "QueryType": SimTypeShort(signed=False, label="UInt16"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "InterfaceIndex": SimTypeInt(signed=False, label="UInt32"), "pQueryCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"nameBuf": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "wType": SimTypeShort(signed=False, label="UInt16"), "pSubscription": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pWnfCallbackParams": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "stateNameData": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2)}, name="MDNS_QUERY_HANDLE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "QueryStatus": SimTypeInt(signed=True, label="Int32"), "QueryOptions": SimTypeLongLong(signed=False, label="UInt64"), "pQueryRecords": SimTypePointer(SimStruct({"pNext": SimTypePointer(SimTypeBottom(label="DNS_RECORDA"), offset=0), "pName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wType": SimTypeShort(signed=False, label="UInt16"), "wDataLength": SimTypeShort(signed=False, label="UInt16"), "Flags": SimUnion({"DW": SimTypeInt(signed=False, label="UInt32"), "S": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="DNS_RECORD_FLAGS", pack=False, align=None)}, name="<anon>", label="None"), "dwTtl": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "Data": SimUnion({"A": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32")}, name="DNS_A_DATA", pack=False, align=None), "SOA": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "Soa": SimStruct({"pNamePrimaryServer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameAdministrator": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSerialNo": SimTypeInt(signed=False, label="UInt32"), "dwRefresh": SimTypeInt(signed=False, label="UInt32"), "dwRetry": SimTypeInt(signed=False, label="UInt32"), "dwExpire": SimTypeInt(signed=False, label="UInt32"), "dwDefaultTtl": SimTypeInt(signed=False, label="UInt32")}, name="DNS_SOA_DATAA", pack=False, align=None), "PTR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ptr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "NS": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Ns": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "CNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Cname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "DNAME": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Dname": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MB": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mb": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MD": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Md": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MF": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mf": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MG": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mg": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MR": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "Mr": SimStruct({"pNameHost": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_PTR_DATAA", pack=False, align=None), "MINFO": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Minfo": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "RP": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "Rp": SimStruct({"pNameMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pNameErrorsMailbox": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_MINFO_DATAA", pack=False, align=None), "MX": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Mx": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "AFSDB": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Afsdb": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "RT": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "Rt": SimStruct({"pNameExchange": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPreference": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_MX_DATAA", pack=False, align=None), "HINFO": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Hinfo": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "ISDN": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Isdn": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "TXT": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Txt": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "X25": SimStruct({"dwStringCount": SimTypeInt(signed=False, label="UInt32"), "pStringArray": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="DNS_TXT_DATAA", pack=False, align=None), "Null": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NULL_DATA", pack=False, align=None), "WKS": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "Wks": SimStruct({"IpAddress": SimTypeInt(signed=False, label="UInt32"), "chProtocol": SimTypeChar(label="Byte"), "BitMask": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WKS_DATA", pack=False, align=None), "AAAA": SimStruct({"Ip6Address": SimUnion({"IP6Qword": SimTypeFixedSizeArray(SimTypeLongLong(signed=False, label="UInt64"), 2), "IP6Dword": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "IP6Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8), "IP6Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16)}, name="<anon>", label="None")}, name="DNS_AAAA_DATA", pack=False, align=None), "KEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Key": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "SIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Sig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "ATMA": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "Atma": SimStruct({"AddressType": SimTypeChar(label="Byte"), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 20)}, name="DNS_ATMA_DATA", pack=False, align=None), "NXT": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "Nxt": SimStruct({"pNameNext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wNumTypes": SimTypeShort(signed=False, label="UInt16"), "wTypes": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="DNS_NXT_DATAA", pack=False, align=None), "SRV": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "Srv": SimStruct({"pNameTarget": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wPriority": SimTypeShort(signed=False, label="UInt16"), "wWeight": SimTypeShort(signed=False, label="UInt16"), "wPort": SimTypeShort(signed=False, label="UInt16"), "Pad": SimTypeShort(signed=False, label="UInt16")}, name="DNS_SRV_DATAA", pack=False, align=None), "NAPTR": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "Naptr": SimStruct({"wOrder": SimTypeShort(signed=False, label="UInt16"), "wPreference": SimTypeShort(signed=False, label="UInt16"), "pFlags": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pService": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pRegularExpression": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pReplacement": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NAPTR_DATAA", pack=False, align=None), "OPT": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "Opt": SimStruct({"wDataLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_OPT_DATA", pack=False, align=None), "DS": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "Ds": SimStruct({"wKeyTag": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chDigestType": SimTypeChar(label="Byte"), "wDigestLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Digest": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DS_DATA", pack=False, align=None), "RRSIG": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "Rrsig": SimStruct({"wTypeCovered": SimTypeShort(signed=False, label="UInt16"), "chAlgorithm": SimTypeChar(label="Byte"), "chLabelCount": SimTypeChar(label="Byte"), "dwOriginalTtl": SimTypeInt(signed=False, label="UInt32"), "dwExpiration": SimTypeInt(signed=False, label="UInt32"), "dwTimeSigned": SimTypeInt(signed=False, label="UInt32"), "wKeyTag": SimTypeShort(signed=False, label="UInt16"), "wSignatureLength": SimTypeShort(signed=False, label="UInt16"), "pNameSigner": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Signature": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_SIG_DATAA", pack=False, align=None), "NSEC": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "Nsec": SimStruct({"pNextDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "TypeBitMaps": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC_DATAA", pack=False, align=None), "DNSKEY": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "Dnskey": SimStruct({"wFlags": SimTypeShort(signed=False, label="UInt16"), "chProtocol": SimTypeChar(label="Byte"), "chAlgorithm": SimTypeChar(label="Byte"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wPad": SimTypeShort(signed=False, label="UInt16"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_KEY_DATA", pack=False, align=None), "TKEY": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "Tkey": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pKey": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCreateTime": SimTypeInt(signed=False, label="UInt32"), "dwExpireTime": SimTypeInt(signed=False, label="UInt32"), "wMode": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wKeyLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TKEY_DATAA", pack=False, align=None), "TSIG": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "Tsig": SimStruct({"pNameAlgorithm": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pAlgorithmPacket": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pOtherData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "i64CreateTime": SimTypeLongLong(signed=True, label="Int64"), "wFudgeTime": SimTypeShort(signed=False, label="UInt16"), "wOriginalXid": SimTypeShort(signed=False, label="UInt16"), "wError": SimTypeShort(signed=False, label="UInt16"), "wSigLength": SimTypeShort(signed=False, label="UInt16"), "wOtherLength": SimTypeShort(signed=False, label="UInt16"), "cAlgNameLength": SimTypeChar(label="Byte"), "bPacketPointers": SimTypeInt(signed=True, label="Int32")}, name="DNS_TSIG_DATAA", pack=False, align=None), "WINS": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "Wins": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "cWinsServerCount": SimTypeInt(signed=False, label="UInt32"), "WinsServers": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="DNS_WINS_DATA", pack=False, align=None), "WINSR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "WinsR": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "NBSTAT": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "Nbstat": SimStruct({"dwMappingFlag": SimTypeInt(signed=False, label="UInt32"), "dwLookupTimeout": SimTypeInt(signed=False, label="UInt32"), "dwCacheTimeout": SimTypeInt(signed=False, label="UInt32"), "pNameResultDomain": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_WINSR_DATAA", pack=False, align=None), "DHCID": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "DHCID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_DHCID_DATA", pack=False, align=None), "NSEC3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "Nsec3": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bHashLength": SimTypeChar(label="Byte"), "wTypeBitMapsLength": SimTypeShort(signed=False, label="UInt16"), "chData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3_DATA", pack=False, align=None), "NSEC3PARAM": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "Nsec3Param": SimStruct({"chAlgorithm": SimTypeChar(label="Byte"), "bFlags": SimTypeChar(label="Byte"), "wIterations": SimTypeShort(signed=False, label="UInt16"), "bSaltLength": SimTypeChar(label="Byte"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "pbSalt": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_NSEC3PARAM_DATA", pack=False, align=None), "TLSA": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "Tlsa": SimStruct({"bCertUsage": SimTypeChar(label="Byte"), "bSelector": SimTypeChar(label="Byte"), "bMatchingType": SimTypeChar(label="Byte"), "bCertificateAssociationDataLength": SimTypeShort(signed=False, label="UInt16"), "bPad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "bCertificateAssociationData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_TLSA_DATA", pack=False, align=None), "UNKNOWN": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "Unknown": SimStruct({"dwByteCount": SimTypeInt(signed=False, label="UInt32"), "bData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DNS_UNKNOWN_DATA", pack=False, align=None), "pDataPtr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None")}, name="DNS_RECORDA", pack=False, align=None), offset=0), "Reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="DNS_QUERY_RESULT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pQueryContext", "pQueryHandle", "pQueryResults"]), offset=0), "pQueryContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fAnswerReceived": SimTypeInt(signed=True, label="Int32"), "ulResendCount": SimTypeInt(signed=False, label="UInt32")}, name="MDNS_QUERY_REQUEST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"nameBuf": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "wType": SimTypeShort(signed=False, label="UInt16"), "pSubscription": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pWnfCallbackParams": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "stateNameData": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2)}, name="MDNS_QUERY_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pQueryRequest", "pHandle"]),
        # 
        'DnsStopMulticastQuery': SimTypeFunction([SimTypePointer(SimStruct({"nameBuf": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "wType": SimTypeShort(signed=False, label="UInt16"), "pSubscription": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pWnfCallbackParams": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "stateNameData": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2)}, name="MDNS_QUERY_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pHandle"]),
    }

lib.set_prototypes(prototypes)
