# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("rpcrt4.dll")
prototypes = \
    {
        # 
        'IUnknown_QueryInterface_Proxy': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["This", "riid", "ppvObject"]),
        # 
        'IUnknown_AddRef_Proxy': SimTypeFunction([SimTypeBottom(label="IUnknown")], SimTypeInt(signed=False, label="UInt32"), arg_names=["This"]),
        # 
        'IUnknown_Release_Proxy': SimTypeFunction([SimTypeBottom(label="IUnknown")], SimTypeInt(signed=False, label="UInt32"), arg_names=["This"]),
        # 
        'RpcBindingCopy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["SourceBinding", "DestinationBinding"]),
        # 
        'RpcBindingFree': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'RpcBindingSetOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["hBinding", "option", "optionValue"]),
        # 
        'RpcBindingInqOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["hBinding", "option", "pOptionValue"]),
        # 
        'RpcBindingFromStringBindingA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringBinding", "Binding"]),
        # 
        'RpcBindingFromStringBindingW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringBinding", "Binding"]),
        # 
        'RpcSsGetContextBinding': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ContextHandle", "Binding"]),
        # 
        'RpcBindingInqObject': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ObjectUuid"]),
        # 
        'RpcBindingReset': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'RpcBindingSetObject': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ObjectUuid"]),
        # 
        'RpcMgmtInqDefaultProtectLevel': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["AuthnSvc", "AuthnLevel"]),
        # 
        'RpcBindingToStringBindingA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "StringBinding"]),
        # 
        'RpcBindingToStringBindingW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "StringBinding"]),
        # 
        'RpcBindingVectorFree': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingVector"]),
        # 
        'RpcStringBindingComposeA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ObjUuid", "ProtSeq", "NetworkAddr", "Endpoint", "Options", "StringBinding"]),
        # 
        'RpcStringBindingComposeW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ObjUuid", "ProtSeq", "NetworkAddr", "Endpoint", "Options", "StringBinding"]),
        # 
        'RpcStringBindingParseA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringBinding", "ObjUuid", "Protseq", "NetworkAddr", "Endpoint", "NetworkOptions"]),
        # 
        'RpcStringBindingParseW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringBinding", "ObjUuid", "Protseq", "NetworkAddr", "Endpoint", "NetworkOptions"]),
        # 
        'RpcStringFreeA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["String"]),
        # 
        'RpcStringFreeW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["String"]),
        # 
        'RpcIfInqId': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["RpcIfHandle", "RpcIfId"]),
        # 
        'RpcNetworkIsProtseqValidA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq"]),
        # 
        'RpcNetworkIsProtseqValidW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq"]),
        # 
        'RpcMgmtInqComTimeout': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Timeout"]),
        # 
        'RpcMgmtSetComTimeout': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Timeout"]),
        # 
        'RpcMgmtSetCancelTimeout': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Timeout"]),
        # 
        'RpcNetworkInqProtseqsA': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Protseq": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="RPC_PROTSEQ_VECTORA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ProtseqVector"]),
        # 
        'RpcNetworkInqProtseqsW': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Protseq": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)}, name="RPC_PROTSEQ_VECTORW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ProtseqVector"]),
        # 
        'RpcObjectInqType': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ObjUuid", "TypeUuid"]),
        # 
        'RpcObjectSetInqFn': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ObjectUuid", "TypeUuid", "Status"]), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InquiryFn"]),
        # 
        'RpcObjectSetType': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ObjUuid", "TypeUuid"]),
        # 
        'RpcProtseqVectorFreeA': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Protseq": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="RPC_PROTSEQ_VECTORA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ProtseqVector"]),
        # 
        'RpcProtseqVectorFreeW': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Protseq": SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)}, name="RPC_PROTSEQ_VECTORW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ProtseqVector"]),
        # 
        'RpcServerInqBindings': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingVector"]),
        # 
        'RpcServerInqBindingsEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["SecurityDescriptor", "BindingVector"]),
        # 
        'RpcServerInqIf': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "MgrEpv"]),
        # 
        'RpcServerListen': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["MinimumCallThreads", "MaxCalls", "DontWait"]),
        # 
        'RpcServerRegisterIf': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "MgrEpv"]),
        # 
        'RpcServerRegisterIfEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceUuid", "Context"]), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "MgrEpv", "Flags", "MaxCalls", "IfCallback"]),
        # 
        'RpcServerRegisterIf2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceUuid", "Context"]), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "MgrEpv", "Flags", "MaxCalls", "MaxRpcSize", "IfCallbackFn"]),
        # 
        'RpcServerRegisterIf3': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceUuid", "Context"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "MgrEpv", "Flags", "MaxCalls", "MaxRpcSize", "IfCallback", "SecurityDescriptor"]),
        # 
        'RpcServerUnregisterIf': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "WaitForCallsToComplete"]),
        # 
        'RpcServerUnregisterIfEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "MgrTypeUuid", "RundownContextHandles"]),
        # 
        'RpcServerUseAllProtseqs': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["MaxCalls", "SecurityDescriptor"]),
        # 
        'RpcServerUseAllProtseqsEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["MaxCalls", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseAllProtseqsIf': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["MaxCalls", "IfSpec", "SecurityDescriptor"]),
        # 
        'RpcServerUseAllProtseqsIfEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["MaxCalls", "IfSpec", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqExW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqEpA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqEpExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqEpW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqEpExW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqIfA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "IfSpec", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqIfExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "IfSpec", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerUseProtseqIfW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "IfSpec", "SecurityDescriptor"]),
        # 
        'RpcServerUseProtseqIfExW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "EndpointFlags": SimTypeInt(signed=False, label="UInt32"), "NICFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_POLICY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "MaxCalls", "IfSpec", "SecurityDescriptor", "Policy"]),
        # 
        'RpcServerYield': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'RpcMgmtStatsVectorFree': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Stats": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="RPC_STATS_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StatsVector"]),
        # 
        'RpcMgmtInqStats': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Stats": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="RPC_STATS_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Statistics"]),
        # 
        'RpcMgmtIsServerListening': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'RpcMgmtStopServerListening': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'RpcMgmtWaitServerListen': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'RpcMgmtSetServerStackSize': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ThreadStackSize"]),
        # 
        'RpcSsDontSerializeContext': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'RpcMgmtEnableIdleCleanup': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'RpcMgmtInqIfIds': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "IfId": SimTypePointer(SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0), offset=0)}, name="RPC_IF_ID_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "IfIdVector"]),
        # 
        'RpcMgmtInqServerPrincNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "AuthnSvc", "ServerPrincName"]),
        # 
        'RpcMgmtInqServerPrincNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "AuthnSvc", "ServerPrincName"]),
        # 
        'RpcServerInqDefaultPrincNameA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["AuthnSvc", "PrincName"]),
        # 
        'RpcServerInqDefaultPrincNameW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["AuthnSvc", "PrincName"]),
        # 
        'RpcEpResolveBinding': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "IfSpec"]),
        # 
        'RpcNsBindingInqEntryNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "EntryNameSyntax", "EntryName"]),
        # 
        'RpcNsBindingInqEntryNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "EntryNameSyntax", "EntryName"]),
        # 
        'RpcBindingCreateA': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ProtocolSequence": SimTypeInt(signed=False, label="UInt32"), "NetworkAddress": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "StringEndpoint": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "u1": SimUnion({"Reserved": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="<anon>", label="None"), "ObjectUuid": SimTypeBottom(label="Guid")}, name="RPC_BINDING_HANDLE_TEMPLATE_V1_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ServerPrincName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "AuthnLevel": SimTypeInt(signed=False, label="UInt32"), "AuthnSvc": SimTypeInt(signed=False, label="UInt32"), "AuthIdentity": SimTypePointer(SimStruct({"User": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UserLength": SimTypeInt(signed=False, label="UInt32"), "Domain": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "DomainLength": SimTypeInt(signed=False, label="UInt32"), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="SEC_WINNT_AUTH_IDENTITY")}, name="SEC_WINNT_AUTH_IDENTITY_A", pack=False, align=None), offset=0), "SecurityQos": SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)}, name="RPC_BINDING_HANDLE_SECURITY_V1_A", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="RPC_BINDING_HANDLE_OPTIONS_FLAGS"), "ComTimeout": SimTypeInt(signed=False, label="UInt32"), "CallTimeout": SimTypeInt(signed=False, label="UInt32")}, name="RPC_BINDING_HANDLE_OPTIONS_V1", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Template", "Security", "Options", "Binding"]),
        # 
        'RpcBindingCreateW': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "ProtocolSequence": SimTypeInt(signed=False, label="UInt32"), "NetworkAddress": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "StringEndpoint": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "u1": SimUnion({"Reserved": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="<anon>", label="None"), "ObjectUuid": SimTypeBottom(label="Guid")}, name="RPC_BINDING_HANDLE_TEMPLATE_V1_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ServerPrincName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "AuthnLevel": SimTypeInt(signed=False, label="UInt32"), "AuthnSvc": SimTypeInt(signed=False, label="UInt32"), "AuthIdentity": SimTypePointer(SimStruct({"User": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "UserLength": SimTypeInt(signed=False, label="UInt32"), "Domain": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "DomainLength": SimTypeInt(signed=False, label="UInt32"), "Password": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="SEC_WINNT_AUTH_IDENTITY")}, name="SEC_WINNT_AUTH_IDENTITY_W", pack=False, align=None), offset=0), "SecurityQos": SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)}, name="RPC_BINDING_HANDLE_SECURITY_V1_W", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="RPC_BINDING_HANDLE_OPTIONS_FLAGS"), "ComTimeout": SimTypeInt(signed=False, label="UInt32"), "CallTimeout": SimTypeInt(signed=False, label="UInt32")}, name="RPC_BINDING_HANDLE_OPTIONS_V1", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Template", "Security", "Options", "Binding"]),
        # 
        'RpcServerInqBindingHandle': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'RpcImpersonateClient': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle"]),
        # 
        'RpcImpersonateClient2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle"]),
        # 
        'RpcRevertToSelfEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle"]),
        # 
        'RpcRevertToSelf': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'RpcImpersonateClientContainer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle"]),
        # 
        'RpcRevertContainerImpersonation': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'RpcBindingInqAuthClientA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "Privs", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthzSvc"]),
        # 
        'RpcBindingInqAuthClientW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "Privs", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthzSvc"]),
        # 
        'RpcBindingInqAuthClientExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "Privs", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthzSvc", "Flags"]),
        # 
        'RpcBindingInqAuthClientExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "Privs", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthzSvc", "Flags"]),
        # 
        'RpcBindingInqAuthInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc"]),
        # 
        'RpcBindingInqAuthInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc"]),
        # 
        'RpcBindingSetAuthInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc"]),
        # 
        'RpcBindingSetAuthInfoExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc", "SecurityQos"]),
        # 
        'RpcBindingSetAuthInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc"]),
        # 
        'RpcBindingSetAuthInfoExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc", "SecurityQOS"]),
        # 
        'RpcBindingInqAuthInfoExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc", "RpcQosVersion", "SecurityQOS"]),
        # 
        'RpcBindingInqAuthInfoExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="RPC_C_QOS_CAPABILITIES"), "IdentityTracking": SimTypeInt(signed=False, label="RPC_C_QOS_IDENTITY"), "ImpersonationType": SimTypeInt(signed=False, label="RPC_C_IMP_LEVEL")}, name="RPC_SECURITY_QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerPrincName", "AuthnLevel", "AuthnSvc", "AuthIdentity", "AuthzSvc", "RpcQosVersion", "SecurityQOS"]),
        # 
        'RpcServerCompleteSecurityCallback': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_STATUS")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle", "Status"]),
        # 
        'RpcServerRegisterAuthInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "ServerPrincName", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ServerPrincName", "AuthnSvc", "GetKeyFn", "Arg"]),
        # 
        'RpcServerRegisterAuthInfoW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Arg", "ServerPrincName", "KeyVer", "Key", "Status"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ServerPrincName", "AuthnSvc", "GetKeyFn", "Arg"]),
        # 
        'RpcBindingServerFromClient': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "ServerBinding"]),
        # 
        'RpcRaiseException': SimTypeFunction([SimTypeInt(signed=False, label="RPC_STATUS")], SimTypeBottom(label="Void"), arg_names=["exception"]),
        # 
        'RpcTestCancel': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'RpcServerTestCancel': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle"]),
        # 
        'RpcCancelThread': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Thread"]),
        # 
        'RpcCancelThreadEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Thread", "Timeout"]),
        # 
        'UuidCreate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Uuid"]),
        # 
        'UuidCreateSequential': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Uuid"]),
        # 
        'UuidToStringA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Uuid", "StringUuid"]),
        # 
        'UuidFromStringA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringUuid", "Uuid"]),
        # 
        'UuidToStringW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Uuid", "StringUuid"]),
        # 
        'UuidFromStringW': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["StringUuid", "Uuid"]),
        # 
        'UuidCompare': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Uuid1", "Uuid2", "Status"]),
        # 
        'UuidCreateNil': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["NilUuid"]),
        # 
        'UuidEqual': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Uuid1", "Uuid2", "Status"]),
        # 
        'UuidHash': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeShort(signed=False, label="UInt16"), arg_names=["Uuid", "Status"]),
        # 
        'UuidIsNil': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Uuid", "Status"]),
        # 
        'RpcEpRegisterNoReplaceA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "BindingVector", "UuidVector", "Annotation"]),
        # 
        'RpcEpRegisterNoReplaceW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "BindingVector", "UuidVector", "Annotation"]),
        # 
        'RpcEpRegisterA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "BindingVector", "UuidVector", "Annotation"]),
        # 
        'RpcEpRegisterW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "BindingVector", "UuidVector", "Annotation"]),
        # 
        'RpcEpUnregister': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfSpec", "BindingVector", "UuidVector"]),
        # 
        'DceErrorInqTextA': SimTypeFunction([SimTypeInt(signed=False, label="RPC_STATUS"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["RpcStatus", "ErrorText"]),
        # 
        'DceErrorInqTextW': SimTypeFunction([SimTypeInt(signed=False, label="RPC_STATUS"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["RpcStatus", "ErrorText"]),
        # 
        'RpcMgmtEpEltInqBegin': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EpBinding", "InquiryType", "IfId", "VersOption", "ObjectUuid", "InquiryContext"]),
        # 
        'RpcMgmtEpEltInqDone': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InquiryContext"]),
        # 
        'RpcMgmtEpEltInqNextA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InquiryContext", "IfId", "Binding", "ObjectUuid", "Annotation"]),
        # 
        'RpcMgmtEpEltInqNextW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InquiryContext", "IfId", "Binding", "ObjectUuid", "Annotation"]),
        # 
        'RpcMgmtEpUnregister': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_IF_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EpBinding", "IfId", "Binding", "ObjectUuid"]),
        # 
        'RpcMgmtSetAuthorizationFn': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="RPC_STATUS"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ClientBinding", "RequestedMgmtOperation", "Status"]), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["AuthorizationFn"]),
        # 
        'RpcExceptionFilter': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ExceptionCode"]),
        # 
        'RpcServerInterfaceGroupCreateW': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "IfSpec": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MgrTypeUuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "MgrEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxCalls": SimTypeInt(signed=False, label="UInt32"), "MaxRpcSize": SimTypeInt(signed=False, label="UInt32"), "IfCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceUuid", "Context"]), offset=0), "UuidVector": SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), "Annotation": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_INTERFACE_TEMPLATEW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ProtSeq": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Endpoint": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Backlog": SimTypeInt(signed=False, label="UInt32")}, name="RPC_ENDPOINT_TEMPLATEW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["IfGroup", "IdleCallbackContext", "IsGroupIdle"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Interfaces", "NumIfs", "Endpoints", "NumEndpoints", "IdlePeriod", "IdleCallbackFn", "IdleCallbackContext", "IfGroup"]),
        # 
        'RpcServerInterfaceGroupCreateA': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "IfSpec": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "MgrTypeUuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "MgrEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "MaxCalls": SimTypeInt(signed=False, label="UInt32"), "MaxRpcSize": SimTypeInt(signed=False, label="UInt32"), "IfCallback": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceUuid", "Context"]), offset=0), "UuidVector": SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Uuid": SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)}, name="UUID_VECTOR", pack=False, align=None), offset=0), "Annotation": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_INTERFACE_TEMPLATEA", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ProtSeq": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Endpoint": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Backlog": SimTypeInt(signed=False, label="UInt32")}, name="RPC_ENDPOINT_TEMPLATEA", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["IfGroup", "IdleCallbackContext", "IsGroupIdle"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Interfaces", "NumIfs", "Endpoints", "NumEndpoints", "IdlePeriod", "IdleCallbackFn", "IdleCallbackContext", "IfGroup"]),
        # 
        'RpcServerInterfaceGroupClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfGroup"]),
        # 
        'RpcServerInterfaceGroupActivate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfGroup"]),
        # 
        'RpcServerInterfaceGroupDeactivate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfGroup", "ForceDeactivation"]),
        # 
        'RpcServerInterfaceGroupInqBindings': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "BindingH": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)}, name="RPC_BINDING_VECTOR", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["IfGroup", "BindingVector"]),
        # 
        'I_RpcNegotiateTransferSyntax': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcGetBuffer': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcGetBufferWithObject': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message", "ObjectUuid"]),
        # 
        'I_RpcSendReceive': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcFreeBuffer': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcSend': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcReceive': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message", "Size"]),
        # 
        'I_RpcFreePipeBuffer': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message"]),
        # 
        'I_RpcReallocPipeBuffer': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message", "NewSize"]),
        # 
        'I_RpcRequestMutex': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["Mutex"]),
        # 
        'I_RpcClearMutex': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Mutex"]),
        # 
        'I_RpcDeleteMutex': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Mutex"]),
        # 
        'I_RpcAllocate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["Size"]),
        # 
        'I_RpcFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Object"]),
        # 
        'I_RpcPauseExecution': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["Milliseconds"]),
        # 
        'I_RpcGetExtendedError': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'I_RpcSystemHandleTypeSpecificWork': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeChar(label="Byte"), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="LRPC_SYSTEM_HANDLE_MARSHAL_DIRECTION")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Handle", "ActualType", "IdlType", "MarshalDirection"]),
        # 
        'I_RpcGetCurrentCallHandle': SimTypeFunction([], SimTypePointer(SimTypeBottom(label="Void"), offset=0)),
        # 
        'I_RpcNsInterfaceExported': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "InterfaceId": SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), "TransferSyntax": SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), "DispatchTable": SimTypePointer(SimStruct({"DispatchTableCount": SimTypeInt(signed=False, label="UInt32"), "DispatchTable": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Message"]), offset=0), "Reserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RPC_DISPATCH_TABLE", pack=False, align=None), offset=0), "RpcProtseqEndpointCount": SimTypeInt(signed=False, label="UInt32"), "RpcProtseqEndpoint": SimTypePointer(SimStruct({"RpcProtocolSequence": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Endpoint": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RPC_PROTSEQ_ENDPOINT", pack=False, align=None), offset=0), "DefaultManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "InterpreterInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_SERVER_INTERFACE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EntryNameSyntax", "EntryName", "RpcInterfaceInformation"]),
        # 
        'I_RpcNsInterfaceUnexported': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "InterfaceId": SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), "TransferSyntax": SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), "DispatchTable": SimTypePointer(SimStruct({"DispatchTableCount": SimTypeInt(signed=False, label="UInt32"), "DispatchTable": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["Message"]), offset=0), "Reserved": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RPC_DISPATCH_TABLE", pack=False, align=None), offset=0), "RpcProtseqEndpointCount": SimTypeInt(signed=False, label="UInt32"), "RpcProtseqEndpoint": SimTypePointer(SimStruct({"RpcProtocolSequence": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Endpoint": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RPC_PROTSEQ_ENDPOINT", pack=False, align=None), offset=0), "DefaultManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "InterpreterInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_SERVER_INTERFACE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EntryNameSyntax", "EntryName", "RpcInterfaceInformation"]),
        # 
        'I_RpcBindingToStaticStringBindingW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "StringBinding"]),
        # 
        'I_RpcBindingInqSecurityContext': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "SecurityContextHandle"]),
        # 
        'I_RpcBindingInqSecurityContextKeyInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "KeyInfo"]),
        # 
        'I_RpcBindingInqWireIdForSnego': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "WireId"]),
        # 
        'I_RpcBindingInqMarshalledTargetInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "MarshalledTargetInfoSize", "MarshalledTargetInfo"]),
        # 
        'I_RpcBindingInqLocalClientPID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Pid"]),
        # 
        'I_RpcBindingHandleToAsyncHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "AsyncHandle"]),
        # 
        'I_RpcNsBindingSetEntryNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "EntryNameSyntax", "EntryName"]),
        # 
        'I_RpcNsBindingSetEntryNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "EntryNameSyntax", "EntryName"]),
        # 
        'I_RpcServerUseProtseqEp2A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["NetworkAddress", "Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor", "Policy"]),
        # 
        'I_RpcServerUseProtseqEp2W': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["NetworkAddress", "Protseq", "MaxCalls", "Endpoint", "SecurityDescriptor", "Policy"]),
        # 
        'I_RpcServerUseProtseq2W': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["NetworkAddress", "Protseq", "MaxCalls", "SecurityDescriptor", "Policy"]),
        # 
        'I_RpcServerUseProtseq2A': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["NetworkAddress", "Protseq", "MaxCalls", "SecurityDescriptor", "Policy"]),
        # 
        'I_RpcServerStartService': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Protseq", "Endpoint", "IfSpec"]),
        # 
        'I_RpcBindingInqDynamicEndpointW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "DynamicEndpoint"]),
        # 
        'I_RpcBindingInqDynamicEndpointA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "DynamicEndpoint"]),
        # 
        'I_RpcServerCheckClientRestriction': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Context"]),
        # 
        'I_RpcBindingInqTransportType': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Type"]),
        # 
        'I_RpcIfInqTransferSyntaxes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Uuid": SimTypeBottom(label="Guid"), "VersMajor": SimTypeShort(signed=False, label="UInt16"), "VersMinor": SimTypeShort(signed=False, label="UInt16")}, name="RPC_TRANSFER_SYNTAX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["RpcIfHandle", "TransferSyntaxes", "TransferSyntaxSize", "TransferSyntaxCount"]),
        # 
        'I_UuidCreate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Uuid"]),
        # 
        'I_RpcBindingCopy': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["SourceBinding", "DestinationBinding"]),
        # 
        'I_RpcBindingIsClientLocal': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["BindingHandle", "ClientLocalFlag"]),
        # 
        'I_RpcBindingCreateNP': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ServerName", "ServiceName", "NetworkOptions", "Binding"]),
        # 
        'I_RpcSsDontSerializeContext': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'I_RpcServerRegisterForwardFunction': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["InterfaceId", "InterfaceVersion", "ObjectId", "Rpcpro", "ppDestEndpoint"]), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pForwardFunction"]),
        # 
        'I_RpcServerInqAddressChangeFn': SimTypeFunction([], SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["arg"]), offset=0), offset=0)),
        # 
        'I_RpcServerSetAddressChangeFn': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["arg"]), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAddressChangeFn"]),
        # 
        'I_RpcServerInqLocalConnAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Buffer", "BufferSize", "AddressFormat"]),
        # 
        'I_RpcServerInqRemoteConnAddress': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Buffer", "BufferSize", "AddressFormat"]),
        # 
        'I_RpcSessionStrictContextHandle': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'I_RpcTurnOnEEInfoPropagation': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'I_RpcServerInqTransportType': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Type"]),
        # 
        'I_RpcMapWin32Status': SimTypeFunction([SimTypeInt(signed=False, label="RPC_STATUS")], SimTypeInt(signed=True, label="Int32"), arg_names=["Status"]),
        # 
        'I_RpcRecordCalloutFailure': SimTypeFunction([SimTypeInt(signed=False, label="RPC_STATUS"), SimTypePointer(SimStruct({"LastError": SimTypeInt(signed=False, label="RPC_STATUS"), "LastEEInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LastCalledStage": SimTypeInt(signed=False, label="RPC_HTTP_REDIRECTOR_STAGE"), "ServerName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ServerPort": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "RemoteUser": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "AuthType": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ResourceTypePresent": SimTypeChar(label="Byte"), "SessionIdPresent": SimTypeChar(label="Byte"), "InterfacePresent": SimTypeChar(label="Byte"), "ResourceType": SimTypeBottom(label="Guid"), "SessionId": SimTypeBottom(label="Guid"), "Interface": SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), "CertContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RDR_CALLOUT_STATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeBottom(label="Void"), arg_names=["RpcStatus", "CallOutState", "DllName"]),
        # 
        'I_RpcMgmtEnableDedicatedThreadPool': SimTypeFunction([], SimTypeInt(signed=False, label="RPC_STATUS")),
        # 
        'I_RpcGetDefaultSD': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ppSecurityDescriptor"]),
        # 
        'I_RpcOpenClientProcess': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "DesiredAccess", "ClientProcess"]),
        # 
        'I_RpcBindingIsServerLocal': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "ServerLocalFlag"]),
        # 
        'I_RpcBindingSetPrivateOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["hBinding", "option", "optionValue"]),
        # 
        'I_RpcServerSubscribeForDisconnectNotification': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "hEvent"]),
        # 
        'I_RpcServerGetAssociationID': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "AssociationID"]),
        # 
        'I_RpcServerDisableExceptionFilter': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'I_RpcServerSubscribeForDisconnectNotification2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "hEvent", "SubscriptionId"]),
        # 
        'I_RpcServerUnsubscribeForDisconnectNotification': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="Guid")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "SubscriptionId"]),
        # 
        'RpcAsyncRegisterInfo': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync"]),
        # 
        'RpcAsyncInitializeHandle': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "Size"]),
        # 
        'RpcAsyncGetCallStatus': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync"]),
        # 
        'RpcAsyncCompleteCall': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "Reply"]),
        # 
        'RpcAsyncAbortCall': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "ExceptionCode"]),
        # 
        'RpcAsyncCancelCall': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "fAbort"]),
        # 
        'RpcErrorStartEnumeration': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle"]),
        # 
        'RpcErrorGetNextRecord': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ComputerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProcessID": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"SystemTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "FileTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="<anon>", label="None"), "GeneratingComponent": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "DetectionLocation": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "NumberOfParameters": SimTypeInt(signed=True, label="Int32"), "Parameters": SimTypeFixedSizeArray(SimStruct({"ParameterType": SimTypeInt(signed=False, label="ExtendedErrorParamTypes"), "u": SimUnion({"AnsiString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UnicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LVal": SimTypeInt(signed=True, label="Int32"), "SVal": SimTypeShort(signed=True, label="Int16"), "PVal": SimTypeLongLong(signed=False, label="UInt64"), "BVal": SimStruct({"Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeShort(signed=True, label="Int16")}, name="BinaryParam", pack=False, align=None)}, name="<anon>", label="None")}, name="RPC_EE_INFO_PARAM", pack=False, align=None), 4)}, name="RPC_EXTENDED_ERROR_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle", "CopyStrings", "ErrorInfo"]),
        # 
        'RpcErrorEndEnumeration': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle"]),
        # 
        'RpcErrorResetEnumeration': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle"]),
        # 
        'RpcErrorGetNumberOfRecords': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle", "Records"]),
        # 
        'RpcErrorSaveErrorInfo': SimTypeFunction([SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["EnumHandle", "ErrorBlob", "BlobSize"]),
        # 
        'RpcErrorLoadErrorInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"Signature": SimTypeInt(signed=False, label="UInt32"), "CurrentPos": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="RPC_ERROR_ENUM_HANDLE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ErrorBlob", "BlobSize", "EnumHandle"]),
        # 
        'RpcErrorAddRecord': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "ComputerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProcessID": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"SystemTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "FileTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="<anon>", label="None"), "GeneratingComponent": SimTypeInt(signed=False, label="UInt32"), "Status": SimTypeInt(signed=False, label="UInt32"), "DetectionLocation": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "NumberOfParameters": SimTypeInt(signed=True, label="Int32"), "Parameters": SimTypeFixedSizeArray(SimStruct({"ParameterType": SimTypeInt(signed=False, label="ExtendedErrorParamTypes"), "u": SimUnion({"AnsiString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "UnicodeString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "LVal": SimTypeInt(signed=True, label="Int32"), "SVal": SimTypeShort(signed=True, label="Int16"), "PVal": SimTypeLongLong(signed=False, label="UInt64"), "BVal": SimStruct({"Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeShort(signed=True, label="Int16")}, name="BinaryParam", pack=False, align=None)}, name="<anon>", label="None")}, name="RPC_EE_INFO_PARAM", pack=False, align=None), 4)}, name="RPC_EXTENDED_ERROR_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ErrorInfo"]),
        # 
        'RpcErrorClearInformation': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'RpcGetAuthorizationContextForClient': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "ImpersonateOnReturn", "Reserved1", "pExpirationTime", "Reserved2", "Reserved3", "Reserved4", "pAuthzClientContext"]),
        # 
        'RpcFreeAuthorizationContext': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAuthzClientContext"]),
        # 
        'RpcSsContextLockExclusive': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ServerBindingHandle", "UserContext"]),
        # 
        'RpcSsContextLockShared': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ServerBindingHandle", "UserContext"]),
        # 
        'RpcServerInqCallAttributesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "RpcCallAttributes"]),
        # 
        'RpcServerInqCallAttributesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["ClientBinding", "RpcCallAttributes"]),
        # 
        'RpcServerSubscribeForNotification': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_NOTIFICATIONS"), SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), SimTypePointer(SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Notification", "NotificationType", "NotificationInfo"]),
        # 
        'RpcServerUnsubscribeForNotification': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_NOTIFICATIONS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "Notification", "NotificationsQueued"]),
        # 
        'RpcBindingBind': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "Binding", "IfSpec"]),
        # 
        'RpcBindingUnbind': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding"]),
        # 
        'I_RpcAsyncSetHandle': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Message", "pAsync"]),
        # 
        'I_RpcAsyncAbortCall': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Signature": SimTypeInt(signed=False, label="UInt32"), "Lock": SimTypeInt(signed=True, label="Int32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "StubInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RuntimeInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Event": SimTypeInt(signed=False, label="RPC_ASYNC_EVENT"), "NotificationType": SimTypeInt(signed=False, label="RPC_NOTIFICATION_TYPES"), "u": SimUnion({"APC": SimStruct({"NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="_APC_e__Struct", pack=False, align=None), "IOC": SimStruct({"hIOPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwNumberOfBytesTransferred": SimTypeInt(signed=False, label="UInt32"), "dwCompletionKey": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_IOC_e__Struct", pack=False, align=None), "IntPtr": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Msg": SimTypeInt(signed=False, label="UInt32")}, name="_IntPtr_e__Struct", pack=False, align=None), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "NotificationRoutine": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="RPC_ASYNC_STATE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="RPC_ASYNC_EVENT")], SimTypeBottom(label="Void"), arg_names=["pAsync", "Context", "Event"]), offset=0)}, name="<anon>", label="None"), "Reserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), 4)}, name="RPC_ASYNC_STATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["pAsync", "ExceptionCode"]),
        # 
        'I_RpcExceptionFilter': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ExceptionCode"]),
        # 
        'I_RpcBindingInqClientTokenAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="RPC_STATUS"), arg_names=["Binding", "TokenId", "AuthenticationId", "ModifiedId"]),
        # 
        'NDRCContextBinding': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["CContext"]),
        # 
        'NDRCContextMarshall': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["CContext", "pBuff"]),
        # 
        'NDRCContextUnmarshall': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pCContext", "hBinding", "pBuff", "DataRepresentation"]),
        # 
        'NDRSContextMarshall': SimTypeFunction([SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0)], SimTypeBottom(label="Void"), arg_names=["CContext", "pBuff", "userRunDownIn"]),
        # 
        'NDRSContextUnmarshall': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["pBuff", "DataRepresentation"]),
        # 
        'NDRSContextMarshallEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0)], SimTypeBottom(label="Void"), arg_names=["BindingHandle", "CContext", "pBuff", "userRunDownIn"]),
        # 
        'NDRSContextMarshall2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["BindingHandle", "CContext", "pBuff", "userRunDownIn", "CtxGuard", "Flags"]),
        # 
        'NDRSContextUnmarshallEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["BindingHandle", "pBuff", "DataRepresentation"]),
        # 
        'NDRSContextUnmarshall2': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["BindingHandle", "pBuff", "DataRepresentation", "CtxGuard", "Flags"]),
        # 
        'RpcSsDestroyClientContext': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["ContextHandle"]),
        # 
        'NdrSimpleTypeMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "FormatChar"]),
        # 
        'NdrPointerMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrSimpleStructMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantStructMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingStructMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexStructMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrFixedArrayMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantArrayMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingArrayMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrVaryingArrayMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexArrayMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrNonConformantStringMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantStringMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrEncapsulatedUnionMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrNonEncapsulatedUnionMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrByteCountPointerMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrXmitOrRepAsMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrUserMarshalMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrInterfacePointerMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrClientContextMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "ContextHandle", "fCheck"]),
        # 
        'NdrServerContextMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "ContextHandle", "RundownRoutine"]),
        # 
        'NdrServerContextNewMarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "ContextHandle", "RundownRoutine", "pFormat"]),
        # 
        'NdrSimpleTypeUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "FormatChar"]),
        # 
        'NdrRangeUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrCorrelationInitialize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "CacheSize", "flags"]),
        # 
        'NdrCorrelationPass': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg"]),
        # 
        'NdrCorrelationFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg"]),
        # 
        'NdrPointerUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrSimpleStructUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrConformantStructUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrConformantVaryingStructUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrComplexStructUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrFixedArrayUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrConformantArrayUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrConformantVaryingArrayUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrVaryingArrayUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrComplexArrayUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrNonConformantStringUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrConformantStringUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrEncapsulatedUnionUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrNonEncapsulatedUnionUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrByteCountPointerUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrXmitOrRepAsUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrUserMarshalUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrInterfacePointerUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pStubMsg", "ppMemory", "pFormat", "fMustAlloc"]),
        # 
        'NdrClientContextUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pContextHandle", "BindHandle"]),
        # 
        'NdrServerContextUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["pStubMsg"]),
        # 
        'NdrContextHandleInitialize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrServerContextNewUnmarshall': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrPointerBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrSimpleStructBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantStructBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingStructBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexStructBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrFixedArrayBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantArrayBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingArrayBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrVaryingArrayBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexArrayBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantStringBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrNonConformantStringBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrEncapsulatedUnionBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrNonEncapsulatedUnionBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrByteCountPointerBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrXmitOrRepAsBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrUserMarshalBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrInterfacePointerBufferSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrContextHandleSize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrPointerMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrSimpleStructMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrConformantStructMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrConformantVaryingStructMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrComplexStructMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrFixedArrayMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrConformantArrayMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrConformantVaryingArrayMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrVaryingArrayMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrComplexArrayMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrConformantStringMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrNonConformantStringMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrEncapsulatedUnionMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrNonEncapsulatedUnionMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrXmitOrRepAsMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrUserMarshalMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrInterfacePointerMemorySize': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrPointerFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrSimpleStructFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantStructFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingStructFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexStructFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrFixedArrayFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantArrayFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConformantVaryingArrayFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrVaryingArrayFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrComplexArrayFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrEncapsulatedUnionFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrNonEncapsulatedUnionFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrByteCountPointerFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrXmitOrRepAsFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrUserMarshalFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrInterfacePointerFree': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pMemory", "pFormat"]),
        # 
        'NdrConvert2': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pFormat", "NumberParams"]),
        # 
        'NdrConvert': SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pStubMsg", "pFormat"]),
        # 
        'NdrUserMarshalSimpleTypeConvert': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pFlags", "pBuffer", "FormatChar"]),
        # 
        'NdrClientInitializeNew': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "IMPLICIT_HANDLE_INFO": SimUnion({"pAutoHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pPrimitiveHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pGenericBindingInfo": SimTypePointer(SimStruct({"pObj": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_INFO", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "apfnNdrRundownRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), offset=0), "aGenericBindingRoutinePairs": SimTypePointer(SimStruct({"pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_ROUTINE_PAIR", pack=False, align=None), offset=0), "apfnExprEval": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="MIDL_STUB_MESSAGE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), offset=0), "aXmitQuintuple": SimTypePointer(SimStruct({"pfnTranslateToXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnTranslateFromXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeInst": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0)}, name="XMIT_ROUTINE_QUINTUPLE", pack=False, align=None), offset=0), "pFormatTypes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCheckBounds": SimTypeInt(signed=True, label="Int32"), "Version": SimTypeInt(signed=False, label="UInt32"), "pMallocFreeStruct": SimTypePointer(SimStruct({"pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MALLOC_FREE_STRUCT", pack=False, align=None), offset=0), "MIDLVersion": SimTypeInt(signed=True, label="Int32"), "CommFaultOffsets": SimTypePointer(SimStruct({"CommOffset": SimTypeShort(signed=True, label="Int16"), "FaultOffset": SimTypeShort(signed=True, label="Int16")}, name="COMM_FAULT_OFFSETS", pack=False, align=None), offset=0), "aUserMarshalQuadruple": SimTypePointer(SimStruct({"pfnBufferSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]), offset=0), "pfnMarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnUnmarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="USER_MARSHAL_ROUTINE_QUADRUPLE", pack=False, align=None), offset=0), "NotifyRoutineTable": SimTypePointer(SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0), offset=0), "mFlags": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "CsRoutineTables": SimTypePointer(SimStruct({"pSizeConvertRoutines": SimTypePointer(SimStruct({"pfnNetSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulLocalBufferSize", "conversionType", "pulNetworkBufferSize", "pStatus"]), offset=0), "pfnToNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pLocalData", "ulLocalDataLength", "pNetworkData", "pulNetworkDataLength", "pStatus"]), offset=0), "pfnLocalSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulNetworkBufferSize", "conversionType", "pulLocalBufferSize", "pStatus"]), offset=0), "pfnFromNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pNetworkData", "ulNetworkDataLength", "ulLocalBufferSize", "pLocalData", "pulLocalDataLength", "pStatus"]), offset=0)}, name="NDR_CS_SIZE_CONVERT_ROUTINES", pack=False, align=None), offset=0), "pTagGettingRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "fServerSide", "pulSendingTag", "pulDesiredReceivingTag", "pulReceivingTag", "pStatus"]), offset=0), offset=0)}, name="NDR_CS_ROUTINES", pack=False, align=None), offset=0), "ProxyServerInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pExprInfo": SimTypePointer(SimStruct({"pOffset": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pFormatExpr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="NDR_EXPR_DESC", pack=False, align=None), offset=0)}, name="MIDL_STUB_DESC", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pRpcMsg", "pStubMsg", "pStubDescriptor", "ProcNum"]),
        # 
        'NdrServerInitializeNew': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "IMPLICIT_HANDLE_INFO": SimUnion({"pAutoHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pPrimitiveHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pGenericBindingInfo": SimTypePointer(SimStruct({"pObj": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_INFO", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "apfnNdrRundownRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), offset=0), "aGenericBindingRoutinePairs": SimTypePointer(SimStruct({"pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_ROUTINE_PAIR", pack=False, align=None), offset=0), "apfnExprEval": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="MIDL_STUB_MESSAGE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), offset=0), "aXmitQuintuple": SimTypePointer(SimStruct({"pfnTranslateToXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnTranslateFromXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeInst": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0)}, name="XMIT_ROUTINE_QUINTUPLE", pack=False, align=None), offset=0), "pFormatTypes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCheckBounds": SimTypeInt(signed=True, label="Int32"), "Version": SimTypeInt(signed=False, label="UInt32"), "pMallocFreeStruct": SimTypePointer(SimStruct({"pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MALLOC_FREE_STRUCT", pack=False, align=None), offset=0), "MIDLVersion": SimTypeInt(signed=True, label="Int32"), "CommFaultOffsets": SimTypePointer(SimStruct({"CommOffset": SimTypeShort(signed=True, label="Int16"), "FaultOffset": SimTypeShort(signed=True, label="Int16")}, name="COMM_FAULT_OFFSETS", pack=False, align=None), offset=0), "aUserMarshalQuadruple": SimTypePointer(SimStruct({"pfnBufferSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]), offset=0), "pfnMarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnUnmarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="USER_MARSHAL_ROUTINE_QUADRUPLE", pack=False, align=None), offset=0), "NotifyRoutineTable": SimTypePointer(SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0), offset=0), "mFlags": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "CsRoutineTables": SimTypePointer(SimStruct({"pSizeConvertRoutines": SimTypePointer(SimStruct({"pfnNetSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulLocalBufferSize", "conversionType", "pulNetworkBufferSize", "pStatus"]), offset=0), "pfnToNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pLocalData", "ulLocalDataLength", "pNetworkData", "pulNetworkDataLength", "pStatus"]), offset=0), "pfnLocalSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulNetworkBufferSize", "conversionType", "pulLocalBufferSize", "pStatus"]), offset=0), "pfnFromNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pNetworkData", "ulNetworkDataLength", "ulLocalBufferSize", "pLocalData", "pulLocalDataLength", "pStatus"]), offset=0)}, name="NDR_CS_SIZE_CONVERT_ROUTINES", pack=False, align=None), offset=0), "pTagGettingRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "fServerSide", "pulSendingTag", "pulDesiredReceivingTag", "pulReceivingTag", "pStatus"]), offset=0), offset=0)}, name="NDR_CS_ROUTINES", pack=False, align=None), offset=0), "ProxyServerInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pExprInfo": SimTypePointer(SimStruct({"pOffset": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pFormatExpr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="NDR_EXPR_DESC", pack=False, align=None), offset=0)}, name="MIDL_STUB_DESC", pack=False, align=None), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["pRpcMsg", "pStubMsg", "pStubDescriptor"]),
        # 
        'NdrServerInitializePartial': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "IMPLICIT_HANDLE_INFO": SimUnion({"pAutoHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pPrimitiveHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pGenericBindingInfo": SimTypePointer(SimStruct({"pObj": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_INFO", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "apfnNdrRundownRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), offset=0), "aGenericBindingRoutinePairs": SimTypePointer(SimStruct({"pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_ROUTINE_PAIR", pack=False, align=None), offset=0), "apfnExprEval": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="MIDL_STUB_MESSAGE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), offset=0), "aXmitQuintuple": SimTypePointer(SimStruct({"pfnTranslateToXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnTranslateFromXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeInst": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0)}, name="XMIT_ROUTINE_QUINTUPLE", pack=False, align=None), offset=0), "pFormatTypes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCheckBounds": SimTypeInt(signed=True, label="Int32"), "Version": SimTypeInt(signed=False, label="UInt32"), "pMallocFreeStruct": SimTypePointer(SimStruct({"pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MALLOC_FREE_STRUCT", pack=False, align=None), offset=0), "MIDLVersion": SimTypeInt(signed=True, label="Int32"), "CommFaultOffsets": SimTypePointer(SimStruct({"CommOffset": SimTypeShort(signed=True, label="Int16"), "FaultOffset": SimTypeShort(signed=True, label="Int16")}, name="COMM_FAULT_OFFSETS", pack=False, align=None), offset=0), "aUserMarshalQuadruple": SimTypePointer(SimStruct({"pfnBufferSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]), offset=0), "pfnMarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnUnmarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="USER_MARSHAL_ROUTINE_QUADRUPLE", pack=False, align=None), offset=0), "NotifyRoutineTable": SimTypePointer(SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0), offset=0), "mFlags": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "CsRoutineTables": SimTypePointer(SimStruct({"pSizeConvertRoutines": SimTypePointer(SimStruct({"pfnNetSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulLocalBufferSize", "conversionType", "pulNetworkBufferSize", "pStatus"]), offset=0), "pfnToNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pLocalData", "ulLocalDataLength", "pNetworkData", "pulNetworkDataLength", "pStatus"]), offset=0), "pfnLocalSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulNetworkBufferSize", "conversionType", "pulLocalBufferSize", "pStatus"]), offset=0), "pfnFromNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pNetworkData", "ulNetworkDataLength", "ulLocalBufferSize", "pLocalData", "pulLocalDataLength", "pStatus"]), offset=0)}, name="NDR_CS_SIZE_CONVERT_ROUTINES", pack=False, align=None), offset=0), "pTagGettingRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "fServerSide", "pulSendingTag", "pulDesiredReceivingTag", "pulReceivingTag", "pStatus"]), offset=0), offset=0)}, name="NDR_CS_ROUTINES", pack=False, align=None), offset=0), "ProxyServerInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pExprInfo": SimTypePointer(SimStruct({"pOffset": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pFormatExpr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="NDR_EXPR_DESC", pack=False, align=None), offset=0)}, name="MIDL_STUB_DESC", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pRpcMsg", "pStubMsg", "pStubDescriptor", "RequestedBufferSize"]),
        # 
        'NdrClientInitialize': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "IMPLICIT_HANDLE_INFO": SimUnion({"pAutoHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pPrimitiveHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pGenericBindingInfo": SimTypePointer(SimStruct({"pObj": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_INFO", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "apfnNdrRundownRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), offset=0), "aGenericBindingRoutinePairs": SimTypePointer(SimStruct({"pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_ROUTINE_PAIR", pack=False, align=None), offset=0), "apfnExprEval": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="MIDL_STUB_MESSAGE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), offset=0), "aXmitQuintuple": SimTypePointer(SimStruct({"pfnTranslateToXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnTranslateFromXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeInst": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0)}, name="XMIT_ROUTINE_QUINTUPLE", pack=False, align=None), offset=0), "pFormatTypes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCheckBounds": SimTypeInt(signed=True, label="Int32"), "Version": SimTypeInt(signed=False, label="UInt32"), "pMallocFreeStruct": SimTypePointer(SimStruct({"pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MALLOC_FREE_STRUCT", pack=False, align=None), offset=0), "MIDLVersion": SimTypeInt(signed=True, label="Int32"), "CommFaultOffsets": SimTypePointer(SimStruct({"CommOffset": SimTypeShort(signed=True, label="Int16"), "FaultOffset": SimTypeShort(signed=True, label="Int16")}, name="COMM_FAULT_OFFSETS", pack=False, align=None), offset=0), "aUserMarshalQuadruple": SimTypePointer(SimStruct({"pfnBufferSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]), offset=0), "pfnMarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnUnmarshall": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["param0", "param1", "param2"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="USER_MARSHAL_ROUTINE_QUADRUPLE", pack=False, align=None), offset=0), "NotifyRoutineTable": SimTypePointer(SimTypePointer(SimTypeFunction([], SimTypeBottom(label="Void")), offset=0), offset=0), "mFlags": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "CsRoutineTables": SimTypePointer(SimStruct({"pSizeConvertRoutines": SimTypePointer(SimStruct({"pfnNetSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulLocalBufferSize", "conversionType", "pulNetworkBufferSize", "pStatus"]), offset=0), "pfnToNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pLocalData", "ulLocalDataLength", "pNetworkData", "pulNetworkDataLength", "pStatus"]), offset=0), "pfnLocalSize": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="IDL_CS_CONVERT"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "ulNetworkBufferSize", "conversionType", "pulLocalBufferSize", "pStatus"]), offset=0), "pfnFromNetCs": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "ulNetworkCodeSet", "pNetworkData", "ulNetworkDataLength", "ulLocalBufferSize", "pLocalData", "pulLocalDataLength", "pStatus"]), offset=0)}, name="NDR_CS_SIZE_CONVERT_ROUTINES", pack=False, align=None), offset=0), "pTagGettingRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hBinding", "fServerSide", "pulSendingTag", "pulDesiredReceivingTag", "pulReceivingTag", "pStatus"]), offset=0), offset=0)}, name="NDR_CS_ROUTINES", pack=False, align=None), offset=0), "ProxyServerInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pExprInfo": SimTypePointer(SimStruct({"pOffset": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pFormatExpr": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="NDR_EXPR_DESC", pack=False, align=None), offset=0)}, name="MIDL_STUB_DESC", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pRpcMsg", "pStubMsg", "pStubDescriptor", "ProcNum"]),
        # 
        'NdrServerInitialize': SimTypeFunction([SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "IMPLICIT_HANDLE_INFO": SimUnion({"pAutoHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pPrimitiveHandle": SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), "pGenericBindingInfo": SimTypePointer(SimStruct({"pObj": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32"), "pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_INFO", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "apfnNdrRundownRoutines": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["context"]), offset=0), offset=0), "aGenericBindingRoutinePairs": SimTypePointer(SimStruct({"pfnBind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["param0"]), offset=0), "pfnUnbind": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0)}, name="GENERIC_BINDING_ROUTINE_PAIR", pack=False, align=None), offset=0), "apfnExprEval": SimTypePointer(SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="MIDL_STUB_MESSAGE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), offset=0), "aXmitQuintuple": SimTypePointer(SimStruct({"pfnTranslateToXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnTranslateFromXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeXmit": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0), "pfnFreeInst": SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"RpcMsg": SimTypePointer(SimStruct({"Handle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "DataRepresentation": SimTypeInt(signed=False, label="UInt32"), "Buffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "ProcNum": SimTypeInt(signed=False, label="UInt32"), "TransferSyntax": SimTypePointer(SimStruct({"SyntaxGUID": SimTypeBottom(label="Guid"), "SyntaxVersion": SimStruct({"MajorVersion": SimTypeShort(signed=False, label="UInt16"), "MinorVersion": SimTypeShort(signed=False, label="UInt16")}, name="RPC_VERSION", pack=False, align=None)}, name="RPC_SYNTAX_IDENTIFIER", pack=False, align=None), offset=0), "RpcInterfaceInformation": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ReservedForRuntime": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ManagerEpv": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ImportContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "RpcFlags": SimTypeInt(signed=False, label="UInt32")}, name="RPC_MESSAGE", pack=False, align=None), offset=0), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferStart": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferEnd": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "BufferLength": SimTypeInt(signed=False, label="UInt32"), "MemorySize": SimTypeInt(signed=False, label="UInt32"), "Memory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "IsClient": SimTypeChar(label="Byte"), "Pad": SimTypeChar(label="Byte"), "uFlags2": SimTypeShort(signed=False, label="UInt16"), "ReuseBuffer": SimTypeInt(signed=True, label="Int32"), "pAllocAllNodesContext": SimTypePointer(SimStruct({}, name="NDR_ALLOC_ALL_NODES_CONTEXT", pack=False, align=None), offset=0), "pPointerQueueState": SimTypePointer(SimStruct({}, name="NDR_POINTER_QUEUE_STATE", pack=False, align=None), offset=0), "IgnoreEmbeddedPointers": SimTypeInt(signed=True, label="Int32"), "PointerBufferMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CorrDespIncrement": SimTypeChar(label="Byte"), "uFlags": SimTypeChar(label="Byte"), "UniquePtrCount": SimTypeShort(signed=False, label="UInt16"), "MaxCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Offset": SimTypeInt(signed=False, label="UInt32"), "ActualCount": SimTypeInt(signed=False, label="UInt32"), "pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "StackTop": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pPresentedType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pTransmitType": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SavedHandle": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "StubDesc": SimTypePointer(SimTypeBottom(label="MIDL_STUB_DESC"), offset=0), "FullPtrXlatTables": SimTypePointer(SimTypeBottom(label="FULL_PTR_XLAT_TABLES"), offset=0), "FullPtrRefId": SimTypeInt(signed=False, label="UInt32"), "PointerLength": SimTypeInt(signed=False, label="UInt32"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "dwDestContext": SimTypeInt(signed=False, label="UInt32"), "pvDestContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SavedContextHandles": SimTypePointer(SimTypePointer(SimStruct({"pad": SimTypeFixedSizeArray(SimTypePointer(SimTypeBottom(label="Void"), offset=0), 2), "userContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NDR_SCONTEXT_1", pack=False, align=None), offset=0), offset=0), "ParamNumber": SimTypeInt(signed=True, label="Int32"), "pRpcChannelBuffer": SimTypeBottom(label="IRpcChannelBuffer"), "pArrayInfo": SimTypePointer(SimStruct({"Dimension": SimTypeInt(signed=True, label="Int32"), "BufferConformanceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "BufferVarianceMark": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "MaxCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "OffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "ActualCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="ARRAY_INFO", pack=False, align=None), offset=0), "SizePtrCountArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrOffsetArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "SizePtrLengthArray": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pArgQueue": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwStubPhase": SimTypeInt(signed=False, label="UInt32"), "LowStackMark": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pAsyncMsg": SimTypePointer(SimStruct({}, name="_NDR_ASYNC_MESSAGE", pack=False, align=None), offset=0), "pCorrInfo": SimTypePointer(SimStruct({}, name="_NDR_CORRELATION_INFO", pack=False, align=None), offset=0), "pCorrMemory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pMemoryList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pCSInfo": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ConformanceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "VarianceMark": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Unused": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pContext": SimTypePointer(SimStruct({}, name="_NDR_PROC_CONTEXT", pack=False, align=None), offset=0), "ContextHandleHash": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pUserMarshalList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Reserved51_3": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_4": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Reserved51_5": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MIDL_STUB_MESSAGE", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0"]), offset=0)}, name="XMIT_ROUTINE_QUINTUPLE", pack=False, align=None), offset=0), "pFormatTypes": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCheckBounds": SimTypeInt(signed=True, label="Int32"), "Version": SimTypeInt(signed=False, label="UInt32"), "pMallocFreeStruct": SimTypePointer(SimStruct({"pfnAllocate": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnFree": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offs