# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wtsapi32.dll")
prototypes = \
    {
        # 
        'WTSStopRemoteControlSession': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId"]),
        # 
        'WTSStartRemoteControlSessionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetServerName", "TargetLogonId", "HotkeyVk", "HotkeyModifiers"]),
        # 
        'WTSStartRemoteControlSessionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["pTargetServerName", "TargetLogonId", "HotkeyVk", "HotkeyModifiers"]),
        # 
        'WTSConnectSessionA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "TargetLogonId", "pPassword", "bWait"]),
        # 
        'WTSConnectSessionW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["LogonId", "TargetLogonId", "pPassword", "bWait"]),
        # 
        'WTSEnumerateServersW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"pServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WTS_SERVER_INFOW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDomainName", "Reserved", "Version", "ppServerInfo", "pCount"]),
        # 
        'WTSEnumerateServersA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"pServerName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WTS_SERVER_INFOA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDomainName", "Reserved", "Version", "ppServerInfo", "pCount"]),
        # 
        'WTSOpenServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pServerName"]),
        # 
        'WTSOpenServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pServerName"]),
        # 
        'WTSOpenServerExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pServerName"]),
        # 
        'WTSOpenServerExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pServerName"]),
        # 
        'WTSCloseServer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hServer"]),
        # 
        'WTSEnumerateSessionsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SessionId": SimTypeInt(signed=False, label="UInt32"), "pWinStationName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "State": SimTypeInt(signed=False, label="WTS_CONNECTSTATE_CLASS")}, name="WTS_SESSION_INFOW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "Reserved", "Version", "ppSessionInfo", "pCount"]),
        # 
        'WTSEnumerateSessionsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SessionId": SimTypeInt(signed=False, label="UInt32"), "pWinStationName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "State": SimTypeInt(signed=False, label="WTS_CONNECTSTATE_CLASS")}, name="WTS_SESSION_INFOA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "Reserved", "Version", "ppSessionInfo", "pCount"]),
        # 
        'WTSEnumerateSessionsExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"ExecEnvId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="WTS_CONNECTSTATE_CLASS"), "SessionId": SimTypeInt(signed=False, label="UInt32"), "pSessionName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pUserName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDomainName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pFarmName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WTS_SESSION_INFO_1W", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pLevel", "Filter", "ppSessionInfo", "pCount"]),
        # 
        'WTSEnumerateSessionsExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"ExecEnvId": SimTypeInt(signed=False, label="UInt32"), "State": SimTypeInt(signed=False, label="WTS_CONNECTSTATE_CLASS"), "SessionId": SimTypeInt(signed=False, label="UInt32"), "pSessionName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pHostName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pUserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDomainName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pFarmName": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WTS_SESSION_INFO_1A", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pLevel", "Filter", "ppSessionInfo", "pCount"]),
        # 
        'WTSEnumerateProcessesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SessionId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "pProcessName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pUserSid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="WTS_PROCESS_INFOW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "Reserved", "Version", "ppProcessInfo", "pCount"]),
        # 
        'WTSEnumerateProcessesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"SessionId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "pProcessName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pUserSid": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="WTS_PROCESS_INFOA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "Reserved", "Version", "ppProcessInfo", "pCount"]),
        # 
        'WTSTerminateProcess': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "ProcessId", "ExitCode"]),
        # 
        'WTSQuerySessionInformationW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WTS_INFO_CLASS"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "WTSInfoClass", "ppBuffer", "pBytesReturned"]),
        # 
        'WTSQuerySessionInformationA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WTS_INFO_CLASS"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "WTSInfoClass", "ppBuffer", "pBytesReturned"]),
        # 
        'WTSQueryUserConfigW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="WTS_CONFIG_CLASS"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pServerName", "pUserName", "WTSConfigClass", "ppBuffer", "pBytesReturned"]),
        # 
        'WTSQueryUserConfigA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="WTS_CONFIG_CLASS"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pServerName", "pUserName", "WTSConfigClass", "ppBuffer", "pBytesReturned"]),
        # 
        'WTSSetUserConfigW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="WTS_CONFIG_CLASS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pServerName", "pUserName", "WTSConfigClass", "pBuffer", "DataLength"]),
        # 
        'WTSSetUserConfigA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="WTS_CONFIG_CLASS"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pServerName", "pUserName", "WTSConfigClass", "pBuffer", "DataLength"]),
        # 
        'WTSSendMessageW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="MESSAGEBOX_STYLE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="MESSAGEBOX_RESULT"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "pTitle", "TitleLength", "pMessage", "MessageLength", "Style", "Timeout", "pResponse", "bWait"]),
        # 
        'WTSSendMessageA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="MESSAGEBOX_STYLE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="MESSAGEBOX_RESULT"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "pTitle", "TitleLength", "pMessage", "MessageLength", "Style", "Timeout", "pResponse", "bWait"]),
        # 
        'WTSDisconnectSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "bWait"]),
        # 
        'WTSLogoffSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "SessionId", "bWait"]),
        # 
        'WTSShutdownSystem': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "ShutdownFlag"]),
        # 
        'WTSWaitSystemEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "EventMask", "pEventFlags"]),
        # 
        'WTSVirtualChannelOpen': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hServer", "SessionId", "pVirtualName"]),
        # 
        'WTSVirtualChannelOpenEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["SessionId", "pVirtualName", "flags"]),
        # 
        'WTSVirtualChannelClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle"]),
        # 
        'WTSVirtualChannelRead': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle", "TimeOut", "Buffer", "BufferSize", "pBytesRead"]),
        # 
        'WTSVirtualChannelWrite': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle", "Buffer", "Length", "pBytesWritten"]),
        # 
        'WTSVirtualChannelPurgeInput': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle"]),
        # 
        'WTSVirtualChannelPurgeOutput': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle"]),
        # 
        'WTSVirtualChannelQuery': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WTS_VIRTUAL_CLASS"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hChannelHandle", "param1", "ppBuffer", "pBytesReturned"]),
        # 
        'WTSFreeMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pMemory"]),
        # 
        'WTSRegisterSessionNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "dwFlags"]),
        # 
        'WTSUnRegisterSessionNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd"]),
        # 
        'WTSRegisterSessionNotificationEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "hWnd", "dwFlags"]),
        # 
        'WTSUnRegisterSessionNotificationEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "hWnd"]),
        # 
        'WTSQueryUserToken': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionId", "phToken"]),
        # 
        'WTSFreeMemoryExW': SimTypeFunction([SimTypeInt(signed=False, label="WTS_TYPE_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["WTSTypeClass", "pMemory", "NumberOfEntries"]),
        # 
        'WTSFreeMemoryExA': SimTypeFunction([SimTypeInt(signed=False, label="WTS_TYPE_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["WTSTypeClass", "pMemory", "NumberOfEntries"]),
        # 
        'WTSEnumerateProcessesExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pLevel", "SessionId", "ppProcessInfo", "pCount"]),
        # 
        'WTSEnumerateProcessesExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pLevel", "SessionId", "ppProcessInfo", "pCount"]),
        # 
        'WTSEnumerateListenersW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListeners", "pCount"]),
        # 
        'WTSEnumerateListenersA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListeners", "pCount"]),
        # 
        'WTSQueryListenerConfigW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "fEnableListener": SimTypeInt(signed=False, label="UInt32"), "MaxConnectionCount": SimTypeInt(signed=False, label="UInt32"), "fPromptForPassword": SimTypeInt(signed=False, label="UInt32"), "fInheritColorDepth": SimTypeInt(signed=False, label="UInt32"), "ColorDepth": SimTypeInt(signed=False, label="UInt32"), "fInheritBrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "BrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "fDisablePrinterRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDriveRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableComPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableLPTPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableClipboardRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableAudioRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisablePNPRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDefaultMainClientPrinter": SimTypeInt(signed=False, label="UInt32"), "LanAdapter": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeInt(signed=False, label="UInt32"), "fInheritShadowSettings": SimTypeInt(signed=False, label="UInt32"), "ShadowSettings": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsConnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsDisconnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsIdle": SimTypeInt(signed=False, label="UInt32"), "SecurityLayer": SimTypeInt(signed=False, label="UInt32"), "MinEncryptionLevel": SimTypeInt(signed=False, label="UInt32"), "UserAuthentication": SimTypeInt(signed=False, label="UInt32"), "Comment": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 61), "LogonUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 21), "LogonDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 18), "WorkDirectory": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "InitialProgram": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261)}, name="WTSLISTENERCONFIGW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "pBuffer"]),
        # 
        'WTSQueryListenerConfigA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "fEnableListener": SimTypeInt(signed=False, label="UInt32"), "MaxConnectionCount": SimTypeInt(signed=False, label="UInt32"), "fPromptForPassword": SimTypeInt(signed=False, label="UInt32"), "fInheritColorDepth": SimTypeInt(signed=False, label="UInt32"), "ColorDepth": SimTypeInt(signed=False, label="UInt32"), "fInheritBrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "BrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "fDisablePrinterRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDriveRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableComPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableLPTPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableClipboardRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableAudioRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisablePNPRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDefaultMainClientPrinter": SimTypeInt(signed=False, label="UInt32"), "LanAdapter": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeInt(signed=False, label="UInt32"), "fInheritShadowSettings": SimTypeInt(signed=False, label="UInt32"), "ShadowSettings": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsConnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsDisconnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsIdle": SimTypeInt(signed=False, label="UInt32"), "SecurityLayer": SimTypeInt(signed=False, label="UInt32"), "MinEncryptionLevel": SimTypeInt(signed=False, label="UInt32"), "UserAuthentication": SimTypeInt(signed=False, label="UInt32"), "Comment": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 61), "LogonUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 21), "LogonDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 18), "WorkDirectory": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "InitialProgram": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261)}, name="WTSLISTENERCONFIGA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "pBuffer"]),
        # 
        'WTSCreateListenerW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "fEnableListener": SimTypeInt(signed=False, label="UInt32"), "MaxConnectionCount": SimTypeInt(signed=False, label="UInt32"), "fPromptForPassword": SimTypeInt(signed=False, label="UInt32"), "fInheritColorDepth": SimTypeInt(signed=False, label="UInt32"), "ColorDepth": SimTypeInt(signed=False, label="UInt32"), "fInheritBrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "BrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "fDisablePrinterRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDriveRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableComPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableLPTPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableClipboardRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableAudioRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisablePNPRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDefaultMainClientPrinter": SimTypeInt(signed=False, label="UInt32"), "LanAdapter": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeInt(signed=False, label="UInt32"), "fInheritShadowSettings": SimTypeInt(signed=False, label="UInt32"), "ShadowSettings": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsConnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsDisconnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsIdle": SimTypeInt(signed=False, label="UInt32"), "SecurityLayer": SimTypeInt(signed=False, label="UInt32"), "MinEncryptionLevel": SimTypeInt(signed=False, label="UInt32"), "UserAuthentication": SimTypeInt(signed=False, label="UInt32"), "Comment": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 61), "LogonUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 21), "LogonDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 18), "WorkDirectory": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261), "InitialProgram": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261)}, name="WTSLISTENERCONFIGW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "pBuffer", "flag"]),
        # 
        'WTSCreateListenerA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="UInt32"), "fEnableListener": SimTypeInt(signed=False, label="UInt32"), "MaxConnectionCount": SimTypeInt(signed=False, label="UInt32"), "fPromptForPassword": SimTypeInt(signed=False, label="UInt32"), "fInheritColorDepth": SimTypeInt(signed=False, label="UInt32"), "ColorDepth": SimTypeInt(signed=False, label="UInt32"), "fInheritBrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "BrokenTimeoutSettings": SimTypeInt(signed=False, label="UInt32"), "fDisablePrinterRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDriveRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableComPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableLPTPortRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableClipboardRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableAudioRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisablePNPRedirection": SimTypeInt(signed=False, label="UInt32"), "fDisableDefaultMainClientPrinter": SimTypeInt(signed=False, label="UInt32"), "LanAdapter": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeInt(signed=False, label="UInt32"), "fInheritShadowSettings": SimTypeInt(signed=False, label="UInt32"), "ShadowSettings": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsConnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsDisconnection": SimTypeInt(signed=False, label="UInt32"), "TimeoutSettingsIdle": SimTypeInt(signed=False, label="UInt32"), "SecurityLayer": SimTypeInt(signed=False, label="UInt32"), "MinEncryptionLevel": SimTypeInt(signed=False, label="UInt32"), "UserAuthentication": SimTypeInt(signed=False, label="UInt32"), "Comment": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 61), "LogonUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 21), "LogonDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 18), "WorkDirectory": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261), "InitialProgram": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261)}, name="WTSLISTENERCONFIGA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "pBuffer", "flag"]),
        # 
        'WTSSetListenerSecurityW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'WTSSetListenerSecurityA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "SecurityInformation", "pSecurityDescriptor"]),
        # 
        'WTSGetListenerSecurityW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "SecurityInformation", "pSecurityDescriptor", "nLength", "lpnLengthNeeded"]),
        # 
        'WTSGetListenerSecurityA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hServer", "pReserved", "Reserved", "pListenerName", "SecurityInformation", "pSecurityDescriptor", "nLength", "lpnLengthNeeded"]),
        # 
        'WTSEnableChildSessions': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["bEnable"]),
        # 
        'WTSIsChildSessionsEnabled': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbEnabled"]),
        # 
        'WTSGetChildSessionId': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSessionId"]),
        # 
        'WTSSetRenderHint': SimTypeFunction([SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRenderHintID", "hwndOwner", "renderHintType", "cbHintDataLength", "pHintData"]),
    }

lib.set_prototypes(prototypes)
