/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class KmlLightDocument {
    private static final Log LOG = LogFactory.getLog(KmlLightDocument.class);
    public static final String KML_NS = "http://www.opengis.net/kml/2.2";
    private Document docKml;

    public Element createName(String name) {
        Element elName = this.docKml.createElement("name");
        Text txtName = this.docKml.createTextNode(name);
        elName.appendChild(txtName);
        return elName;
    }

    public Element createAddress(String street, String municipality, String zip) {
        String address = street + ", " + municipality + ", " + zip + ", " + ", Belgium";
        Element elAddress = this.docKml.createElement("address");
        Text txtAddress = this.docKml.createTextNode(address);
        elAddress.appendChild(txtAddress);
        return elAddress;
    }

    public Element createDescriptionNode(String description) {
        Element elDescription = this.docKml.createElement("description");
        CDATASection txtDescription = this.docKml.createCDATASection(description);
        elDescription.appendChild(txtDescription);
        return elDescription;
    }

    public Element createTimespan(Date begin, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Element elTimespan = this.docKml.createElement("TimeSpan");
        if (null != begin) {
            Element elBegin = this.docKml.createElement("begin");
            elBegin.setTextContent(dateFormat.format(begin));
            elTimespan.appendChild(elBegin);
        }
        if (end != null) {
            Element elEnd = this.docKml.createElement("end");
            elEnd.setTextContent(dateFormat.format(end));
            elTimespan.appendChild(elEnd);
        }
        return elTimespan;
    }

    public void addPlacemark(Node name, Node address, Node description, Node timespan) {
        Element elPlacemark = this.docKml.createElement("Placemark");
        elPlacemark.appendChild(name);
        if (null != address) {
            elPlacemark.appendChild(address);
        } else {
            LOG.debug((Object)"address is null");
        }
        elPlacemark.appendChild(description);
        if (null != timespan) {
            elPlacemark.appendChild(timespan);
        }
        this.docKml.getDocumentElement().appendChild(elPlacemark);
    }

    public byte[] getDocumentAsBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TransformerFactory fact = TransformerFactory.newInstance();
            Transformer trans = fact.newTransformer();
            trans.transform(new DOMSource(this.docKml), new StreamResult(baos));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return baos.toByteArray();
    }

    public KmlLightDocument() throws IOException {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            this.docKml = builder.newDocument();
            Element elKml = this.docKml.createElement("kml");
            elKml.setAttribute("xmlns", KML_NS);
            this.docKml.appendChild(elKml);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

