# discretisedfield
Marijan Beg<sup>1,2</sup>, Ryan A. Pepper<sup>1</sup>, Thomas Kluyver<sup>2</sup>, and Hans Fangohr<sup>1,2</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*  
<sup>2</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  

| Description | Badge |
| --- | --- |
| Releases | [![PyPI version](https://badge.fury.io/py/discretisedfield.svg)](https://badge.fury.io/py/discretisedfield) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/discretisedfield/badges/version.svg)](https://anaconda.org/conda-forge/discretisedfield) |
| Builds | [![Build Status](https://travis-ci.org/ubermag/discretisedfield.svg?branch=master)](https://travis-ci.org/ubermag/discretisedfield) |
|        |  [![Build status](https://ci.appveyor.com/api/projects/status/0shhdl5sj6fx07oe?svg=true)](https://ci.appveyor.com/project/marijanbeg/discretisedfield) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/discretisedfield/branch/master/graph/badge.svg)](https://codecov.io/gh/ubermag/discretisedfield) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/discretisedfield/badge/?version=latest)](http://discretisedfield.readthedocs.io/en/latest/?badge=latest) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/discretisedfield/master?urlpath=lab/tree/docs/ipynb/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/discretisedfield/badges/platforms.svg)](https://anaconda.org/conda-forge/discretisedfield) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/discretisedfield/badges/downloads.svg)](https://anaconda.org/conda-forge/discretisedfield) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/67028400.svg)](https://zenodo.org/badge/latestdoi/67028400) |

## About

`discretisedfield` is a Python package that provides:

- definition of finite difference regions, meshes, and fields,

- analysis of finite difference fields,

- reading and writing of different file types (OVF, VTK, and HDF5), and

- visualisation using `matplotlib` and `k3d`.

It is available on Windows, MacOS, and Linux. It requires Python 3.6+.

## Documentation

APIs and tutorials are available in documentation. To access them, use the documentation badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the Binder badge in the table above.

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

If you use this package, please cite it as:

1. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025 (2017)](http://aip.scitation.org/doi/10.1063/1.4977225).

2. M. Beg, R. A. Pepper, T. Kluyver, and H. Fangohr. ubermag/discretisedfield: Python package for the analysis and visualisation of finite difference fields. Zenodo. DOI: [10.5281/zenodo.3539461](http://doi.org/10.5281/zenodo.3539461) (2020).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1).
