# AUTOGENERATED! DO NOT EDIT! File to edit: 05_code.ipynb (unless otherwise specified).

__all__ = ['RED', 'BLUE', 'GREEN', 'BOLD', 'ITALIC', 'RESET', 'write_code']

# Cell
RED = '\033[31m'
BLUE = '\033[94m'
GREEN = '\033[92m'
BOLD   = '\033[1m'
ITALIC = '\033[3m'
RESET  = '\033[0m'

import ipywidgets as widgets
from IPython.display import clear_output

from .dashboard_two import dashboard_two
from .datablock import block_ch
from .augmentation_dashboard import aug_dash, aug
from .augmentation_dashboard import stats_info

# Cell
def write_code():
    """Helper for writing code"""
    write_button = widgets.Button(description='Code', button_style = 'success')
    display(write_button)
    write_out = widgets.Output()
    display(write_out)
    def on_write_button(b):
        with write_out:
            clear_output()
            print(RED + BOLD + '"""import libraries"""' + RESET)
            print(GREEN + BOLD + 'from' + RESET + ' fastai2.vision.all ' + GREEN + BOLD + 'import*' + RESET)
            print(RED + BOLD + '\n"""get data source and image files from source"""' + RESET)
            print('source = untar_data(URLs.' + str(dashboard_two.datas.value) + ')')
            print('items = get_image_files(source)')
            print(RED + BOLD + '\n"""get item, split and batch transforms"""' + RESET)
            print('tfms = [[' + str(block_ch.code) + ']' + ' ,' + '[' + str(block_ch.outputb_code) + ', '
                  +  str(block_ch.ctg_code) + ']]')
            print('item_tfms = [ToTensor(), Resize(' + GREEN + str(aug_dash.imgsiz.value) + RESET + ')]')
            print('split_idx = ' + str(block_ch.spl_val_code) + '(items)')
            print(RED + BOLD + '\n"""image augmentations"""' + RESET)
            if aug_dash.aug.value == 'No':
                print('xtra_tfms = '+ GREEN + BOLD + 'None' + RESET)
            if aug_dash.aug.value == 'Yes':
                print(RESET + 'xtra_tfms = [RandomErasing(p=' + GREEN + str(aug.b_pval.value) + RESET + ', max_count=' +
                     GREEN + str(aug.b_max.value) + RESET + ', min_aspect=' + GREEN + str(aug.b_asp.value) + RESET + ', sl=' +
                     GREEN + str(aug.b_len.value) + RESET +  ', sh=' + RESET + GREEN + str(aug.b_ht.value) + RESET + '),')
                print(RESET + '             Brightness(max_lighting=' + GREEN + str(aug.b4_max.value) +  RESET  + ', p=' + GREEN +
                      str(aug.b4_pval.value) + RESET + ', draw=' + GREEN + BOLD + 'None' + RESET + ', batch=' + GREEN + BOLD + 'None' +
                      RESET + ')')
                print(RESET + '             Rotate(max_deg=' + GREEN + str(aug.b2_max.value) +  RESET  + ', p=' + GREEN +
                      str(aug.b2_pval.value) + RESET + ', draw=' + GREEN + BOLD + 'None' + RESET + ', size=' + GREEN + BOLD + 'None' +
                      RESET + ', mode=' + RED + "'bilinear'" + RESET + ', pad_mode=' + RED + str(aug_dash.pad.value) + RESET + ')')
                print(RESET + '             Warp(magnitude=' + GREEN + str(aug.b3_mag.value) +  RESET  + ', p=' + GREEN +
                      str(aug.b3_pval.value) + RESET + ', draw_x=' + GREEN + BOLD + 'None' + RESET + ', draw_y=' + GREEN + BOLD +
                      'None' +  RESET + ', size=' + GREEN + BOLD + 'None' + RESET + ', mode=' + RED + "'bilinear'" + RESET + ', pad_mode=' +
                      RED + str(aug_dash.pad.value) + RESET + ', batch=' + GREEN + BOLD + 'False' + RESET + ')')
                print(RESET + '             Contrast(max_lighting=' + GREEN + str(aug.b1_max.value) +  RESET  + ', p=' + GREEN +
                      str(aug.b1_pval.value) + RESET + ', draw=' + GREEN + str(aug.b1_draw.value) + RESET + ', batch=' + GREEN + BOLD +
                      'True' + RESET + ')')
                print(RESET + '             Dihedral(p=' + GREEN + str(aug.b5_pval.value) +  RESET  + ', draw' + GREEN +
                      str(aug.b5_draw.value) + RESET + ', size=' + GREEN + BOLD + 'None' + RESET + ', mode=' + RED + "'bilinear'" + RESET +
                      ', pad_mode=' + RED + str(aug_dash.pad.value) + RESET + ', batch=' + GREEN + BOLD + 'False' + RESET + ')')
                print(RESET + '             Zoom(max_zoom=' + GREEN + str(aug.b6_zoom.value) +  RESET  + ', p=' + GREEN +
                      str(aug.b6_pval.value) + RESET + ', draw=' + GREEN + BOLD + 'None' + RESET + ', draw_x=' + GREEN + BOLD + 'None' + RESET +
                      ', draw_y=' + GREEN + BOLD + 'None' +  RESET + ', size=' + GREEN + BOLD + 'None' + RESET + ', mode=' + RED + "'bilinear'" +
                      RESET + ', pad_mode=' + RED + str(aug_dash.pad.value) + RESET + ', batch=' + GREEN + BOLD + 'False' + RESET + ')]')

            print('\nafter_b = [Resize(' + GREEN + str(aug_dash.imgbth.value) + RESET + '), IntToFloatTensor(), ' + '\n          ' + "*aug_transforms(xtra_tfms=xtra_tfms, pad_mode="
                  + RED + "'" + str(aug_dash.pad.value) + "'" + RESET + '),' + ' Normalize.from_stats(' + GREEN + str(stats_info.code) + RESET + ')]')

            print('\ndsets = Datasets(items, tfms=tfms, splits=split_idx)')
            print('dls = dsets.dataloaders(after_item=item_tfms, after_batch=after_b, bs=' + GREEN + (aug_dash.bs.value) + RESET +
                  ', num_workers=' + GREEN + '0' + RESET + ')')


            print(RED + BOLD + '\n"""Check training and valid shapes"""' + RESET)
            print('xb, yb = dls.one_batch()')
            print(RESET + 'dls.train' + RESET + RED + BOLD + ' #train')
            print(RESET + 'dls.train_ds' + RESET + RED + BOLD + '#train_ds')
            print(RESET + 'dls.valid' + RESET + RED + BOLD + ' #valid')
            print(RESET + 'dls.valid_ds' + RESET + RED + BOLD + ' #valid_ds')

            print(RESET + RED + BOLD + '\n"""show batch"""' + RESET)
            print('dls.show_batch(max_n=' + GREEN + '12' + RESET + ', rows=' + GREEN + '2' + RESET + ', cols=' +
                  GREEN  + '6' + RESET + ')')
            print(RESET + RED + BOLD + '\n"""train"""' + RESET)
            print('arch = xresnet50(pretrained=' + GREEN + BOLD + 'False' + RESET + ')')
            print('learn = Learner(dls, model=arch, loss_function=LabelSmoothingCrossEntropy(),' +
                 '\n                metrics=[top_k_accuracy, accuracy])')
            print(RESET + 'learn.fit_one_cycle(' + GREEN + '1' + RESET + ', ' + GREEN + '1e-2' + RESET + ')')
            print(RESET + RED + BOLD + '\n"""interpretations"""' + RESET)
            print('interp = ClassificationInterpretation.from_learner(learn)')
            print('losses, idxs = interp.top_losses()')
            print(GREEN + 'len' + RESET + '(dls.valid_ds)' + RESET + '==' + GREEN + 'len' + RESET + '(losses)==' +
                 GREEN + 'len' + RESET + '(idxs)')
            print(RESET + RED + BOLD + '\n"""confusion matrix"""' + RESET)
            print('interp.plot_confusion_matrix(figsize=(' + GREEN + '7' + RESET + ',' + GREEN + '7' + RESET + '))')
    write_button.on_click(on_write_button)