# AUTOGENERATED! DO NOT EDIT! File to edit: 04_datablock.ipynb (unless otherwise specified).

__all__ = ['RED', 'BLUE', 'GREEN', 'BOLD', 'ITALIC', 'RESET', 'ds_3', 'block_ch', 'code_test']

# Cell
RED = '\033[31m'
BLUE = '\033[94m'
GREEN = '\033[92m'
BOLD   = '\033[1m'
ITALIC = '\033[3m'
RESET  = '\033[0m'

import ipywidgets as widgets
from ipywidgets import Layout, Box
from IPython.display import clear_output
from .augmentation_dashboard import stats_info
from .augmentation_dashboard import aug_dash, aug
from .dashboard_two import ds_choice
from .core import repeat_one


from fastai2.vision.core import PILImage, PILImageBW, Categorize, MultiCategorize, RandomSplitter, GrandparentSplitter, parent_label
from fastai2.vision.augment import *
from fastai2.data.transforms import get_image_files, ToTensor, IntToFloatTensor, Normalize
from fastai2.data.core import Datasets

# Cell
def ds_3():
    """GUI for Datablock Accordion window"""
    db_button = widgets.Button(description='Confirm')
    ds_3.d1 = widgets.ToggleButtons(value=None, options=['PILImage', 'PILImageBW'], description='', button_style='info')
    ds_3.e1 = widgets.ToggleButtons(value=None, options=['CategoryBlock', 'MultiCategoryBlock'], description='', button_style='warning')
    ds_3.g = widgets.ToggleButton(description='parent_label', button_style='danger', value=False)
    ds_3.s = widgets.ToggleButtons(value=None, options=['RandomSplitter', 'GrandparentSplitter'],
                                   description='', button_style='success')
    form_items = [ds_3.d1, ds_3.e1, ds_3.s ,ds_3.g]

    form_t = Layout(display='flex',
                    flex_flow='row',
                    align_items='stretch',
                    border='solid 1px',
                    width='100%')
    form = Box(children=form_items, layout=form_t)
    display(form)
    display(db_button)
    db_out = widgets.Output()
    display(db_out)
    def on_db_click(b):
        with db_out:
            clear_output()
            block_ch()
            code_test()
    db_button.on_click(on_db_click)


# Cell
def block_ch():
    """Helper for configuring mid-level datablock"""
    if ds_3.d1.value == 'PILImage':
        block_ch.cls = PILImage.create; block_ch.code = 'PILImage.create'
    if ds_3.d1.value == 'PILImageBW':
        block_ch.cls = PILImageBW.create; block_ch.code = 'PILImageBW.create'
    if ds_3.e1.value == 'CategoryBlock':
        block_ch.ctg = Categorize; block_ch.ctg_code = 'Categorize'
    else:
        block_ch.ctg = MultiCategorize
        block_ch.ctg_code = 'MultiCategorize'
    if ds_3.g.value == True:
        block_ch.outputb = parent_label
        block_ch.outputb_code = 'parent_label'
    else:
        block_ch.outputb = None
    if ds_3.s.value == 'RandomSplitter':
        block_ch.spl_val = RandomSplitter()
        block_ch.spl_val_code = 'RandomSplitter()'
    if ds_3.s.value == 'GrandparentSplitter':
        block_ch.spl_val = GrandparentSplitter()
        block_ch.spl_val_code = 'GrandparentSplitter()'

# Cell
def code_test():
    """Batch helpers"""
    db_button2 = widgets.Button(description='DataBlock')
    stats_info()
    method = ResizeMethod.Pad

    item_size = int(aug_dash.imgsiz.value)
    final_size = int(aug_dash.imgbth.value)

    if aug_dash.bi.value == 'Single':
        code_test.items = repeat_one(ds_choice.source)
    if aug_dash.bi.value == 'Multi':
        code_test.items = get_image_files(ds_choice.source)
    if aug_dash.aug.value == 'No':
        print(BOLD + BLUE + "working.....: " + RESET + RED + 'No Augmentations\n')
        print(BOLD + BLUE + "Multi/Single Image: " + RESET + RED + str(aug_dash.bi.value))
        print(BOLD + BLUE + "Padding: " + RESET + RED + str(aug_dash.pad.value))
        print(BOLD + BLUE + "Normalization: " + RESET + RED + str(stats_info.stats))
        print(BOLD + BLUE + "Batch Size: " + RESET + RED + (aug_dash.bs.value))
        print(BOLD + BLUE + "Item Size: " + RESET + RED + str(item_size))
        print(BOLD + BLUE + "Final Size: " + RESET + RED + str(final_size))

        after_b = None
        tfms = [[PILImage.create], [parent_label, Categorize]]
        item_tfms = [ToTensor(), Resize(item_size)]
        dsets = Datasets(code_test.items, tfms=tfms)
        dls = dsets.dataloaders(after_item=item_tfms, after_batch=after_b, bs=int(aug_dash.bs.value), num_workers=0)

        dls.show_batch(max_n=12, nrows=2, ncols=6)

    if aug_dash.aug.value == 'Yes':
        print(BOLD + BLUE + "working.....: " + RESET + RED + 'Augmentations\n')
        print(BOLD + BLUE + "RandomErasing: " + RESET + RED + 'max_count=' + str(aug.b_max.value) + ' p=' + str(aug.b_pval.value))
        print(BOLD + BLUE + "Contrast: " + RESET + RED + 'max_light=' + str(aug.b1_max.value) + ' p=' + str(aug.b1_pval.value))
        print(BOLD + BLUE + "Rotate: " + RESET + RED + 'max_degree=' + str(aug.b2_max.value) + ' p=' + str(aug.b2_pval.value))
        print(BOLD + BLUE + "Warp: " + RESET + RED + 'magnitude=' + str(aug.b3_mag.value) + ' p=' + str(aug.b3_pval.value))
        print(BOLD + BLUE + "Brightness: " + RESET + RED + 'max_light=' + str(aug.b4_max.value) + ' p=' + str(aug.b4_pval.value))
        print(BOLD + BLUE + "DihedralFlip: " + RESET + RED + ' p=' + str(aug.b5_pval.value) + 'draw=' + str(aug.b5_draw.value))
        print(BOLD + BLUE + "Zoom: " + RESET + RED + 'max_zoom=' + str(aug.b6_zoom.value) + ' p=' + str(aug.b6_pval.value))
        print(BOLD + BLUE + "\nMulti/Single Image: " + RESET + RED + str(aug_dash.bi.value))
        print(BOLD + BLUE + "Padding: " + RESET + RED + str(aug_dash.pad.value))
        print(BOLD + BLUE + "Normalization: " + RESET + RED + str(stats_info.stats))
        print(BOLD + BLUE + "Batch Size: " + RESET + RED + (aug_dash.bs.value))
        print(BOLD + BLUE + "Item Size: " + RESET + RED + str(item_size))
        print(BOLD + BLUE + "Final Size: " + RESET + RED + str(final_size))

        xtra_tfms = [RandomErasing(p=aug.b_pval.value, max_count=aug.b_max.value, min_aspect=aug.b_asp.value, sl=aug.b_len.value, sh=aug.b_ht.value), #p= probabilty
                 Brightness(max_lighting=aug.b4_max.value, p=aug.b4_pval.value, draw=None, batch=None),
                 Rotate(max_deg=aug.b2_max.value, p=aug.b2_pval.value, draw=None, size=None, mode='bilinear', pad_mode=aug_dash.pad.value),
                 Warp(magnitude=aug.b3_mag.value,p=aug.b3_pval.value,draw_x=None,draw_y=None,size=None,mode='bilinear',pad_mode=aug_dash.pad.value,batch=False,),
                 Contrast(max_lighting=aug.b1_max.value, p=aug.b1_pval.value, draw=aug.b1_draw.value, batch=True), #draw = 1 is normal batch=batch tfms or not
                 Dihedral(p=aug.b5_pval.value, draw=aug.b5_draw.value, size=None, mode='bilinear', pad_mode=PadMode.Reflection, batch=False),
                 Zoom(max_zoom=aug.b6_zoom.value, p=aug.b6_pval.value, draw=None, draw_x=None, draw_y=None, size=None, mode='bilinear',pad_mode=aug_dash.pad.value, batch=False)
                    ]

        after_b = [Resize(final_size), IntToFloatTensor(), *aug_transforms(xtra_tfms=xtra_tfms, pad_mode=aug_dash.pad.value),
                   Normalize(stats_info.stats)]

        items = get_image_files(ds_choice.source/'train')
        split_idx = block_ch.spl_val(items)
        tfms = [[block_ch.cls], [block_ch.outputb, block_ch.ctg]]
        item_tfms = [ToTensor(), Resize(item_size)]
        dsets = Datasets(items, tfms=tfms, splits=split_idx)
        dls = dsets.dataloaders(after_item=item_tfms, after_batch=after_b, bs=int(aug_dash.bs.value), num_workers=0)

        display(db_button2)
        db_out = widgets.Output()
        display(db_out)
        def on_db_out(b):
            clear_output()
            xb, yb = dls.one_batch()
            print(BOLD + BLUE + "Train: " + RESET + RED + '(' + str(len(dls.train)) + ', ' + str(len(dls.train_ds)) + ') ' +
                 BOLD + BLUE + "Valid: "+ RESET + RED + '(' + str(len(dls.valid)) + ', ' + str(len(dls.valid_ds)) + ')')
            print(BOLD + BLUE + "Input Shape: " + RESET + RED + str(xb.shape))
            print(BOLD + BLUE + "Output Shape: " + RESET + RED + str(yb.shape) + " by " + str(dls.c) + " classes")
            dls.show_batch(max_n=12, nrows=2, ncols=6)
        db_button2.on_click(on_db_out)