# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class AssetModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'tables': 'list[AssetTableModel]',
        'root_table': 'str',
        'root_column': 'str',
        'follow': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'tables': 'tables',
        'root_table': 'rootTable',
        'root_column': 'rootColumn',
        'follow': 'follow'
    }

    def __init__(self, name=None, tables=None, root_table=None, root_column=None, follow=None, local_vars_configuration=None):  # noqa: E501
        """AssetModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._tables = None
        self._root_table = None
        self._root_column = None
        self._follow = None
        self.discriminator = None

        self.name = name
        self.tables = tables
        self.root_table = root_table
        self.root_column = root_column
        if follow is not None:
            self.follow = follow

    @property
    def name(self):
        """Gets the name of this AssetModel.  # noqa: E501


        :return: The name of this AssetModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AssetModel.


        :param name: The name of this AssetModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def tables(self):
        """Gets the tables of this AssetModel.  # noqa: E501


        :return: The tables of this AssetModel.  # noqa: E501
        :rtype: list[AssetTableModel]
        """
        return self._tables

    @tables.setter
    def tables(self, tables):
        """Sets the tables of this AssetModel.


        :param tables: The tables of this AssetModel.  # noqa: E501
        :type: list[AssetTableModel]
        """
        if self.local_vars_configuration.client_side_validation and tables is None:  # noqa: E501
            raise ValueError("Invalid value for `tables`, must not be `None`")  # noqa: E501

        self._tables = tables

    @property
    def root_table(self):
        """Gets the root_table of this AssetModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The root_table of this AssetModel.  # noqa: E501
        :rtype: str
        """
        return self._root_table

    @root_table.setter
    def root_table(self, root_table):
        """Sets the root_table of this AssetModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param root_table: The root_table of this AssetModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and root_table is None:  # noqa: E501
            raise ValueError("Invalid value for `root_table`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_table is not None and len(root_table) > 63):
            raise ValueError("Invalid value for `root_table`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_table is not None and len(root_table) < 1):
            raise ValueError("Invalid value for `root_table`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_table is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', root_table)):  # noqa: E501
            raise ValueError(r"Invalid value for `root_table`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._root_table = root_table

    @property
    def root_column(self):
        """Gets the root_column of this AssetModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The root_column of this AssetModel.  # noqa: E501
        :rtype: str
        """
        return self._root_column

    @root_column.setter
    def root_column(self, root_column):
        """Sets the root_column of this AssetModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param root_column: The root_column of this AssetModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and root_column is None:  # noqa: E501
            raise ValueError("Invalid value for `root_column`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_column is not None and len(root_column) > 63):
            raise ValueError("Invalid value for `root_column`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_column is not None and len(root_column) < 1):
            raise ValueError("Invalid value for `root_column`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                root_column is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', root_column)):  # noqa: E501
            raise ValueError(r"Invalid value for `root_column`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._root_column = root_column

    @property
    def follow(self):
        """Gets the follow of this AssetModel.  # noqa: E501


        :return: The follow of this AssetModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._follow

    @follow.setter
    def follow(self, follow):
        """Sets the follow of this AssetModel.


        :param follow: The follow of this AssetModel.  # noqa: E501
        :type: list[str]
        """

        self._follow = follow

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetModel):
            return True

        return self.to_dict() != other.to_dict()
