import requests
from .base import base


class cjdgUser(base):

    def __init__(self, token, app_secret):
        super().__init__(token, app_secret)

    def create(self, data):
        api_name = "user/create"
        return self.request(api_name, data)

    def createBatch(self, data):
        api_name = "user/batchcreate"
        return self.request(api_name, data)

    def list(self, data):
        api_name = "user/query"
        return self.request(api_name, data)

    def read(self, account):
        api_name = "user/query"
        return self.request(api_name, data)

    def getUserIds(self, accounts):
        api_name = "user/query/byaccounts"
        data = {
            "accounts": accounts,
        }
        return self.request(api_name, data, method="POST")

    def update(self, data):
        api_name = "user/modifi"
        return self.request(api_name, data)

    def updateBatch(self, data):
        api_name = "user/modifi"
        return self.request(api_name, data)

    def delete(self, data):
        api_name = "user/destroy"
        return self.request(api_name, data)

    def enabled(self, data):
        api_name = "user/enabled"
        return self.request(api_name, data)