from typing import List, Optional


class ProjectFileType:
    # FileType to use (e.g. "CppForm")
    FileType : str
    # Pattern of files to apply to (e.g. "*\\Forms\\*.h")
    Pattern  : str


class ProjectImport:
    # Condition for import
    Condition : str
    # Path to file to import
    Project   : str


class AdditonalConfigurationOptions:
    ###############################################
    # Compilation (optional)
    ###############################################

    # (optional) Command to launch when "build project" is selected.
    ProjectBuildCommand : Optional[str]
    # (optional) Command to launch when "rebuild project" is selected.
    ProjectRebuildCommand : Optional[str]
    # (optional) Command to launch when "clean project" is selected.
    ProjectCleanCommand : Optional[str]

    ###############################################
    # Compilation Input/Output (optional)
    ###############################################

    # (optional) Output generated by compilation.
    Output : Optional[str]
    # (optional) Output directory for Visual Studio.
    OutputDirectory : Optional[str]
    # (optional) Intermediate directory for Visual Studio.
    IntermediateDirectory : Optional[str]
    # (optional) Build log file for Visual Studio.
    BuildLogFile : Optional[str]
    # (optional) Directory to prepare Layout (for XboxOne).
    LayoutDir : Optional[str]
    # (optional) Files to filter from Layout (for XboxOne).
    LayoutExtensionFilter : Optional[str]

    ###############################################
    # Intellisense Options (optional)
    ###############################################

    # (optional) Preprocessor definitions.
    PreprocessorDefinitions : Optional[str]
    # (optional) Include search paths.
    IncludeSearchPath : Optional[str]
    # (optional) Force included files.
    ForcedIncludes : Optional[str]
    # (optional) Assembly search paths.
    AssemblySearchPath : Optional[str]
    # (optional) Forced Using assemblies.
    ForcedUsingAssemblies : Optional[str]
    # (optional) Additional compiler options.
    AdditionalOptions : Optional[str]

    ###############################################
    # Debugging Options (optional)
    ###############################################

    # (optional) Executable to launch when debugging.
    LocalDebuggerCommand : Optional[str]
    # (optional) Args passed to executable when debugging.
    LocalDebuggerCommandArguments : Optional[str]
    # (optional) Working Dir for executable when debugging.
    LocalDebuggerWorkingDirectory : Optional[str]
    # (optional) Environment variables when debugging.
    LocalDebuggerEnvironment : Optional[str]
    # (optional) Executable to launch when debugging remotely.
    RemoteDebuggerCommand : Optional[str]
    # (optional) Args passed to remote executable when debugging.
    RemoteDebuggerCommandArguments : Optional[str]
    # (optional) Working Dir for remote executable when debugging.
    RemoteDebuggerWorkingDirectory : Optional[str]
    # (optional) Debugger command for Xbox360 only.
    Xbox360DebuggerCommand : Optional[str]
    # (optional) Debugger flavor.
    DebuggerFlavor : Optional[str]
    # (optional) Aumid override (for XboxOne).
    AumidOverride : Optional[str]
    # (optional) Keyword
    Keyword : Optional[str]
    # (optional) Application type
    ApplicationType : Optional[str]
    # (optional) Application type revision
    ApplicationTypeRevision : Optional[str]
    # (optional) Set the Linux platform type
    TargetLinuxPlatform : Optional[str]
    # (optional) Set the project type GUID for Linux
    LinuxProjectType : Optional[str]
    # (optional) Path to package to debug
    PackagePath : Optional[str]
    # (optional) Additional symbol search paths for debugging
    AdditionalSymbolSearchPaths : Optional[str]

    ###############################################
    # Misc
    ###############################################

    # (optional) Specify PlatformToolset.
    PlatformToolset : Optional[str]
    # (optional) Specify deployment type for Xbox360.
    DeploymentType : Optional[str]
    # (optional) Specify files to add to deployment for Xbox360.
    DeploymentFiles : Optional[str]
    # (optional) Set RootNamespace for project
    RootNamespace : Optional[str]


class ProjectConfig(AdditonalConfigurationOptions):
    # Platform (e.g. Win32, X64, PS3 etc.)
    Platform : str
    # Config (e.g. Debug, Release etc.)
    Config   : str
    # (optional) Previously defined Build Target
    Target   : str


class VCXProject(AdditonalConfigurationOptions):
    # (optional) Alias
    Alias : Optional[str]

    ###############################################
    # Output Options
    ###############################################

    # Filename of project file
    ProjectOutput : str

    ###############################################
    # Input Options
    ###############################################

    # (optional) Paths to include in project
    ProjectInputPaths              : Optional[List[str]]
    # (optional) Paths to exclude from project
    ProjectInputPathsExclude       : Optional[List[str]]
    # (optional) Pattern(s) for files to exclude from project
    ProjectPatternToExclude        : Optional[List[str]]
    # (optional) Extensions to allow in path searches
    ProjectAllowedFileExtensions   : Optional[List[str]]
    # (optional) List of files to include in project
    ProjectFiles                   : Optional[List[str]]
    # (optional) List of files to exclude from project
    ProjectFilesToExclude          : Optional[List[str]]
    # (optional) Base path(s) for root folder(s) in project
    ProjectBasePath                : Optional[List[str]]
    # (optional) List of filters to override base file types (see above)
    ProjectFileTypes               : Optional[List[ProjectFileType]]

    ###############################################
    # Build Config Options
    ###############################################

    # (optional) List of project configurations, see below for details.
    # (default: Debug Win32, Release Win32, Debug X64, Release X64)
    ProjectConfigs                 : Optional[List[ProjectConfig]]

    ###############################################
    # Reference Options
    ###############################################

    # (optional) References to assemblies (e.g "System.Core")
    ProjectReferences              : Optional[List[str]]
    # (optional) References to projects (e.g. "myproj.csproj|{guid}")
    ProjectProjectReferences       : Optional[List[str]]

    ###############################################
    # Project Import Options
    ###############################################

    # (optional) Array of ProjectImports, see below for details
    ProjectProjectImports          : Optional[List[ProjectImport]]

    ###############################################
    # Other Options
    ###############################################

    # (optional) Override default generated ProjectGuid
    ProjectGuid                    : Optional[List[str]]
    # (optional) Default Language Property (for XboxOne/WinRT)
    DefaultLanguage                : Optional[List[str]]
    # (optional) Application Environment (for XboxOne/WinRT)
    ApplicationEnvironment         : Optional[List[str]]
    # (optional) Project will contain source control binding strings
    ProjectSccEntrySAK             : Optional[List[str]]

    @staticmethod
    def keyword() -> str:
        return "VCXProject"
