"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BigqueryTable = exports.BigqueryTableViewOutputReference = exports.bigqueryTableViewToTerraform = exports.BigqueryTableTimePartitioningOutputReference = exports.bigqueryTableTimePartitioningToTerraform = exports.BigqueryTableRangePartitioningOutputReference = exports.bigqueryTableRangePartitioningToTerraform = exports.BigqueryTableRangePartitioningRangeOutputReference = exports.bigqueryTableRangePartitioningRangeToTerraform = exports.BigqueryTableMaterializedViewOutputReference = exports.bigqueryTableMaterializedViewToTerraform = exports.BigqueryTableExternalDataConfigurationOutputReference = exports.bigqueryTableExternalDataConfigurationToTerraform = exports.BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference = exports.bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform = exports.BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference = exports.bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform = exports.BigqueryTableExternalDataConfigurationCsvOptionsOutputReference = exports.bigqueryTableExternalDataConfigurationCsvOptionsToTerraform = exports.BigqueryTableEncryptionConfigurationOutputReference = exports.bigqueryTableEncryptionConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function bigqueryTableEncryptionConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        kms_key_name: cdktf.stringToTerraform(struct.kmsKeyName),
    };
}
exports.bigqueryTableEncryptionConfigurationToTerraform = bigqueryTableEncryptionConfigurationToTerraform;
class BigqueryTableEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._kmsKeyName !== undefined) {
            hasAnyValues = true;
            internalValueResult.kmsKeyName = this._kmsKeyName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._kmsKeyName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._kmsKeyName = value.kmsKeyName;
        }
    }
    get kmsKeyName() {
        return this.getStringAttribute('kms_key_name');
    }
    set kmsKeyName(value) {
        this._kmsKeyName = value;
    }
    // Temporarily expose input value. Use with caution.
    get kmsKeyNameInput() {
        return this._kmsKeyName;
    }
    // kms_key_version - computed: true, optional: false, required: false
    get kmsKeyVersion() {
        return this.getStringAttribute('kms_key_version');
    }
}
exports.BigqueryTableEncryptionConfigurationOutputReference = BigqueryTableEncryptionConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
BigqueryTableEncryptionConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-google.BigqueryTableEncryptionConfigurationOutputReference", version: "0.6.40" };
function bigqueryTableExternalDataConfigurationCsvOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allow_jagged_rows: cdktf.booleanToTerraform(struct.allowJaggedRows),
        allow_quoted_newlines: cdktf.booleanToTerraform(struct.allowQuotedNewlines),
        encoding: cdktf.stringToTerraform(struct.encoding),
        field_delimiter: cdktf.stringToTerraform(struct.fieldDelimiter),
        quote: cdktf.stringToTerraform(struct.quote),
        skip_leading_rows: cdktf.numberToTerraform(struct.skipLeadingRows),
    };
}
exports.bigqueryTableExternalDataConfigurationCsvOptionsToTerraform = bigqueryTableExternalDataConfigurationCsvOptionsToTerraform;
class BigqueryTableExternalDataConfigurationCsvOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowJaggedRows !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowJaggedRows = this._allowJaggedRows;
        }
        if (this._allowQuotedNewlines !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowQuotedNewlines = this._allowQuotedNewlines;
        }
        if (this._encoding !== undefined) {
            hasAnyValues = true;
            internalValueResult.encoding = this._encoding;
        }
        if (this._fieldDelimiter !== undefined) {
            hasAnyValues = true;
            internalValueResult.fieldDelimiter = this._fieldDelimiter;
        }
        if (this._quote !== undefined) {
            hasAnyValues = true;
            internalValueResult.quote = this._quote;
        }
        if (this._skipLeadingRows !== undefined) {
            hasAnyValues = true;
            internalValueResult.skipLeadingRows = this._skipLeadingRows;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowJaggedRows = undefined;
            this._allowQuotedNewlines = undefined;
            this._encoding = undefined;
            this._fieldDelimiter = undefined;
            this._quote = undefined;
            this._skipLeadingRows = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowJaggedRows = value.allowJaggedRows;
            this._allowQuotedNewlines = value.allowQuotedNewlines;
            this._encoding = value.encoding;
            this._fieldDelimiter = value.fieldDelimiter;
            this._quote = value.quote;
            this._skipLeadingRows = value.skipLeadingRows;
        }
    }
    get allowJaggedRows() {
        return this.getBooleanAttribute('allow_jagged_rows');
    }
    set allowJaggedRows(value) {
        this._allowJaggedRows = value;
    }
    resetAllowJaggedRows() {
        this._allowJaggedRows = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowJaggedRowsInput() {
        return this._allowJaggedRows;
    }
    get allowQuotedNewlines() {
        return this.getBooleanAttribute('allow_quoted_newlines');
    }
    set allowQuotedNewlines(value) {
        this._allowQuotedNewlines = value;
    }
    resetAllowQuotedNewlines() {
        this._allowQuotedNewlines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowQuotedNewlinesInput() {
        return this._allowQuotedNewlines;
    }
    get encoding() {
        return this.getStringAttribute('encoding');
    }
    set encoding(value) {
        this._encoding = value;
    }
    resetEncoding() {
        this._encoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingInput() {
        return this._encoding;
    }
    get fieldDelimiter() {
        return this.getStringAttribute('field_delimiter');
    }
    set fieldDelimiter(value) {
        this._fieldDelimiter = value;
    }
    resetFieldDelimiter() {
        this._fieldDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldDelimiterInput() {
        return this._fieldDelimiter;
    }
    get quote() {
        return this.getStringAttribute('quote');
    }
    set quote(value) {
        this._quote = value;
    }
    // Temporarily expose input value. Use with caution.
    get quoteInput() {
        return this._quote;
    }
    get skipLeadingRows() {
        return this.getNumberAttribute('skip_leading_rows');
    }
    set skipLeadingRows(value) {
        this._skipLeadingRows = value;
    }
    resetSkipLeadingRows() {
        this._skipLeadingRows = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipLeadingRowsInput() {
        return this._skipLeadingRows;
    }
}
exports.BigqueryTableExternalDataConfigurationCsvOptionsOutputReference = BigqueryTableExternalDataConfigurationCsvOptionsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
BigqueryTableExternalDataConfigurationCsvOptionsOutputReference[_b] = { fqn: "@cdktf/provider-google.BigqueryTableExternalDataConfigurationCsvOptionsOutputReference", version: "0.6.40" };
function bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        range: cdktf.stringToTerraform(struct.range),
        skip_leading_rows: cdktf.numberToTerraform(struct.skipLeadingRows),
    };
}
exports.bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform = bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform;
class BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._range !== undefined) {
            hasAnyValues = true;
            internalValueResult.range = this._range;
        }
        if (this._skipLeadingRows !== undefined) {
            hasAnyValues = true;
            internalValueResult.skipLeadingRows = this._skipLeadingRows;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._range = undefined;
            this._skipLeadingRows = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._range = value.range;
            this._skipLeadingRows = value.skipLeadingRows;
        }
    }
    get range() {
        return this.getStringAttribute('range');
    }
    set range(value) {
        this._range = value;
    }
    resetRange() {
        this._range = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rangeInput() {
        return this._range;
    }
    get skipLeadingRows() {
        return this.getNumberAttribute('skip_leading_rows');
    }
    set skipLeadingRows(value) {
        this._skipLeadingRows = value;
    }
    resetSkipLeadingRows() {
        this._skipLeadingRows = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipLeadingRowsInput() {
        return this._skipLeadingRows;
    }
}
exports.BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference = BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference[_c] = { fqn: "@cdktf/provider-google.BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference", version: "0.6.40" };
function bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mode: cdktf.stringToTerraform(struct.mode),
        require_partition_filter: cdktf.booleanToTerraform(struct.requirePartitionFilter),
        source_uri_prefix: cdktf.stringToTerraform(struct.sourceUriPrefix),
    };
}
exports.bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform = bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform;
class BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._mode !== undefined) {
            hasAnyValues = true;
            internalValueResult.mode = this._mode;
        }
        if (this._requirePartitionFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.requirePartitionFilter = this._requirePartitionFilter;
        }
        if (this._sourceUriPrefix !== undefined) {
            hasAnyValues = true;
            internalValueResult.sourceUriPrefix = this._sourceUriPrefix;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._mode = undefined;
            this._requirePartitionFilter = undefined;
            this._sourceUriPrefix = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._mode = value.mode;
            this._requirePartitionFilter = value.requirePartitionFilter;
            this._sourceUriPrefix = value.sourceUriPrefix;
        }
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get requirePartitionFilter() {
        return this.getBooleanAttribute('require_partition_filter');
    }
    set requirePartitionFilter(value) {
        this._requirePartitionFilter = value;
    }
    resetRequirePartitionFilter() {
        this._requirePartitionFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirePartitionFilterInput() {
        return this._requirePartitionFilter;
    }
    get sourceUriPrefix() {
        return this.getStringAttribute('source_uri_prefix');
    }
    set sourceUriPrefix(value) {
        this._sourceUriPrefix = value;
    }
    resetSourceUriPrefix() {
        this._sourceUriPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceUriPrefixInput() {
        return this._sourceUriPrefix;
    }
}
exports.BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference = BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference[_d] = { fqn: "@cdktf/provider-google.BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference", version: "0.6.40" };
function bigqueryTableExternalDataConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        autodetect: cdktf.booleanToTerraform(struct.autodetect),
        compression: cdktf.stringToTerraform(struct.compression),
        ignore_unknown_values: cdktf.booleanToTerraform(struct.ignoreUnknownValues),
        max_bad_records: cdktf.numberToTerraform(struct.maxBadRecords),
        schema: cdktf.stringToTerraform(struct.schema),
        source_format: cdktf.stringToTerraform(struct.sourceFormat),
        source_uris: cdktf.listMapper(cdktf.stringToTerraform)(struct.sourceUris),
        csv_options: bigqueryTableExternalDataConfigurationCsvOptionsToTerraform(struct.csvOptions),
        google_sheets_options: bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform(struct.googleSheetsOptions),
        hive_partitioning_options: bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform(struct.hivePartitioningOptions),
    };
}
exports.bigqueryTableExternalDataConfigurationToTerraform = bigqueryTableExternalDataConfigurationToTerraform;
class BigqueryTableExternalDataConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // csv_options - computed: false, optional: true, required: false
        this._csvOptions = new BigqueryTableExternalDataConfigurationCsvOptionsOutputReference(this, "csv_options", true);
        // google_sheets_options - computed: false, optional: true, required: false
        this._googleSheetsOptions = new BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference(this, "google_sheets_options", true);
        // hive_partitioning_options - computed: false, optional: true, required: false
        this._hivePartitioningOptions = new BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference(this, "hive_partitioning_options", true);
    }
    get internalValue() {
        var _m, _o, _p, _q, _r, _s;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._autodetect !== undefined) {
            hasAnyValues = true;
            internalValueResult.autodetect = this._autodetect;
        }
        if (this._compression !== undefined) {
            hasAnyValues = true;
            internalValueResult.compression = this._compression;
        }
        if (this._ignoreUnknownValues !== undefined) {
            hasAnyValues = true;
            internalValueResult.ignoreUnknownValues = this._ignoreUnknownValues;
        }
        if (this._maxBadRecords !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxBadRecords = this._maxBadRecords;
        }
        if (this._schema !== undefined) {
            hasAnyValues = true;
            internalValueResult.schema = this._schema;
        }
        if (this._sourceFormat !== undefined) {
            hasAnyValues = true;
            internalValueResult.sourceFormat = this._sourceFormat;
        }
        if (this._sourceUris !== undefined) {
            hasAnyValues = true;
            internalValueResult.sourceUris = this._sourceUris;
        }
        if (((_m = this._csvOptions) === null || _m === void 0 ? void 0 : _m.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.csvOptions = (_o = this._csvOptions) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        if (((_p = this._googleSheetsOptions) === null || _p === void 0 ? void 0 : _p.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.googleSheetsOptions = (_q = this._googleSheetsOptions) === null || _q === void 0 ? void 0 : _q.internalValue;
        }
        if (((_r = this._hivePartitioningOptions) === null || _r === void 0 ? void 0 : _r.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.hivePartitioningOptions = (_s = this._hivePartitioningOptions) === null || _s === void 0 ? void 0 : _s.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._autodetect = undefined;
            this._compression = undefined;
            this._ignoreUnknownValues = undefined;
            this._maxBadRecords = undefined;
            this._schema = undefined;
            this._sourceFormat = undefined;
            this._sourceUris = undefined;
            this._csvOptions.internalValue = undefined;
            this._googleSheetsOptions.internalValue = undefined;
            this._hivePartitioningOptions.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._autodetect = value.autodetect;
            this._compression = value.compression;
            this._ignoreUnknownValues = value.ignoreUnknownValues;
            this._maxBadRecords = value.maxBadRecords;
            this._schema = value.schema;
            this._sourceFormat = value.sourceFormat;
            this._sourceUris = value.sourceUris;
            this._csvOptions.internalValue = value.csvOptions;
            this._googleSheetsOptions.internalValue = value.googleSheetsOptions;
            this._hivePartitioningOptions.internalValue = value.hivePartitioningOptions;
        }
    }
    get autodetect() {
        return this.getBooleanAttribute('autodetect');
    }
    set autodetect(value) {
        this._autodetect = value;
    }
    // Temporarily expose input value. Use with caution.
    get autodetectInput() {
        return this._autodetect;
    }
    get compression() {
        return this.getStringAttribute('compression');
    }
    set compression(value) {
        this._compression = value;
    }
    resetCompression() {
        this._compression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionInput() {
        return this._compression;
    }
    get ignoreUnknownValues() {
        return this.getBooleanAttribute('ignore_unknown_values');
    }
    set ignoreUnknownValues(value) {
        this._ignoreUnknownValues = value;
    }
    resetIgnoreUnknownValues() {
        this._ignoreUnknownValues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreUnknownValuesInput() {
        return this._ignoreUnknownValues;
    }
    get maxBadRecords() {
        return this.getNumberAttribute('max_bad_records');
    }
    set maxBadRecords(value) {
        this._maxBadRecords = value;
    }
    resetMaxBadRecords() {
        this._maxBadRecords = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxBadRecordsInput() {
        return this._maxBadRecords;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    resetSchema() {
        this._schema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    get sourceFormat() {
        return this.getStringAttribute('source_format');
    }
    set sourceFormat(value) {
        this._sourceFormat = value;
    }
    // Temporarily expose input value. Use with caution.
    get sourceFormatInput() {
        return this._sourceFormat;
    }
    get sourceUris() {
        return this.getListAttribute('source_uris');
    }
    set sourceUris(value) {
        this._sourceUris = value;
    }
    // Temporarily expose input value. Use with caution.
    get sourceUrisInput() {
        return this._sourceUris;
    }
    get csvOptions() {
        return this._csvOptions;
    }
    putCsvOptions(value) {
        this._csvOptions.internalValue = value;
    }
    resetCsvOptions() {
        this._csvOptions.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get csvOptionsInput() {
        return this._csvOptions.internalValue;
    }
    get googleSheetsOptions() {
        return this._googleSheetsOptions;
    }
    putGoogleSheetsOptions(value) {
        this._googleSheetsOptions.internalValue = value;
    }
    resetGoogleSheetsOptions() {
        this._googleSheetsOptions.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleSheetsOptionsInput() {
        return this._googleSheetsOptions.internalValue;
    }
    get hivePartitioningOptions() {
        return this._hivePartitioningOptions;
    }
    putHivePartitioningOptions(value) {
        this._hivePartitioningOptions.internalValue = value;
    }
    resetHivePartitioningOptions() {
        this._hivePartitioningOptions.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hivePartitioningOptionsInput() {
        return this._hivePartitioningOptions.internalValue;
    }
}
exports.BigqueryTableExternalDataConfigurationOutputReference = BigqueryTableExternalDataConfigurationOutputReference;
_e = JSII_RTTI_SYMBOL_1;
BigqueryTableExternalDataConfigurationOutputReference[_e] = { fqn: "@cdktf/provider-google.BigqueryTableExternalDataConfigurationOutputReference", version: "0.6.40" };
function bigqueryTableMaterializedViewToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_refresh: cdktf.booleanToTerraform(struct.enableRefresh),
        query: cdktf.stringToTerraform(struct.query),
        refresh_interval_ms: cdktf.numberToTerraform(struct.refreshIntervalMs),
    };
}
exports.bigqueryTableMaterializedViewToTerraform = bigqueryTableMaterializedViewToTerraform;
class BigqueryTableMaterializedViewOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enableRefresh !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableRefresh = this._enableRefresh;
        }
        if (this._query !== undefined) {
            hasAnyValues = true;
            internalValueResult.query = this._query;
        }
        if (this._refreshIntervalMs !== undefined) {
            hasAnyValues = true;
            internalValueResult.refreshIntervalMs = this._refreshIntervalMs;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enableRefresh = undefined;
            this._query = undefined;
            this._refreshIntervalMs = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enableRefresh = value.enableRefresh;
            this._query = value.query;
            this._refreshIntervalMs = value.refreshIntervalMs;
        }
    }
    get enableRefresh() {
        return this.getBooleanAttribute('enable_refresh');
    }
    set enableRefresh(value) {
        this._enableRefresh = value;
    }
    resetEnableRefresh() {
        this._enableRefresh = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableRefreshInput() {
        return this._enableRefresh;
    }
    get query() {
        return this.getStringAttribute('query');
    }
    set query(value) {
        this._query = value;
    }
    // Temporarily expose input value. Use with caution.
    get queryInput() {
        return this._query;
    }
    get refreshIntervalMs() {
        return this.getNumberAttribute('refresh_interval_ms');
    }
    set refreshIntervalMs(value) {
        this._refreshIntervalMs = value;
    }
    resetRefreshIntervalMs() {
        this._refreshIntervalMs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get refreshIntervalMsInput() {
        return this._refreshIntervalMs;
    }
}
exports.BigqueryTableMaterializedViewOutputReference = BigqueryTableMaterializedViewOutputReference;
_f = JSII_RTTI_SYMBOL_1;
BigqueryTableMaterializedViewOutputReference[_f] = { fqn: "@cdktf/provider-google.BigqueryTableMaterializedViewOutputReference", version: "0.6.40" };
function bigqueryTableRangePartitioningRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        end: cdktf.numberToTerraform(struct.end),
        interval: cdktf.numberToTerraform(struct.interval),
        start: cdktf.numberToTerraform(struct.start),
    };
}
exports.bigqueryTableRangePartitioningRangeToTerraform = bigqueryTableRangePartitioningRangeToTerraform;
class BigqueryTableRangePartitioningRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._end !== undefined) {
            hasAnyValues = true;
            internalValueResult.end = this._end;
        }
        if (this._interval !== undefined) {
            hasAnyValues = true;
            internalValueResult.interval = this._interval;
        }
        if (this._start !== undefined) {
            hasAnyValues = true;
            internalValueResult.start = this._start;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._end = undefined;
            this._interval = undefined;
            this._start = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._end = value.end;
            this._interval = value.interval;
            this._start = value.start;
        }
    }
    get end() {
        return this.getNumberAttribute('end');
    }
    set end(value) {
        this._end = value;
    }
    // Temporarily expose input value. Use with caution.
    get endInput() {
        return this._end;
    }
    get interval() {
        return this.getNumberAttribute('interval');
    }
    set interval(value) {
        this._interval = value;
    }
    // Temporarily expose input value. Use with caution.
    get intervalInput() {
        return this._interval;
    }
    get start() {
        return this.getNumberAttribute('start');
    }
    set start(value) {
        this._start = value;
    }
    // Temporarily expose input value. Use with caution.
    get startInput() {
        return this._start;
    }
}
exports.BigqueryTableRangePartitioningRangeOutputReference = BigqueryTableRangePartitioningRangeOutputReference;
_g = JSII_RTTI_SYMBOL_1;
BigqueryTableRangePartitioningRangeOutputReference[_g] = { fqn: "@cdktf/provider-google.BigqueryTableRangePartitioningRangeOutputReference", version: "0.6.40" };
function bigqueryTableRangePartitioningToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        field: cdktf.stringToTerraform(struct.field),
        range: bigqueryTableRangePartitioningRangeToTerraform(struct.range),
    };
}
exports.bigqueryTableRangePartitioningToTerraform = bigqueryTableRangePartitioningToTerraform;
class BigqueryTableRangePartitioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // range - computed: false, optional: false, required: true
        this._range = new BigqueryTableRangePartitioningRangeOutputReference(this, "range", true);
    }
    get internalValue() {
        var _m, _o;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._field !== undefined) {
            hasAnyValues = true;
            internalValueResult.field = this._field;
        }
        if (((_m = this._range) === null || _m === void 0 ? void 0 : _m.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.range = (_o = this._range) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._field = undefined;
            this._range.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._field = value.field;
            this._range.internalValue = value.range;
        }
    }
    get field() {
        return this.getStringAttribute('field');
    }
    set field(value) {
        this._field = value;
    }
    // Temporarily expose input value. Use with caution.
    get fieldInput() {
        return this._field;
    }
    get range() {
        return this._range;
    }
    putRange(value) {
        this._range.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get rangeInput() {
        return this._range.internalValue;
    }
}
exports.BigqueryTableRangePartitioningOutputReference = BigqueryTableRangePartitioningOutputReference;
_h = JSII_RTTI_SYMBOL_1;
BigqueryTableRangePartitioningOutputReference[_h] = { fqn: "@cdktf/provider-google.BigqueryTableRangePartitioningOutputReference", version: "0.6.40" };
function bigqueryTableTimePartitioningToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        expiration_ms: cdktf.numberToTerraform(struct.expirationMs),
        field: cdktf.stringToTerraform(struct.field),
        require_partition_filter: cdktf.booleanToTerraform(struct.requirePartitionFilter),
        type: cdktf.stringToTerraform(struct.type),
    };
}
exports.bigqueryTableTimePartitioningToTerraform = bigqueryTableTimePartitioningToTerraform;
class BigqueryTableTimePartitioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._expirationMs !== undefined) {
            hasAnyValues = true;
            internalValueResult.expirationMs = this._expirationMs;
        }
        if (this._field !== undefined) {
            hasAnyValues = true;
            internalValueResult.field = this._field;
        }
        if (this._requirePartitionFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.requirePartitionFilter = this._requirePartitionFilter;
        }
        if (this._type !== undefined) {
            hasAnyValues = true;
            internalValueResult.type = this._type;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._expirationMs = undefined;
            this._field = undefined;
            this._requirePartitionFilter = undefined;
            this._type = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._expirationMs = value.expirationMs;
            this._field = value.field;
            this._requirePartitionFilter = value.requirePartitionFilter;
            this._type = value.type;
        }
    }
    get expirationMs() {
        return this.getNumberAttribute('expiration_ms');
    }
    set expirationMs(value) {
        this._expirationMs = value;
    }
    resetExpirationMs() {
        this._expirationMs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationMsInput() {
        return this._expirationMs;
    }
    get field() {
        return this.getStringAttribute('field');
    }
    set field(value) {
        this._field = value;
    }
    resetField() {
        this._field = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldInput() {
        return this._field;
    }
    get requirePartitionFilter() {
        return this.getBooleanAttribute('require_partition_filter');
    }
    set requirePartitionFilter(value) {
        this._requirePartitionFilter = value;
    }
    resetRequirePartitionFilter() {
        this._requirePartitionFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirePartitionFilterInput() {
        return this._requirePartitionFilter;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
}
exports.BigqueryTableTimePartitioningOutputReference = BigqueryTableTimePartitioningOutputReference;
_j = JSII_RTTI_SYMBOL_1;
BigqueryTableTimePartitioningOutputReference[_j] = { fqn: "@cdktf/provider-google.BigqueryTableTimePartitioningOutputReference", version: "0.6.40" };
function bigqueryTableViewToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        query: cdktf.stringToTerraform(struct.query),
        use_legacy_sql: cdktf.booleanToTerraform(struct.useLegacySql),
    };
}
exports.bigqueryTableViewToTerraform = bigqueryTableViewToTerraform;
class BigqueryTableViewOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._query !== undefined) {
            hasAnyValues = true;
            internalValueResult.query = this._query;
        }
        if (this._useLegacySql !== undefined) {
            hasAnyValues = true;
            internalValueResult.useLegacySql = this._useLegacySql;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._query = undefined;
            this._useLegacySql = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._query = value.query;
            this._useLegacySql = value.useLegacySql;
        }
    }
    get query() {
        return this.getStringAttribute('query');
    }
    set query(value) {
        this._query = value;
    }
    // Temporarily expose input value. Use with caution.
    get queryInput() {
        return this._query;
    }
    get useLegacySql() {
        return this.getBooleanAttribute('use_legacy_sql');
    }
    set useLegacySql(value) {
        this._useLegacySql = value;
    }
    resetUseLegacySql() {
        this._useLegacySql = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useLegacySqlInput() {
        return this._useLegacySql;
    }
}
exports.BigqueryTableViewOutputReference = BigqueryTableViewOutputReference;
_k = JSII_RTTI_SYMBOL_1;
BigqueryTableViewOutputReference[_k] = { fqn: "@cdktf/provider-google.BigqueryTableViewOutputReference", version: "0.6.40" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table google_bigquery_table}
*/
class BigqueryTable extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table google_bigquery_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryTableConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_bigquery_table',
            terraformGeneratorMetadata: {
                providerName: 'google'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // encryption_configuration - computed: false, optional: true, required: false
        this._encryptionConfiguration = new BigqueryTableEncryptionConfigurationOutputReference(this, "encryption_configuration", true);
        // external_data_configuration - computed: false, optional: true, required: false
        this._externalDataConfiguration = new BigqueryTableExternalDataConfigurationOutputReference(this, "external_data_configuration", true);
        // materialized_view - computed: false, optional: true, required: false
        this._materializedView = new BigqueryTableMaterializedViewOutputReference(this, "materialized_view", true);
        // range_partitioning - computed: false, optional: true, required: false
        this._rangePartitioning = new BigqueryTableRangePartitioningOutputReference(this, "range_partitioning", true);
        // time_partitioning - computed: false, optional: true, required: false
        this._timePartitioning = new BigqueryTableTimePartitioningOutputReference(this, "time_partitioning", true);
        // view - computed: false, optional: true, required: false
        this._view = new BigqueryTableViewOutputReference(this, "view", true);
        this._clustering = config.clustering;
        this._datasetId = config.datasetId;
        this._deletionProtection = config.deletionProtection;
        this._description = config.description;
        this._expirationTime = config.expirationTime;
        this._friendlyName = config.friendlyName;
        this._labels = config.labels;
        this._project = config.project;
        this._schema = config.schema;
        this._tableId = config.tableId;
        this._encryptionConfiguration.internalValue = config.encryptionConfiguration;
        this._externalDataConfiguration.internalValue = config.externalDataConfiguration;
        this._materializedView.internalValue = config.materializedView;
        this._rangePartitioning.internalValue = config.rangePartitioning;
        this._timePartitioning.internalValue = config.timePartitioning;
        this._view.internalValue = config.view;
    }
    get clustering() {
        return this.getListAttribute('clustering');
    }
    set clustering(value) {
        this._clustering = value;
    }
    resetClustering() {
        this._clustering = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusteringInput() {
        return this._clustering;
    }
    // creation_time - computed: true, optional: false, required: false
    get creationTime() {
        return this.getNumberAttribute('creation_time');
    }
    get datasetId() {
        return this.getStringAttribute('dataset_id');
    }
    set datasetId(value) {
        this._datasetId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetIdInput() {
        return this._datasetId;
    }
    get deletionProtection() {
        return this.getBooleanAttribute('deletion_protection');
    }
    set deletionProtection(value) {
        this._deletionProtection = value;
    }
    resetDeletionProtection() {
        this._deletionProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deletionProtectionInput() {
        return this._deletionProtection;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // etag - computed: true, optional: false, required: false
    get etag() {
        return this.getStringAttribute('etag');
    }
    get expirationTime() {
        return this.getNumberAttribute('expiration_time');
    }
    set expirationTime(value) {
        this._expirationTime = value;
    }
    resetExpirationTime() {
        this._expirationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationTimeInput() {
        return this._expirationTime;
    }
    get friendlyName() {
        return this.getStringAttribute('friendly_name');
    }
    set friendlyName(value) {
        this._friendlyName = value;
    }
    resetFriendlyName() {
        this._friendlyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get friendlyNameInput() {
        return this._friendlyName;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    // last_modified_time - computed: true, optional: false, required: false
    get lastModifiedTime() {
        return this.getNumberAttribute('last_modified_time');
    }
    // location - computed: true, optional: false, required: false
    get location() {
        return this.getStringAttribute('location');
    }
    // num_bytes - computed: true, optional: false, required: false
    get numBytes() {
        return this.getNumberAttribute('num_bytes');
    }
    // num_long_term_bytes - computed: true, optional: false, required: false
    get numLongTermBytes() {
        return this.getNumberAttribute('num_long_term_bytes');
    }
    // num_rows - computed: true, optional: false, required: false
    get numRows() {
        return this.getNumberAttribute('num_rows');
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    resetSchema() {
        this._schema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get tableId() {
        return this.getStringAttribute('table_id');
    }
    set tableId(value) {
        this._tableId = value;
    }
    // Temporarily expose input value. Use with caution.
    get tableIdInput() {
        return this._tableId;
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    get encryptionConfiguration() {
        return this._encryptionConfiguration;
    }
    putEncryptionConfiguration(value) {
        this._encryptionConfiguration.internalValue = value;
    }
    resetEncryptionConfiguration() {
        this._encryptionConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionConfigurationInput() {
        return this._encryptionConfiguration.internalValue;
    }
    get externalDataConfiguration() {
        return this._externalDataConfiguration;
    }
    putExternalDataConfiguration(value) {
        this._externalDataConfiguration.internalValue = value;
    }
    resetExternalDataConfiguration() {
        this._externalDataConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalDataConfigurationInput() {
        return this._externalDataConfiguration.internalValue;
    }
    get materializedView() {
        return this._materializedView;
    }
    putMaterializedView(value) {
        this._materializedView.internalValue = value;
    }
    resetMaterializedView() {
        this._materializedView.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get materializedViewInput() {
        return this._materializedView.internalValue;
    }
    get rangePartitioning() {
        return this._rangePartitioning;
    }
    putRangePartitioning(value) {
        this._rangePartitioning.internalValue = value;
    }
    resetRangePartitioning() {
        this._rangePartitioning.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rangePartitioningInput() {
        return this._rangePartitioning.internalValue;
    }
    get timePartitioning() {
        return this._timePartitioning;
    }
    putTimePartitioning(value) {
        this._timePartitioning.internalValue = value;
    }
    resetTimePartitioning() {
        this._timePartitioning.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timePartitioningInput() {
        return this._timePartitioning.internalValue;
    }
    get view() {
        return this._view;
    }
    putView(value) {
        this._view.internalValue = value;
    }
    resetView() {
        this._view.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get viewInput() {
        return this._view.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            clustering: cdktf.listMapper(cdktf.stringToTerraform)(this._clustering),
            dataset_id: cdktf.stringToTerraform(this._datasetId),
            deletion_protection: cdktf.booleanToTerraform(this._deletionProtection),
            description: cdktf.stringToTerraform(this._description),
            expiration_time: cdktf.numberToTerraform(this._expirationTime),
            friendly_name: cdktf.stringToTerraform(this._friendlyName),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            project: cdktf.stringToTerraform(this._project),
            schema: cdktf.stringToTerraform(this._schema),
            table_id: cdktf.stringToTerraform(this._tableId),
            encryption_configuration: bigqueryTableEncryptionConfigurationToTerraform(this._encryptionConfiguration.internalValue),
            external_data_configuration: bigqueryTableExternalDataConfigurationToTerraform(this._externalDataConfiguration.internalValue),
            materialized_view: bigqueryTableMaterializedViewToTerraform(this._materializedView.internalValue),
            range_partitioning: bigqueryTableRangePartitioningToTerraform(this._rangePartitioning.internalValue),
            time_partitioning: bigqueryTableTimePartitioningToTerraform(this._timePartitioning.internalValue),
            view: bigqueryTableViewToTerraform(this._view.internalValue),
        };
    }
}
exports.BigqueryTable = BigqueryTable;
_l = JSII_RTTI_SYMBOL_1;
BigqueryTable[_l] = { fqn: "@cdktf/provider-google.BigqueryTable", version: "0.6.40" };
// =================
// STATIC PROPERTIES
// =================
BigqueryTable.tfResourceType = "google_bigquery_table";
//# sourceMappingURL=data:application/json;base64,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