import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudIdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * An extended description to help users determine the purpose of a Group.
  Must not be longer than 4,096 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#description CloudIdentityGroup#description}
    */
    readonly description?: string;
    /**
    * The display name of the Group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#display_name CloudIdentityGroup#display_name}
    */
    readonly displayName?: string;
    /**
    * The initial configuration options for creating a Group.
  
  See the
  [API reference](https://cloud.google.com/identity/docs/reference/rest/v1beta1/groups/create#initialgroupconfig)
  for possible values. Default value: "EMPTY" Possible values: ["INITIAL_GROUP_CONFIG_UNSPECIFIED", "WITH_INITIAL_OWNER", "EMPTY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#initial_group_config CloudIdentityGroup#initial_group_config}
    */
    readonly initialGroupConfig?: string;
    /**
    * The labels that apply to the Group.
  
  Must not contain more than one entry. Must contain the entry
  'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
  'system/groups/external': '' if the Group is an external-identity-mapped group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#labels CloudIdentityGroup#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
    /**
    * The resource name of the entity under which this Group resides in the
  Cloud Identity resource hierarchy.
  
  Must be of the form identitysources/{identity_source_id} for external-identity-mapped
  groups or customers/{customer_id} for Google Groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#parent CloudIdentityGroup#parent}
    */
    readonly parent: string;
    /**
    * group_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#group_key CloudIdentityGroup#group_key}
    */
    readonly groupKey: CloudIdentityGroupGroupKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#timeouts CloudIdentityGroup#timeouts}
    */
    readonly timeouts?: CloudIdentityGroupTimeouts;
}
export interface CloudIdentityGroupGroupKey {
    /**
    * The ID of the entity.
  
  For Google-managed entities, the id must be the email address of an existing
  group or user.
  
  For external-identity-mapped entities, the id must be a string conforming
  to the Identity Source's requirements.
  
  Must be unique within a namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#id CloudIdentityGroup#id}
    */
    readonly id: string;
    /**
    * The namespace in which the entity exists.
  
  If not specified, the EntityKey represents a Google-managed entity
  such as a Google user or a Google Group.
  
  If specified, the EntityKey represents an external-identity-mapped group.
  The namespace must correspond to an identity source created in Admin Console
  and must be in the form of 'identitysources/{identity_source_id}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#namespace CloudIdentityGroup#namespace}
    */
    readonly namespace?: string;
}
export declare function cloudIdentityGroupGroupKeyToTerraform(struct?: CloudIdentityGroupGroupKeyOutputReference | CloudIdentityGroupGroupKey): any;
export declare class CloudIdentityGroupGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudIdentityGroupGroupKey | undefined;
    set internalValue(value: CloudIdentityGroupGroupKey | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface CloudIdentityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#create CloudIdentityGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#delete CloudIdentityGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#update CloudIdentityGroup#update}
    */
    readonly update?: string;
}
export declare function cloudIdentityGroupTimeoutsToTerraform(struct?: CloudIdentityGroupTimeoutsOutputReference | CloudIdentityGroupTimeouts | cdktf.IResolvable): any;
export declare class CloudIdentityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudIdentityGroupTimeouts | undefined;
    set internalValue(value: CloudIdentityGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group google_cloud_identity_group}
*/
export declare class CloudIdentityGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group google_cloud_identity_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudIdentityGroupConfig
    */
    constructor(scope: Construct, id: string, config: CloudIdentityGroupConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _initialGroupConfig?;
    get initialGroupConfig(): string;
    set initialGroupConfig(value: string);
    resetInitialGroupConfig(): void;
    get initialGroupConfigInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _groupKey;
    get groupKey(): CloudIdentityGroupGroupKeyOutputReference;
    putGroupKey(value: CloudIdentityGroupGroupKey): void;
    get groupKeyInput(): CloudIdentityGroupGroupKey | undefined;
    private _timeouts;
    get timeouts(): CloudIdentityGroupTimeoutsOutputReference;
    putTimeouts(value: CloudIdentityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudIdentityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
