import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeGlobalNetworkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Fully qualified domain name of network endpoint.
  This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#fqdn ComputeGlobalNetworkEndpoint#fqdn}
    */
    readonly fqdn?: string;
    /**
    * The global network endpoint group this endpoint is part of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#global_network_endpoint_group ComputeGlobalNetworkEndpoint#global_network_endpoint_group}
    */
    readonly globalNetworkEndpointGroup: string;
    /**
    * IPv4 address external endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#ip_address ComputeGlobalNetworkEndpoint#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Port number of the external endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#port ComputeGlobalNetworkEndpoint#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#project ComputeGlobalNetworkEndpoint#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#timeouts ComputeGlobalNetworkEndpoint#timeouts}
    */
    readonly timeouts?: ComputeGlobalNetworkEndpointTimeouts;
}
export interface ComputeGlobalNetworkEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#create ComputeGlobalNetworkEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint#delete ComputeGlobalNetworkEndpoint#delete}
    */
    readonly delete?: string;
}
export declare function computeGlobalNetworkEndpointTimeoutsToTerraform(struct?: ComputeGlobalNetworkEndpointTimeoutsOutputReference | ComputeGlobalNetworkEndpointTimeouts | cdktf.IResolvable): any;
export declare class ComputeGlobalNetworkEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeGlobalNetworkEndpointTimeouts | undefined;
    set internalValue(value: ComputeGlobalNetworkEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint google_compute_global_network_endpoint}
*/
export declare class ComputeGlobalNetworkEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint google_compute_global_network_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeGlobalNetworkEndpointConfig
    */
    constructor(scope: Construct, id: string, config: ComputeGlobalNetworkEndpointConfig);
    private _fqdn?;
    get fqdn(): string;
    set fqdn(value: string);
    resetFqdn(): void;
    get fqdnInput(): string | undefined;
    private _globalNetworkEndpointGroup?;
    get globalNetworkEndpointGroup(): string;
    set globalNetworkEndpointGroup(value: string);
    get globalNetworkEndpointGroupInput(): string | undefined;
    get id(): string;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeGlobalNetworkEndpointTimeoutsOutputReference;
    putTimeouts(value: ComputeGlobalNetworkEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeGlobalNetworkEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
