import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires stopping the instance without setting this field, the update will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#allow_stopping_for_update ComputeInstance#allow_stopping_for_update}
    */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
    * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#can_ip_forward ComputeInstance#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Whether deletion protection is enabled on this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#deletion_protection ComputeInstance#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * A brief description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#description ComputeInstance#description}
    */
    readonly description?: string;
    /**
    * Desired status of the instance. Either "RUNNING" or "TERMINATED".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#desired_status ComputeInstance#desired_status}
    */
    readonly desiredStatus?: string;
    /**
    * Whether the instance has virtual displays enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_display ComputeInstance#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#guest_accelerator ComputeInstance#guest_accelerator}
    */
    readonly guestAccelerator?: ComputeInstanceGuestAccelerator[] | cdktf.IResolvable;
    /**
    * A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#hostname ComputeInstance#hostname}
    */
    readonly hostname?: string;
    /**
    * A set of key/value label pairs assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#labels ComputeInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#machine_type ComputeInstance#machine_type}
    */
    readonly machineType: string;
    /**
    * Metadata key/value pairs made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#metadata ComputeInstance#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Metadata startup scripts made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#metadata_startup_script ComputeInstance#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * The minimum CPU platform specified for the VM instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#min_cpu_platform ComputeInstance#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#name ComputeInstance#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#project ComputeInstance#project}
    */
    readonly project?: string;
    /**
    * A list of short names or self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#resource_policies ComputeInstance#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The list of tags attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#tags ComputeInstance#tags}
    */
    readonly tags?: string[];
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#zone ComputeInstance#zone}
    */
    readonly zone?: string;
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#advanced_machine_features ComputeInstance#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: ComputeInstanceAdvancedMachineFeatures;
    /**
    * attached_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#attached_disk ComputeInstance#attached_disk}
    */
    readonly attachedDisk?: ComputeInstanceAttachedDisk[] | cdktf.IResolvable;
    /**
    * boot_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#boot_disk ComputeInstance#boot_disk}
    */
    readonly bootDisk: ComputeInstanceBootDisk;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#confidential_instance_config ComputeInstance#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: ComputeInstanceConfidentialInstanceConfig;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#network_interface ComputeInstance#network_interface}
    */
    readonly networkInterface: ComputeInstanceNetworkInterface[] | cdktf.IResolvable;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#reservation_affinity ComputeInstance#reservation_affinity}
    */
    readonly reservationAffinity?: ComputeInstanceReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#scheduling ComputeInstance#scheduling}
    */
    readonly scheduling?: ComputeInstanceScheduling;
    /**
    * scratch_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#scratch_disk ComputeInstance#scratch_disk}
    */
    readonly scratchDisk?: ComputeInstanceScratchDisk[] | cdktf.IResolvable;
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#service_account ComputeInstance#service_account}
    */
    readonly serviceAccount?: ComputeInstanceServiceAccount;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#shielded_instance_config ComputeInstance#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ComputeInstanceShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#timeouts ComputeInstance#timeouts}
    */
    readonly timeouts?: ComputeInstanceTimeouts;
}
export interface ComputeInstanceGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#count ComputeInstance#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#type ComputeInstance#type}
    */
    readonly type?: string;
}
export declare function computeInstanceGuestAcceleratorToTerraform(struct?: ComputeInstanceGuestAccelerator | cdktf.IResolvable): any;
export interface ComputeInstanceAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_nested_virtualization ComputeInstance#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#threads_per_core ComputeInstance#threads_per_core}
    */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceAdvancedMachineFeaturesOutputReference | ComputeInstanceAdvancedMachineFeatures): any;
export declare class ComputeInstanceAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceAdvancedMachineFeatures | undefined;
    set internalValue(value: ComputeInstanceAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
}
export interface ComputeInstanceAttachedDisk {
    /**
    * Name with which the attached disk is accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#device_name ComputeInstance#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#kms_key_self_link ComputeInstance#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#mode ComputeInstance#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#source ComputeInstance#source}
    */
    readonly source: string;
}
export declare function computeInstanceAttachedDiskToTerraform(struct?: ComputeInstanceAttachedDisk | cdktf.IResolvable): any;
export interface ComputeInstanceBootDiskInitializeParams {
    /**
    * The image from which this disk was initialised.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#image ComputeInstance#image}
    */
    readonly image?: string;
    /**
    * A set of key/value label pairs assigned to the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#labels ComputeInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The size of the image in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#size ComputeInstance#size}
    */
    readonly size?: number;
    /**
    * The Google Compute Engine disk type. One of pd-standard, pd-ssd or pd-balanced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#type ComputeInstance#type}
    */
    readonly type?: string;
}
export declare function computeInstanceBootDiskInitializeParamsToTerraform(struct?: ComputeInstanceBootDiskInitializeParamsOutputReference | ComputeInstanceBootDiskInitializeParams): any;
export declare class ComputeInstanceBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceBootDiskInitializeParams | undefined;
    set internalValue(value: ComputeInstanceBootDiskInitializeParams | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ComputeInstanceBootDisk {
    /**
    * Whether the disk will be auto-deleted when the instance is deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#auto_delete ComputeInstance#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Name with which attached disk will be accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#device_name ComputeInstance#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#kms_key_self_link ComputeInstance#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#mode ComputeInstance#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#source ComputeInstance#source}
    */
    readonly source?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#initialize_params ComputeInstance#initialize_params}
    */
    readonly initializeParams?: ComputeInstanceBootDiskInitializeParams;
}
export declare function computeInstanceBootDiskToTerraform(struct?: ComputeInstanceBootDiskOutputReference | ComputeInstanceBootDisk): any;
export declare class ComputeInstanceBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceBootDisk | undefined;
    set internalValue(value: ComputeInstanceBootDisk | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    get diskEncryptionKeySha256(): string;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): ComputeInstanceBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: ComputeInstanceBootDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): ComputeInstanceBootDiskInitializeParams | undefined;
}
export interface ComputeInstanceConfidentialInstanceConfig {
    /**
    * Defines whether the instance should have confidential compute enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_confidential_compute ComputeInstance#enable_confidential_compute}
    */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceConfidentialInstanceConfigOutputReference | ComputeInstanceConfidentialInstanceConfig): any;
export declare class ComputeInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceConfidentialInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceNetworkInterfaceAccessConfig {
    /**
    * The IP address that is be 1:1 mapped to the instance's network ip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#nat_ip ComputeInstance#nat_ip}
    */
    readonly natIp?: string;
    /**
    * The networking tier used for configuring this instance. One of PREMIUM or STANDARD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#network_tier ComputeInstance#network_tier}
    */
    readonly networkTier?: string;
    /**
    * The DNS domain name for the public PTR record.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export interface ComputeInstanceNetworkInterfaceAliasIpRange {
    /**
    * The IP CIDR range represented by this alias IP range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#ip_cidr_range ComputeInstance#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#subnetwork_range_name ComputeInstance#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export interface ComputeInstanceNetworkInterfaceIpv6AccessConfig {
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#network_tier ComputeInstance#network_tier}
    */
    readonly networkTier: string;
    /**
    * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function computeInstanceNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export interface ComputeInstanceNetworkInterface {
    /**
    * The name or self_link of the network attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#network ComputeInstance#network}
    */
    readonly network?: string;
    /**
    * The private IP address assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#network_ip ComputeInstance#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#nic_type ComputeInstance#nic_type}
    */
    readonly nicType?: string;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#stack_type ComputeInstance#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name or self_link of the subnetwork attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#subnetwork ComputeInstance#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The project in which the subnetwork belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#subnetwork_project ComputeInstance#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#access_config ComputeInstance#access_config}
    */
    readonly accessConfig?: ComputeInstanceNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * alias_ip_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#alias_ip_range ComputeInstance#alias_ip_range}
    */
    readonly aliasIpRange?: ComputeInstanceNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#ipv6_access_config ComputeInstance#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: ComputeInstanceNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function computeInstanceNetworkInterfaceToTerraform(struct?: ComputeInstanceNetworkInterface | cdktf.IResolvable): any;
export interface ComputeInstanceReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#key ComputeInstance#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#values ComputeInstance#values}
    */
    readonly values: string[];
}
export declare function computeInstanceReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceReservationAffinitySpecificReservationOutputReference | ComputeInstanceReservationAffinitySpecificReservation): any;
export declare class ComputeInstanceReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceReservationAffinitySpecificReservation | undefined;
    set internalValue(value: ComputeInstanceReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ComputeInstanceReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#type ComputeInstance#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#specific_reservation ComputeInstance#specific_reservation}
    */
    readonly specificReservation?: ComputeInstanceReservationAffinitySpecificReservation;
}
export declare function computeInstanceReservationAffinityToTerraform(struct?: ComputeInstanceReservationAffinityOutputReference | ComputeInstanceReservationAffinity): any;
export declare class ComputeInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceReservationAffinity | undefined;
    set internalValue(value: ComputeInstanceReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): ComputeInstanceReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: ComputeInstanceReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): ComputeInstanceReservationAffinitySpecificReservation | undefined;
}
export interface ComputeInstanceSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#key ComputeInstance#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#operator ComputeInstance#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#values ComputeInstance#values}
    */
    readonly values: string[];
}
export declare function computeInstanceSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceSchedulingNodeAffinities | cdktf.IResolvable): any;
export interface ComputeInstanceScheduling {
    /**
    * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#automatic_restart ComputeInstance#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#min_node_cpus ComputeInstance#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#on_host_maintenance ComputeInstance#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Whether the instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#preemptible ComputeInstance#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#node_affinities ComputeInstance#node_affinities}
    */
    readonly nodeAffinities?: ComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function computeInstanceSchedulingToTerraform(struct?: ComputeInstanceSchedulingOutputReference | ComputeInstanceScheduling): any;
export declare class ComputeInstanceSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceScheduling | undefined;
    set internalValue(value: ComputeInstanceScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    get nodeAffinities(): ComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable;
    set nodeAffinities(value: ComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable);
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | ComputeInstanceSchedulingNodeAffinities[] | undefined;
}
export interface ComputeInstanceScratchDisk {
    /**
    * The disk interface used for attaching this disk. One of SCSI or NVME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#interface ComputeInstance#interface}
    */
    readonly interface: string;
}
export declare function computeInstanceScratchDiskToTerraform(struct?: ComputeInstanceScratchDisk | cdktf.IResolvable): any;
export interface ComputeInstanceServiceAccount {
    /**
    * The service account e-mail address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#email ComputeInstance#email}
    */
    readonly email?: string;
    /**
    * A list of service scopes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#scopes ComputeInstance#scopes}
    */
    readonly scopes: string[];
}
export declare function computeInstanceServiceAccountToTerraform(struct?: ComputeInstanceServiceAccountOutputReference | ComputeInstanceServiceAccount): any;
export declare class ComputeInstanceServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceServiceAccount | undefined;
    set internalValue(value: ComputeInstanceServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
}
export interface ComputeInstanceShieldedInstanceConfig {
    /**
    * Whether integrity monitoring is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_integrity_monitoring ComputeInstance#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether secure boot is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_secure_boot ComputeInstance#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance uses vTPM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#enable_vtpm ComputeInstance#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceShieldedInstanceConfigToTerraform(struct?: ComputeInstanceShieldedInstanceConfigOutputReference | ComputeInstanceShieldedInstanceConfig): any;
export declare class ComputeInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#create ComputeInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#delete ComputeInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance#update ComputeInstance#update}
    */
    readonly update?: string;
}
export declare function computeInstanceTimeoutsToTerraform(struct?: ComputeInstanceTimeoutsOutputReference | ComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare class ComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeInstanceTimeouts | undefined;
    set internalValue(value: ComputeInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance google_compute_instance}
*/
export declare class ComputeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance google_compute_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeInstanceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeInstanceConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string;
    set desiredStatus(value: string);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ComputeInstanceGuestAccelerator[] | cdktf.IResolvable;
    set guestAccelerator(value: ComputeInstanceGuestAccelerator[] | cdktf.IResolvable);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ComputeInstanceGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    get id(): string;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): ComputeInstanceAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: ComputeInstanceAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): ComputeInstanceAdvancedMachineFeatures | undefined;
    private _attachedDisk?;
    get attachedDisk(): ComputeInstanceAttachedDisk[] | cdktf.IResolvable;
    set attachedDisk(value: ComputeInstanceAttachedDisk[] | cdktf.IResolvable);
    resetAttachedDisk(): void;
    get attachedDiskInput(): cdktf.IResolvable | ComputeInstanceAttachedDisk[] | undefined;
    private _bootDisk;
    get bootDisk(): ComputeInstanceBootDiskOutputReference;
    putBootDisk(value: ComputeInstanceBootDisk): void;
    get bootDiskInput(): ComputeInstanceBootDisk | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): ComputeInstanceConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: ComputeInstanceConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): ComputeInstanceConfidentialInstanceConfig | undefined;
    private _networkInterface?;
    get networkInterface(): ComputeInstanceNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: ComputeInstanceNetworkInterface[] | cdktf.IResolvable);
    get networkInterfaceInput(): cdktf.IResolvable | ComputeInstanceNetworkInterface[] | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ComputeInstanceReservationAffinityOutputReference;
    putReservationAffinity(value: ComputeInstanceReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ComputeInstanceReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): ComputeInstanceSchedulingOutputReference;
    putScheduling(value: ComputeInstanceScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): ComputeInstanceScheduling | undefined;
    private _scratchDisk?;
    get scratchDisk(): ComputeInstanceScratchDisk[] | cdktf.IResolvable;
    set scratchDisk(value: ComputeInstanceScratchDisk[] | cdktf.IResolvable);
    resetScratchDisk(): void;
    get scratchDiskInput(): cdktf.IResolvable | ComputeInstanceScratchDisk[] | undefined;
    private _serviceAccount;
    get serviceAccount(): ComputeInstanceServiceAccountOutputReference;
    putServiceAccount(value: ComputeInstanceServiceAccount): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): ComputeInstanceServiceAccount | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ComputeInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ComputeInstanceShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ComputeInstanceShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): ComputeInstanceTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
