import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeProjectMetadataItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * The metadata key to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#key ComputeProjectMetadataItem#key}
    */
    readonly key: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#project ComputeProjectMetadataItem#project}
    */
    readonly project?: string;
    /**
    * The value to set for the given metadata key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#value ComputeProjectMetadataItem#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#timeouts ComputeProjectMetadataItem#timeouts}
    */
    readonly timeouts?: ComputeProjectMetadataItemTimeouts;
}
export interface ComputeProjectMetadataItemTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#create ComputeProjectMetadataItem#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#delete ComputeProjectMetadataItem#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item#update ComputeProjectMetadataItem#update}
    */
    readonly update?: string;
}
export declare function computeProjectMetadataItemTimeoutsToTerraform(struct?: ComputeProjectMetadataItemTimeoutsOutputReference | ComputeProjectMetadataItemTimeouts | cdktf.IResolvable): any;
export declare class ComputeProjectMetadataItemTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeProjectMetadataItemTimeouts | undefined;
    set internalValue(value: ComputeProjectMetadataItemTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item google_compute_project_metadata_item}
*/
export declare class ComputeProjectMetadataItem extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item google_compute_project_metadata_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeProjectMetadataItemConfig
    */
    constructor(scope: Construct, id: string, config: ComputeProjectMetadataItemConfig);
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeProjectMetadataItemTimeoutsOutputReference;
    putTimeouts(value: ComputeProjectMetadataItemTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeProjectMetadataItemTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
