import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork#name DataGoogleComputeSubnetwork#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork#project DataGoogleComputeSubnetwork#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork#region DataGoogleComputeSubnetwork#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork#self_link DataGoogleComputeSubnetwork#self_link}
    */
    readonly selfLink?: string;
}
export declare class DataGoogleComputeSubnetworkSecondaryIpRange extends cdktf.ComplexComputedList {
    get ipCidrRange(): string;
    get rangeName(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork google_compute_subnetwork}
*/
export declare class DataGoogleComputeSubnetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork google_compute_subnetwork} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeSubnetworkConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeSubnetworkConfig);
    get description(): string;
    get gatewayAddress(): string;
    get id(): string;
    get ipCidrRange(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get privateIpGoogleAccess(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    secondaryIpRange(index: string): DataGoogleComputeSubnetworkSecondaryIpRange;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
