import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDnsKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#managed_zone DataGoogleDnsKeys#managed_zone}
    */
    readonly managedZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#project DataGoogleDnsKeys#project}
    */
    readonly project?: string;
}
export declare class DataGoogleDnsKeysKeySigningKeysDigests extends cdktf.ComplexComputedList {
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysKeySigningKeys extends cdktf.ComplexComputedList {
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    get digests(): cdktf.IResolvable;
    get dsRecord(): string;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
}
export declare class DataGoogleDnsKeysZoneSigningKeysDigests extends cdktf.ComplexComputedList {
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysZoneSigningKeys extends cdktf.ComplexComputedList {
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    get digests(): cdktf.IResolvable;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys}
*/
export declare class DataGoogleDnsKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDnsKeysConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleDnsKeysConfig);
    get id(): string;
    keySigningKeys(index: string): DataGoogleDnsKeysKeySigningKeys;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    zoneSigningKeys(index: string): DataGoogleDnsKeysZoneSigningKeys;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
