import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringMeshIstioServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier for the mesh in which this Istio service is defined.
                          Corresponds to the meshUid metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service#mesh_uid DataGoogleMonitoringMeshIstioService#mesh_uid}
    */
    readonly meshUid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service#project DataGoogleMonitoringMeshIstioService#project}
    */
    readonly project?: string;
    /**
    * The name of the Istio service underlying this service.
                          Corresponds to the destination_service_name metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service#service_name DataGoogleMonitoringMeshIstioService#service_name}
    */
    readonly serviceName: string;
    /**
    * The namespace of the Istio service underlying this service.
                          Corresponds to the destination_service_namespace metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service#service_namespace DataGoogleMonitoringMeshIstioService#service_namespace}
    */
    readonly serviceNamespace: string;
}
export declare class DataGoogleMonitoringMeshIstioServiceTelemetry extends cdktf.ComplexComputedList {
    get resourceName(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service google_monitoring_mesh_istio_service}
*/
export declare class DataGoogleMonitoringMeshIstioService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_mesh_istio_service google_monitoring_mesh_istio_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleMonitoringMeshIstioServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringMeshIstioServiceConfig);
    get displayName(): string;
    get id(): string;
    private _meshUid?;
    get meshUid(): string;
    set meshUid(value: string);
    get meshUidInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _serviceNamespace?;
    get serviceNamespace(): string;
    set serviceNamespace(value: string);
    get serviceNamespaceInput(): string | undefined;
    telemetry(index: string): DataGoogleMonitoringMeshIstioServiceTelemetry;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
