import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/projects#filter DataGoogleProjects#filter}
    */
    readonly filter: string;
}
export declare class DataGoogleProjectsProjects extends cdktf.ComplexComputedList {
    get createTime(): string;
    get labels(): {
        [key: string]: string;
    };
    get lifecycleState(): string;
    get name(): string;
    get number(): string;
    get parent(): {
        [key: string]: string;
    };
    get projectId(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/projects google_projects}
*/
export declare class DataGoogleProjects extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/projects google_projects} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleProjectsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleProjectsConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    projects(index: string): DataGoogleProjectsProjects;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
